
var Q = require("./qlite");

function down(i) {
    if (!i)
        return;
    return Q.all([
        i - 1
    ])
    .get(0)
    .then(down)
}

down(1000)
.then(function () {
    console.log(Q.pool.length);
    console.log(process.memoryUsage().heapUsed)
})
.end()

// Q:
//     real    0m0.936s
//     user    0m0.854s
//     sys 0m0.078s
//     heap used 16005448
// 
// Q-Lite:
//     real    0m0.479s
//     user    0m0.433s
//     sys 0m0.043s
//     heap used 10850712

