/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.SortedSet;
import org.apache.rat.api.Document;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;

public class IgnoredDocument
extends Document {
    public IgnoredDocument(DocumentName basedir, File file, DocumentNameMatcher nameMatcher) {
        super(DocumentName.builder(file).setBaseName(basedir.getBaseName()).build(), nameMatcher);
        this.getMetaData().setDocumentType(Document.Type.IGNORED);
        this.getMetaData().setIsDirectory(file.isDirectory());
    }

    @Override
    public boolean isDirectory() {
        return this.getMetaData().isDirectory();
    }

    @Override
    public SortedSet<Document> listChildren() {
        return Collections.emptySortedSet();
    }

    @Override
    public InputStream inputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }
}

