/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.claim.impl;

import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.api.RatException;
import org.apache.rat.report.AbstractReport;

public abstract class AbstractClaimReporter
extends AbstractReport {
    protected void handleDocumentCategoryClaim(String documentCategoryName) {
    }

    protected void handleApprovedLicenseClaim(String licenseApproved) {
    }

    protected void handleLicenseFamilyNameClaim(String licenseFamilyName) {
    }

    protected void handleHeaderCategoryClaim(String headerCategory) {
    }

    private void writeDocumentClaim(Document subject) {
        MetaData metaData = subject.getMetaData();
        this.writeHeaderCategory(metaData);
        this.writeLicenseFamilyName(metaData);
        this.writeDocumentCategory(metaData);
        this.writeApprovedLicenseClaim(metaData);
    }

    private void writeApprovedLicenseClaim(MetaData metaData) {
        String approvedLicense;
        MetaData.Datum approvedLicenseDatum = metaData.get("http://org/apache/rat/meta-data#ApprovedLicense");
        if (approvedLicenseDatum != null && (approvedLicense = approvedLicenseDatum.getValue()) != null) {
            this.handleApprovedLicenseClaim(approvedLicense);
        }
    }

    private void writeHeaderCategory(MetaData metaData) {
        String headerCategory;
        MetaData.Datum headerCategoryDatum = metaData.get("http://org/apache/rat/meta-data#HeaderCategory");
        if (headerCategoryDatum != null && (headerCategory = headerCategoryDatum.getValue()) != null) {
            this.handleHeaderCategoryClaim(headerCategory);
        }
    }

    private void writeLicenseFamilyName(MetaData metaData) {
        String licenseFamilyName;
        MetaData.Datum licenseFamilyNameDatum = metaData.get("http://org/apache/rat/meta-data#LicenseFamilyName");
        if (licenseFamilyNameDatum != null && (licenseFamilyName = licenseFamilyNameDatum.getValue()) != null) {
            this.handleLicenseFamilyNameClaim(licenseFamilyName);
        }
    }

    private void writeDocumentCategory(MetaData metaData) {
        String documentCategory;
        MetaData.Datum documentCategoryDatum = metaData.get("http://org/apache/rat/meta-data#FileCategory");
        if (documentCategoryDatum != null && (documentCategory = documentCategoryDatum.getValue()) != null) {
            this.handleDocumentCategoryClaim(documentCategory);
        }
    }

    public void report(Document subject) throws RatException {
        this.writeDocumentClaim(subject);
    }
}

