/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.continuations;

import org.apache.cxf.Bus;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.continuations.Counter;
import org.apache.cxf.transport.jms.continuations.JMSContinuation;

public class JMSContinuationProvider
implements ContinuationProvider {
    private Bus bus;
    private Message inMessage;
    private MessageObserver incomingObserver;
    private Counter suspendendContinuations;

    public JMSContinuationProvider(Bus b, Message m, MessageObserver observer, Counter suspendendContinuations) {
        this.bus = b;
        this.inMessage = m;
        this.incomingObserver = observer;
        this.suspendendContinuations = suspendendContinuations;
    }

    public void complete() {
        JMSContinuation cw = (JMSContinuation)this.inMessage.get(JMSContinuation.class);
        if (cw != null) {
            cw.reset();
        }
    }

    public Continuation getContinuation() {
        Message m = this.inMessage;
        if (m != null && m.getExchange() != null && m.getExchange().getInMessage() != null) {
            m = m.getExchange().getInMessage();
        }
        if (m == null || m.getExchange() == null || m.getExchange().isOneWay()) {
            return null;
        }
        JMSContinuation cw = (JMSContinuation)m.get(JMSContinuation.class);
        if (cw == null) {
            cw = new JMSContinuation(this.bus, m, this.incomingObserver, this.suspendendContinuations);
            m.put(JMSContinuation.class, (Object)cw);
        }
        return cw;
    }
}

