/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.function.Supplier;
import org.apache.activemq.artemis.utils.HashProcessor;
import org.apache.activemq.artemis.utils.Suppliers;

public abstract class LazyHashProcessor
implements HashProcessor {
    private Supplier<HashProcessor> hashProcessorSupplier = Suppliers.memoize(() -> {
        try {
            return this.createHashProcessor();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    });

    @Override
    public String hash(String plainText) throws Exception {
        return this.hashProcessorSupplier.get().hash(plainText);
    }

    @Override
    public boolean compare(char[] inputValue, String storedHash) {
        return this.hashProcessorSupplier.get().compare(inputValue, storedHash);
    }

    protected abstract HashProcessor createHashProcessor() throws Exception;
}

