/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class JMSSender {
    private boolean explicitQosEnabled;
    private int deliveryMode;
    private int priority;
    private long timeToLive;

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Session session, Destination targetDest, Message message) throws JMSException {
        MessageProducer producer = null;
        try {
            producer = session.createProducer(targetDest);
            if (this.explicitQosEnabled) {
                producer.send(message, this.deliveryMode, this.priority, this.timeToLive);
            } else {
                producer.send(message);
            }
        }
        finally {
            ResourceCloser.close(producer);
        }
    }
}

