/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.CompressedWhitespace;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.value.StringValue;

public final class WhitespaceTextImpl
extends TinyNodeImpl {
    public WhitespaceTextImpl(TinyTree tree, int nodeNr) {
        super(tree, nodeNr);
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        long value = (long)this.tree.alpha[this.nodeNr] << 32 | (long)this.tree.beta[this.nodeNr] & 0xFFFFFFFFL;
        return new CompressedWhitespace(value);
    }

    public static UnicodeString getStringValue(TinyTree tree, int nodeNr) {
        long value = (long)tree.alpha[nodeNr] << 32 | (long)tree.beta[nodeNr] & 0xFFFFFFFFL;
        return new CompressedWhitespace(value);
    }

    public static void appendStringValue(TinyTree tree, int nodeNr, UnicodeBuilder buffer) {
        long value = (long)tree.alpha[nodeNr] << 32 | (long)tree.beta[nodeNr] & 0xFFFFFFFFL;
        buffer.append(CompressedWhitespace.uncompress(value));
    }

    @Override
    public StringValue atomize() {
        return StringValue.makeUntypedAtomic(this.getUnicodeStringValue());
    }

    public static long getLongValue(TinyTree tree, int nodeNr) {
        return (long)tree.alpha[nodeNr] << 32 | (long)tree.beta[nodeNr] & 0xFFFFFFFFL;
    }

    @Override
    public final int getNodeKind() {
        return 3;
    }

    @Override
    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        out.characters(this.getUnicodeStringValue(), locationId, 0);
    }
}

