/*
 * Decompiled with CFR 0.152.
 */
package os;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import os.BasePath;
import os.BasePathImpl;
import os.FilePath;
import os.Internals$;
import os.Path$;
import os.PathChunk;
import os.PathConvertible;
import os.PathConvertible$NioPathConvertible$;
import os.PathError$AbsolutePathOutsideRoot$;
import os.ReadablePath;
import os.RelPath;
import os.SeekableSource;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals$;
import scala.util.DynamicVariable;

public class Path
implements BasePath,
FilePath,
ReadablePath,
BasePathImpl {
    private final java.nio.file.Path wrapped;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Path$.class.getDeclaredField("driveRoot$lzy1"));

    public static Path apply(FilePath filePath, Path path) {
        return Path$.MODULE$.apply(filePath, path);
    }

    public static <T> Path apply(T t, Path path, PathConvertible<T> pathConvertible) {
        return Path$.MODULE$.apply(t, path, pathConvertible);
    }

    public static <T> Path apply(T t, PathConvertible<T> pathConvertible) {
        return Path$.MODULE$.apply(t, pathConvertible);
    }

    public static <T> boolean driveRelative(T t, PathConvertible<T> pathConvertible) {
        return Path$.MODULE$.driveRelative(t, pathConvertible);
    }

    public static String driveRoot() {
        return Path$.MODULE$.driveRoot();
    }

    public static <T> Path expandUser(T t, Path path, PathConvertible<T> pathConvertible) {
        return Path$.MODULE$.expandUser(t, path, pathConvertible);
    }

    public static Ordering<Path> pathOrdering() {
        return Path$.MODULE$.pathOrdering();
    }

    public static DynamicVariable<Serializer> pathSerializer() {
        return Path$.MODULE$.pathSerializer();
    }

    public static PathChunk stringToPathChunk(String string) {
        return Path$.MODULE$.stringToPathChunk(string);
    }

    public static <T> Path expandUser$default$2() {
        return Path$.MODULE$.expandUser$default$2();
    }

    public Path(java.nio.file.Path wrapped) {
        this.wrapped = wrapped;
        Predef$.MODULE$.require(wrapped.isAbsolute() || Path$.MODULE$.driveRelative(wrapped, PathConvertible$NioPathConvertible$.MODULE$), () -> Path.$init$$$anonfun$5(wrapped));
    }

    public java.nio.file.Path wrapped() {
        return this.wrapped;
    }

    @Override
    public SeekableSource toSource() {
        return new SeekableSource.ChannelLengthSource(Files.newByteChannel(this.wrapped(), new OpenOption[0]), Files.size(this.wrapped()));
    }

    public String root() {
        return (String)Option$.MODULE$.apply((Object)this.wrapped().getRoot()).map((Function1 & Serializable)_$7 -> _$7.toString()).getOrElse(Path::root$$anonfun$2);
    }

    public FileSystem fileSystem() {
        return this.wrapped().getFileSystem();
    }

    public Iterator<String> segments() {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.wrapped().iterator()).asScala()).map((Function1 & Serializable)_$8 -> _$8.toString());
    }

    public String getSegment(int i) {
        return this.wrapped().getName(i).toString();
    }

    public int segmentCount() {
        return this.wrapped().getNameCount();
    }

    @Override
    public Option<String> lastOpt() {
        return Option$.MODULE$.apply((Object)this.wrapped().getFileName()).map((Function1 & Serializable)_$9 -> _$9.toString());
    }

    @Override
    public Path $div(PathChunk chunk) {
        if (chunk.ups() > this.wrapped().getNameCount()) {
            throw PathError$AbsolutePathOutsideRoot$.MODULE$;
        }
        java.nio.file.Path resolved = this.wrapped().resolve(chunk.toString()).normalize();
        return new Path(resolved);
    }

    public String toString() {
        return ((Serializer)Path$.MODULE$.pathSerializer().value()).serializeString(this);
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof Path) {
            Path p = (Path)object;
            return this.wrapped().equals(p.wrapped());
        }
        return false;
    }

    public int hashCode() {
        return this.wrapped().hashCode();
    }

    public boolean startsWith(Path target) {
        return this.wrapped().startsWith(target.wrapped());
    }

    @Override
    public boolean endsWith(RelPath target) {
        return this.wrapped().endsWith(target.toString());
    }

    public RelPath relativeTo(Path base) {
        int n;
        Object[] arr;
        String string;
        Object object;
        FileSystem fileSystem = this.fileSystem();
        FileSystem fileSystem2 = base.fileSystem();
        if (fileSystem == null ? fileSystem2 != null : !fileSystem.equals(fileSystem2)) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Paths ").append(this.wrapped()).append(" and ").append(base).append(" are on different filesystems").toString());
        }
        java.nio.file.Path nioRel = base.wrapped().relativize(this.wrapped());
        Object[] objectArray = (String[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(nioRel.iterator()).asScala()).map((Function1 & Serializable)_$10 -> _$10.toString()).toArray(ClassTag$.MODULE$.apply(String.class));
        Object[] segments = objectArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)objectArray), 1) == 0 && "".equals(string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0)) ? Internals$.MODULE$.emptyStringArray() : (arr = objectArray);
        Object object2 = Predef$.MODULE$.refArrayOps(segments);
        int n2 = ArrayOps$.MODULE$.indexWhere$extension(object2, (Function1 & Serializable)_$11 -> {
            String string = _$11;
            String string2 = "..";
            return string == null ? string2 != null : !string.equals(string2);
        }, ArrayOps$.MODULE$.indexWhere$default$2$extension(object2));
        int nonUpIndex = -1 == n2 ? segments.length : (n = n2);
        Object object3 = Predef$.MODULE$.refArrayOps(segments);
        return new RelPath((String[])ArrayOps$.MODULE$.drop$extension(object3, nonUpIndex), nonUpIndex);
    }

    public File toIO() {
        return ((Serializer)Path$.MODULE$.pathSerializer().value()).serializeFile(this);
    }

    @Override
    public java.nio.file.Path toNIO() {
        return ((Serializer)Path$.MODULE$.pathSerializer().value()).serializePath(this);
    }

    public URI toURI() {
        return this.toNIO().toUri();
    }

    public URL toURL() {
        return this.toURI().toURL();
    }

    @Override
    public Path resolveFrom(Path base) {
        return this;
    }

    @Override
    public InputStream getInputStream() {
        return Files.newInputStream(this.wrapped(), new OpenOption[0]);
    }

    private static final Object $init$$$anonfun$5(java.nio.file.Path wrapped$1) {
        return new StringBuilder(24).append(wrapped$1).append(" is not an absolute path").toString();
    }

    private static final String root$$anonfun$2() {
        return "";
    }

    public static interface Serializer {
        public String serializeString(Path var1);

        public File serializeFile(Path var1);

        public java.nio.file.Path serializePath(Path var1);

        public java.nio.file.Path deserialize(String var1);

        public java.nio.file.Path deserialize(File var1);

        public java.nio.file.Path deserialize(java.nio.file.Path var1);

        public java.nio.file.Path deserialize(URI var1);
    }
}

