/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.List;
import java.util.Random;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToMeansUDF;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesSketchToMeansUDFTest {
    @Test
    public void nullSketch() {
        List result = new ArrayOfDoublesSketchToMeansUDF().evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptySketch() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        List result = new ArrayOfDoublesSketchToMeansUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()));
        Assert.assertNull((Object)result);
    }

    @Test
    public void oneEntrySketch() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        List result = new ArrayOfDoublesSketchToMeansUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertEquals((double)((Double)result.get(0)), (double)1.0);
    }

    @Test
    public void manyEntriesTwoValuesSketch() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        Random rand = new Random(0L);
        int numKeys = 10000;
        for (int i = 0; i < numKeys; ++i) {
            sketch.update((long)i, new double[]{rand.nextGaussian(), rand.nextGaussian() + 1.0});
        }
        Assert.assertTrue((sketch.getRetainedEntries() >= 4096 ? 1 : 0) != 0);
        List result = new ArrayOfDoublesSketchToMeansUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)2);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.0, (double)0.04);
        Assert.assertEquals((double)((Double)result.get(1)), (double)1.0, (double)0.04);
    }
}

