/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.ReadOnlyException;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.annotations.Test;

public class MemoryReadWriteSafetyTest {
    final WritableMemory mem = (WritableMemory)Memory.wrap((byte[])new byte[8]);

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutByte() {
        this.mem.putByte(0L, (byte)1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutBoolean() {
        this.mem.putBoolean(0L, true);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutShort() {
        this.mem.putShort(0L, (short)1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutChar() {
        this.mem.putChar(0L, '\u0001');
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutInt() {
        this.mem.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutLong() {
        this.mem.putLong(0L, 1L);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutFloat() {
        this.mem.putFloat(0L, 1.0f);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutDouble() {
        this.mem.putDouble(0L, 1.0);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutByteArray() {
        this.mem.putByteArray(0L, new byte[]{1}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutShortArray() {
        this.mem.putShortArray(0L, new short[]{1}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutCharArray() {
        this.mem.putCharArray(0L, new char[]{'\u0001'}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutIntArray() {
        this.mem.putIntArray(0L, new int[]{1}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutLongArray() {
        this.mem.putLongArray(0L, new long[]{1L}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutFloatArray() {
        this.mem.putFloatArray(0L, new float[]{1.0f}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testDoubleByteArray() {
        this.mem.putDoubleArray(0L, new double[]{1.0}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testWritableMemoryRegion() {
        WritableMemory mem1 = (WritableMemory)WritableMemory.allocate((int)8).region(0L, 8L);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testByteArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((byte[])new byte[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testByteArrayWrapWithBO() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((byte[])new byte[8], (ByteOrder)ByteOrder.nativeOrder());
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testByteArrayWrapWithOffsetsAndBO() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((byte[])new byte[8], (int)0, (int)4, (ByteOrder)ByteOrder.nativeOrder());
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testShortArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((short[])new short[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testCharArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((char[])new char[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testIntArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((int[])new int[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testLongArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((long[])new long[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testFloatArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((float[])new float[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testDoubleArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((double[])new double[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testByteBufferWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((ByteBuffer)ByteBuffer.allocate(8));
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testMapFile() throws Exception {
        File tempFile;
        try {
            tempFile = File.createTempFile("test", ".tmp", null);
            Files.write(tempFile.toPath(), "ipsum".getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
        try (Memory mem = Memory.map((File)tempFile);){
            ((WritableMemory)mem).putInt(0L, 1);
        }
        tempFile.delete();
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testWritableMapWithROFile() throws IOException {
        File tempFile;
        try {
            tempFile = File.createTempFile("test", ".tmp", null);
            Files.write(tempFile.toPath(), "ipsum".getBytes(), StandardOpenOption.APPEND);
            tempFile.setReadOnly();
        }
        catch (IOException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
        try (WritableMemory mem = WritableMemory.writableMap((File)tempFile);){
            mem.putInt(0L, 1);
        }
        tempFile.delete();
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testMapFileWithOffsetsAndBO() throws IOException {
        File tempFile;
        try {
            tempFile = File.createTempFile("test", ".tmp", null);
            Files.write(tempFile.toPath(), "ipsum".getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
        try (Memory mem = Memory.map((File)tempFile, (long)0L, (long)4L, (ByteOrder)ByteOrder.nativeOrder());){
            ((WritableMemory)mem).putInt(0L, 1);
        }
        tempFile.delete();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMapFileBeyondTheFileSize() throws IOException {
        File tempFile;
        try {
            tempFile = File.createTempFile("test", ".tmp", null);
            Files.write(tempFile.toPath(), "ipsum".getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
        Memory mem = Memory.map((File)tempFile, (long)0L, (long)16L, (ByteOrder)ByteOrder.nativeOrder());
        Throwable throwable = null;
        if (mem != null) {
            if (throwable != null) {
                try {
                    mem.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                mem.close();
            }
        }
        tempFile.delete();
    }
}

