/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryBoundsException;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UtilTest {
    private static final String LS = System.getProperty("line.separator");

    @Test
    public void checkBinarySearch() {
        int k = 1024;
        WritableMemory wMem = WritableMemory.allocate((int)(k << 3));
        for (int i = 0; i < k; ++i) {
            wMem.putLong((long)(i << 3), (long)i);
        }
        long idx = Util.binarySearchLongs((Memory)wMem, (long)0L, (long)(k - 1), (long)(k / 2));
        long val = wMem.getLong(idx << 3);
        Assert.assertEquals((long)idx, (long)(k / 2));
        Assert.assertEquals((long)val, (long)(k / 2));
        idx = Util.binarySearchLongs((Memory)wMem, (long)0L, (long)(k - 1), (long)k);
        Assert.assertEquals((long)idx, (long)-1024L);
    }

    @Test(expectedExceptions={MemoryBoundsException.class})
    public void checkBoundsTest() {
        ResourceImpl.checkBounds((long)999L, (long)2L, (long)1000L);
    }

    @Test
    public void checkPadding() {
        String s = "123";
        String t = Util.zeroPad((String)s, (int)4);
        Assert.assertTrue((boolean)t.startsWith("0"));
        t = Util.characterPad((String)s, (int)4, (char)'0', (boolean)true);
        Assert.assertTrue((boolean)t.endsWith("0"));
        t = Util.characterPad((String)s, (int)3, (char)'0', (boolean)false);
        Assert.assertEquals((String)s, (String)t);
    }

    @Test
    public void checkNullZeroNegativeChecks() {
        Object obj = null;
        try {
            Util.nullCheck(obj, (String)"Test Object");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Util.zeroCheck((long)0L, (String)"Test Long");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Util.negativeCheck((long)-1L, (String)"Test Long");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCodePointArr() {
        Util.RandomCodePoints rvcp = new Util.RandomCodePoints(true);
        int n = 1000;
        int[] cpArr = new int[1000];
        rvcp.fillCodePointArray(cpArr);
        for (int i = 0; i < 1000; ++i) {
            int cp = cpArr[i];
            if (cp < 55296 || cp > 57343) continue;
            Assert.fail();
        }
    }

    @Test
    public void checkCodePoint() {
        Util.RandomCodePoints rvcp = new Util.RandomCodePoints(true);
        int n = 1000;
        for (int i = 0; i < 1000; ++i) {
            int cp = rvcp.getCodePoint();
            if (cp < 55296 || cp > 57343) continue;
            Assert.fail();
        }
    }

    static final String getFileAttributes(File file) {
        try {
            PosixFileAttributes attrs = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
            String s = String.format("%s: %s %s %s%n", file.getPath(), attrs.owner().getName(), attrs.group().getName(), PosixFilePermissions.toString(attrs.permissions()));
            return s;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static final void setGettysburgAddressFileToReadOnly() {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        try {
            Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString("r--r--r--"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void resourceFileExits() {
        String shortFileName = "GettysburgAddress.txt";
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        Assert.assertTrue((boolean)file.exists());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void resourceFileNotFound() {
        String shortFileName = "GettysburgAddress.txt";
        Util.getResourceFile((String)"GettysburgAddress.txt123");
    }

    @Test
    public void resourceBytesCorrect() {
        String shortFileName = "GettysburgAddress.txt";
        byte[] bytes = Util.getResourceBytes((String)"GettysburgAddress.txt");
        Assert.assertTrue((bytes.length == 1541 ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void resourceBytesFileNotFound() {
        String shortFileName = "GettysburgAddress.txt";
        Util.getResourceBytes((String)"GettysburgAddress.txt123");
    }

    @Test
    public void printlnTest() {
        UtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            UtilTest.print(LS);
        } else {
            UtilTest.print(o.toString() + LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

