/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.diag.DiagUtil;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derby.vti.VTITemplate;

public class TransactionTable
extends VTITemplate
implements VTICosting {
    private TransactionInfo[] transactionTable;
    boolean initialized;
    int currentRow;
    private boolean wasNull;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("XID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("GLOBAL_XID", 12, true, 140), EmbedResultSetMetaData.getResultColumnDescriptor("USERNAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("TYPE", 12, false, 30), EmbedResultSetMetaData.getResultColumnDescriptor("STATUS", 12, false, 8), EmbedResultSetMetaData.getResultColumnDescriptor("FIRST_INSTANT", 12, true, 20), EmbedResultSetMetaData.getResultColumnDescriptor("SQL_TEXT", 12, true, 32672)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public TransactionTable() throws StandardException {
        DiagUtil.checkAccess();
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.initialized) {
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            this.transactionTable = lcc.getTransactionExecute().getAccessManager().getTransactionInfo();
            this.initialized = true;
            this.currentRow = -1;
        }
        if (this.transactionTable == null) {
            return false;
        }
        ++this.currentRow;
        while (this.currentRow < this.transactionTable.length) {
            TransactionInfo info = this.transactionTable[this.currentRow];
            if (info != null) {
                return true;
            }
            ++this.currentRow;
        }
        this.transactionTable = null;
        return false;
    }

    @Override
    public void close() {
        this.transactionTable = null;
    }

    @Override
    public String getString(int columnNumber) {
        TransactionInfo info = this.transactionTable[this.currentRow];
        String str = null;
        switch (columnNumber) {
            case 1: {
                str = info.getTransactionIdString();
                break;
            }
            case 2: {
                str = info.getGlobalTransactionIdString();
                break;
            }
            case 3: {
                str = info.getUsernameString();
                break;
            }
            case 4: {
                str = info.getTransactionTypeString();
                break;
            }
            case 5: {
                str = info.getTransactionStatusString();
                break;
            }
            case 6: {
                str = info.getFirstLogInstantString();
                break;
            }
            case 7: {
                str = info.getStatementTextString();
                str = StringUtil.truncate(str, 32672);
                break;
            }
            default: {
                str = null;
            }
        }
        this.wasNull = str == null;
        return str;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vtiEnvironment) {
        return 10000.0;
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vtiEnvironment) {
        return 100000.0;
    }

    @Override
    public boolean supportsMultipleInstantiations(VTIEnvironment vtiEnvironment) {
        return false;
    }
}

