/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

class CoalesceFunctionNode
extends ValueNode {
    String functionName;
    ValueNodeList argumentsList;
    private int firstNonParameterNodeIdx = -1;

    CoalesceFunctionNode(String functionName, ValueNodeList argumentsList, ContextManager cm) {
        super(cm);
        this.functionName = functionName;
        this.argumentsList = argumentsList;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.argumentsList.bindExpression(fromList, subqueryList, aggregates);
        if (this.argumentsList.size() < 2) {
            throw StandardException.newException("42605", this.functionName);
        }
        if (this.argumentsList.containsAllParameterNodes()) {
            throw StandardException.newException("42610", new Object[0]);
        }
        int argumentsListSize = this.argumentsList.size();
        for (int index = 0; index < argumentsListSize; ++index) {
            if (((ValueNode)this.argumentsList.elementAt(index)).requiresTypeFromContext()) continue;
            this.firstNonParameterNodeIdx = index;
            break;
        }
        for (ValueNode vn : this.argumentsList) {
            if (vn.requiresTypeFromContext()) continue;
            this.argumentsList.compatible(vn);
        }
        this.setType(this.argumentsList.getDominantTypeServices());
        for (ValueNode vn : this.argumentsList) {
            if (!vn.requiresTypeFromContext()) continue;
            vn.setType(this.getTypeServices());
        }
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int argumentsListSize = this.argumentsList.size();
        String receiverType = "org.apache.derby.iapi.types.DataValueDescriptor";
        String argumentsListInterfaceType = "org.apache.derby.iapi.types.DataValueDescriptor[]";
        LocalField arrayField = acb.newFieldDeclaration(2, argumentsListInterfaceType);
        MethodBuilder cb = acb.getConstructor();
        cb.pushNewArray("org.apache.derby.iapi.types.DataValueDescriptor", argumentsListSize);
        cb.setField(arrayField);
        int numConstants = 0;
        MethodBuilder nonConstantMethod = null;
        MethodBuilder currentConstMethod = cb;
        for (int index = 0; index < argumentsListSize; ++index) {
            MethodBuilder setArrayMethod;
            if (this.argumentsList.elementAt(index) instanceof ConstantNode) {
                ++numConstants;
                if (currentConstMethod.statementNumHitLimit(1)) {
                    MethodBuilder genConstantMethod = acb.newGeneratedFun("void", 2);
                    currentConstMethod.pushThis();
                    currentConstMethod.callMethod((short)182, null, genConstantMethod.getName(), "void", 0);
                    if (currentConstMethod != cb) {
                        currentConstMethod.methodReturn();
                        currentConstMethod.complete();
                    }
                    currentConstMethod = genConstantMethod;
                }
                setArrayMethod = currentConstMethod;
            } else {
                if (nonConstantMethod == null) {
                    nonConstantMethod = acb.newGeneratedFun("void", 4);
                }
                setArrayMethod = nonConstantMethod;
            }
            setArrayMethod.getField(arrayField);
            ((ValueNode)this.argumentsList.elementAt(index)).generateExpression(acb, setArrayMethod);
            setArrayMethod.upCast(receiverType);
            setArrayMethod.setArrayElement(index);
        }
        if (currentConstMethod != cb) {
            currentConstMethod.methodReturn();
            currentConstMethod.complete();
        }
        if (nonConstantMethod != null) {
            nonConstantMethod.methodReturn();
            nonConstantMethod.complete();
            mb.pushThis();
            mb.callMethod((short)182, null, nonConstantMethod.getName(), "void", 0);
        }
        ((ValueNode)this.argumentsList.elementAt(this.firstNonParameterNodeIdx)).generateExpression(acb, mb);
        mb.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        mb.getField(arrayField);
        LocalField field = acb.newFieldDeclaration(2, receiverType);
        acb.generateNull(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        mb.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        mb.putField(field);
        mb.callMethod((short)185, receiverType, "coalesce", receiverType, 2);
        if (this.getTypeId().variableLength()) {
            boolean isNumber = this.getTypeId().isNumericTypeId();
            mb.dup();
            mb.push(isNumber ? this.getTypeServices().getPrecision() : this.getTypeServices().getMaximumWidth());
            mb.push(this.getTypeServices().getScale());
            mb.push(true);
            mb.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
        }
    }

    @Override
    public String toString() {
        return "functionName: " + this.functionName + "\nfirstNonParameterNodeIdx: " + this.firstNonParameterNodeIdx + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "argumentsList: ");
        this.argumentsList.treePrint(depth + 1);
    }

    @Override
    boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeKind(o)) {
            return false;
        }
        CoalesceFunctionNode other = (CoalesceFunctionNode)o;
        return this.argumentsList.isEquivalent(other.argumentsList);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        this.argumentsList = (ValueNodeList)this.argumentsList.accept(v);
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.argumentsList.categorize(referencedTabs, simplePredsOnly);
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.argumentsList.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.argumentsList = this.argumentsList.remapColumnReferencesToExpressions();
        return this;
    }
}

