/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.io.StorageFile;

final class RemoveFile
implements Serviceable,
PrivilegedExceptionAction<Object> {
    private final StorageFile fileToGo;

    RemoveFile(StorageFile fileToGo) {
        this.fileToGo = fileToGo;
    }

    @Override
    public int performWork(ContextManager context) throws StandardException {
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException e) {
            throw (StandardException)e.getException();
        }
        return 1;
    }

    @Override
    public boolean serviceASAP() {
        return false;
    }

    @Override
    public boolean serviceImmediately() {
        return true;
    }

    @Override
    public Object run() throws StandardException {
        if (this.fileToGo.exists() && (this.fileToGo.isDirectory() ? !this.fileToGo.deleteAll() : !this.fileToGo.delete())) {
            throw StandardException.newException("XSDFK.S", this.fileToGo);
        }
        return null;
    }
}

