/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby6662Test
extends BaseJDBCTestCase {
    public Derby6662Test(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(Derby6662Test.class);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.dropInMemoryDb();
    }

    public void testDatabaseMetaDataCalls() throws SQLException {
        DatabaseMetaData dmd = this.getDMD();
        Derby6662Test.assertFalse((boolean)dmd.usesLocalFilePerTable());
        Derby6662Test.assertFalse((boolean)dmd.usesLocalFiles());
    }

    public void testOptionalToolMetaData() throws SQLException {
        Connection conn = this.obtainConnection();
        this.goodStatement(conn, "call syscs_util.syscs_register_tool('databaseMetaData', true)");
        this.assertResults(conn, "values usesLocalFiles()", new String[][]{{"false"}}, false);
        this.assertResults(conn, "values usesLocalFilePerTable()", new String[][]{{"false"}}, false);
        this.goodStatement(conn, "call syscs_util.syscs_register_tool('databaseMetaData', false)");
    }

    private DatabaseMetaData getDMD() throws SQLException {
        return this.obtainConnection().getMetaData();
    }

    private Connection obtainConnection() throws SQLException {
        try {
            if (Derby6662Test.usingDerbyNetClient()) {
                Class.forName("org.apache.derby.jdbc.ClientDriver");
            } else {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            }
        }
        catch (Exception e) {
            SQLException sqle = new SQLException(e.getMessage());
            sqle.initCause(e);
            throw sqle;
        }
        StringBuffer sb = this.constructUrl().append(";create=true");
        return DriverManager.getConnection(sb.toString());
    }

    private void dropInMemoryDb() throws SQLException {
        StringBuffer sb = this.constructUrl().append(";drop=true");
        try {
            DriverManager.getConnection(sb.toString());
            Derby6662Test.fail((String)"Dropping database should have raised exception.");
        }
        catch (SQLException sqle) {
            Derby6662Test.assertSQLState("08006", sqle);
        }
    }

    private StringBuffer constructUrl() {
        StringBuffer sb = new StringBuffer("jdbc:derby:");
        if (Derby6662Test.usingEmbedded()) {
            sb.append("memory:");
        } else {
            sb.append("//");
            sb.append(TestConfiguration.getCurrent().getHostName());
            sb.append(':');
            sb.append(TestConfiguration.getCurrent().getPort());
            sb.append('/');
            sb.append("memory:");
        }
        sb.append("DBMDTestDb");
        return sb;
    }
}

