/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class VirtualColumnNode
extends ValueNode {
    private ResultSetNode sourceResultSet;
    private ResultColumn sourceColumn;
    int columnId;
    private boolean correlated = false;

    VirtualColumnNode(ResultSetNode sourceResultSet, ResultColumn sourceColumn, int columnId, ContextManager cm) throws StandardException {
        super(cm);
        this.sourceResultSet = sourceResultSet;
        this.sourceColumn = sourceColumn;
        this.columnId = columnId;
        this.setType(sourceColumn.getTypeServices());
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "sourceColumn: ");
        this.sourceColumn.treePrint(depth + 1);
        this.printLabel(depth, "sourceResultSet: ");
        this.sourceResultSet.treePrint(depth + 1);
    }

    ResultSetNode getSourceResultSet() {
        return this.sourceResultSet;
    }

    ResultColumn getSourceColumn() {
        return this.sourceColumn;
    }

    @Override
    String getTableName() {
        return this.sourceColumn.getTableName();
    }

    @Override
    String getSchemaName() throws StandardException {
        return this.sourceColumn.getSchemaName();
    }

    @Override
    public boolean updatableByCursor() {
        return this.sourceColumn.updatableByCursor();
    }

    @Override
    ResultColumn getSourceResultColumn() {
        return this.sourceColumn;
    }

    void setCorrelated() {
        this.correlated = true;
    }

    boolean getCorrelated() {
        return this.correlated;
    }

    @Override
    boolean isCloneable() {
        return true;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int sourceResultSetNumber = this.sourceColumn.getResultSetNumber();
        if (this.sourceColumn.isRedundant()) {
            this.sourceColumn.getExpression().generateExpression(acb, mb);
            return;
        }
        SanityManager.ASSERT(sourceResultSetNumber >= 0, "sourceResultSetNumber expected to be >= 0 for virtual column " + this.sourceColumn.getName());
        acb.pushColumnReference(mb, sourceResultSetNumber, this.sourceColumn.getVirtualColumnId());
        mb.cast(this.sourceColumn.getTypeCompiler().interfaceName());
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.sourceColumn.getOrderableVariantType();
    }

    @Override
    public final DataTypeDescriptor getTypeServices() {
        return this.sourceColumn.getTypeServices();
    }

    @Override
    public final void setType(DataTypeDescriptor dtd) throws StandardException {
        this.sourceColumn.setType(dtd);
    }

    @Override
    boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeKind(o)) {
            VirtualColumnNode other = (VirtualColumnNode)o;
            return this.sourceColumn.isEquivalent(other.sourceColumn);
        }
        return false;
    }
}

