/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;

public class AutoincrementCounter {
    private Long start;
    private long increment;
    private String identity;
    private long finalValue;
    private String schemaName;
    private String tableName;
    private String columnName;
    private long counter;
    private int columnPosition;
    private boolean initialized = false;

    public AutoincrementCounter(Long start, long increment, long finalValue, String s, String t, String c, int position) {
        this.increment = increment;
        this.start = start;
        this.initialized = false;
        this.identity = AutoincrementCounter.makeIdentity(s, t, c);
        this.finalValue = finalValue;
        this.schemaName = s;
        this.tableName = t;
        this.columnName = c;
        this.columnPosition = position;
    }

    public static String makeIdentity(String s, String t, String c) {
        return s + "." + t + "." + c;
    }

    public static String makeIdentity(TableDescriptor td, ColumnDescriptor cd) {
        return td.getSchemaName() + "." + td.getName() + "." + cd.getColumnName();
    }

    public void reset(boolean begin) {
        if (begin) {
            this.initialized = false;
        } else {
            this.counter = this.finalValue;
            this.initialized = true;
        }
    }

    public long update(long t) {
        this.counter = t;
        this.initialized = true;
        return this.counter;
    }

    public long update() throws StandardException {
        if (!this.initialized) {
            this.initialized = true;
            if (this.start == null) {
                throw StandardException.newException("42Z25", new Object[0]);
            }
            this.counter = this.start;
        } else {
            this.counter += this.increment;
        }
        return this.counter;
    }

    public Long getCurrentValue() {
        if (!this.initialized) {
            return null;
        }
        return this.counter;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void flushToDisk(TransactionController tc, DataDictionary dd, UUID tableUUID) throws StandardException {
        dd.setAutoincrementValue(tc, tableUUID, this.columnName, this.counter, true);
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public Long getStartValue() {
        return this.start;
    }

    public String toString() {
        return "counter: " + this.identity + " current: " + this.counter + " start: " + this.start + " increment: " + this.increment + " final: " + this.finalValue;
    }
}

