/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoRowsResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;
import org.apache.derby.shared.common.i18n.MessageService;

public class RealInsertResultSetStatistics
extends RealNoRowsResultSetStatistics {
    public int rowCount;
    public boolean deferred;
    public int indexesUpdated;
    public boolean userSpecifiedBulkInsert;
    public boolean bulkInsertPerformed;
    public boolean tableLock;

    public RealInsertResultSetStatistics(int rowCount, boolean deferred, int indexesUpdated, boolean userSpecifiedBulkInsert, boolean bulkInsertPerformed, boolean tableLock, long executeTime, ResultSetStatistics sourceResultSetStatistics) {
        super(executeTime, sourceResultSetStatistics);
        this.rowCount = rowCount;
        this.deferred = deferred;
        this.indexesUpdated = indexesUpdated;
        this.userSpecifiedBulkInsert = userSpecifiedBulkInsert;
        this.bulkInsertPerformed = bulkInsertPerformed;
        this.tableLock = tableLock;
        this.sourceResultSetStatistics = sourceResultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        String insertMode = this.userSpecifiedBulkInsert ? (this.bulkInsertPerformed ? this.indent + MessageService.getTextMessage("43X64.U", new Object[0]) : this.indent + MessageService.getTextMessage("43X65.U", new Object[0])) : this.indent + MessageService.getTextMessage("43X66.U", new Object[0]);
        insertMode = insertMode + "\n";
        return this.indent + MessageService.getTextMessage("43X67.U", new Object[0]) + " " + MessageService.getTextMessage(this.tableLock ? "43X14.U" : "43X15.U", new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage("43X16.U", new Object[0]) + ": " + this.deferred + "\n" + insertMode + this.indent + MessageService.getTextMessage("43X68.U", new Object[0]) + " = " + this.rowCount + "\n" + this.indent + MessageService.getTextMessage("43X18.U", new Object[0]) + " = " + this.indexesUpdated + "\n" + this.dumpTimeStats(this.indent) + (this.sourceResultSetStatistics == null ? null : this.sourceResultSetStatistics.getStatementExecutionPlanText(1));
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        if (this.sourceResultSetStatistics == null) {
            return null;
        }
        return this.sourceResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X69.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.sourceResultSetStatistics != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.sourceResultSetStatistics != null) {
            this.sourceResultSetStatistics.accept(visitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "INSERT";
    }

    @Override
    public String getRSXplainDetails() {
        return this.bulkInsertPerformed ? "BULK" : null;
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), null, this.indexesUpdated, null, this.tableLock ? "T" : "R", (UUID)parentID, null, null, this.rowCount, XPLAINUtil.getYesNoCharFromBoolean(this.deferred), null, null, null, null, null, null, null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }
}

