/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Derby6587Test
extends BaseJDBCTestCase {
    public Derby6587Test(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("Derby6587Test");
        suite.addTest(Derby6587Test.baseSuite("Derby6587:embedded"));
        return suite;
    }

    public static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(Derby6587Test.class, name);
        SupportFilesSetup test = new SupportFilesSetup((Test)suite, new String[]{"functionTests/testData/Derby6587/Derby6587_TABLE1_T.csv", "functionTests/testData/Derby6587/Derby6587_TABLE2_T.csv"});
        return new CleanDatabaseTestSetup((Test)test){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.executeUpdate("CREATE TABLE TABLE1_T (UUID char (16) for bit data NOT NULL,NR integer NOT NULL,TEXT varchar(200) NOT NULL,CONSTRAINT IDX_1 PRIMARY KEY (UUID, NR))");
                stmt.executeUpdate("CREATE TABLE TABLE2_T (UUID char (16) for bit data NOT NULL,ID1 char(5) NOT NULL,ID2 integer NOT NULL,NR integer NOT NULL,CONSTRAINT IDX_2 PRIMARY KEY (ID1, UUID))");
                stmt.executeUpdate("ALTER TABLE TABLE2_T ADD CONSTRAINT FK_1 FOREIGN KEY (UUID, NR) REFERENCES TABLE1_T (UUID, NR) ON DELETE NO ACTION ON UPDATE NO ACTION");
            }
        };
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    public void testBulkImport() throws SQLException {
        this.getConnection();
        try {
            this.doImportFromFile("extin/Derby6587_TABLE1_T.csv", "TABLE1_T");
            this.doImportFromFile("extin/Derby6587_TABLE2_T.csv", "TABLE2_T");
        }
        catch (SQLException sqle) {
            Derby6587Test.fail((String)("caught SQLException: " + sqle.getSQLState() + "; " + sqle.getMessage()));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        BaseJDBCTestCase.dropTable(this.getConnection(), "TABLE2_T");
        BaseJDBCTestCase.dropTable(this.getConnection(), "TABLE1_T");
        super.tearDown();
    }

    private void doImportFromFile(String fileName, String toTable) throws SQLException {
        String impsql = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (? , ? , ? , ?, ? , ?, ?)";
        PreparedStatement ps = this.prepareStatement(impsql);
        ps.setString(1, "APP");
        ps.setString(2, toTable);
        ps.setString(3, fileName);
        ps.setString(4, null);
        ps.setString(5, null);
        ps.setString(6, null);
        ps.setInt(7, 0);
        ps.execute();
        ps.close();
    }
}

