/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.management.JMXConnectionDecorator;
import org.apache.derbyTesting.functionTests.tests.management.JMXConnectionGetter;
import org.apache.derbyTesting.functionTests.tests.management.PlatformConnectionGetter;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

abstract class MBeanTest
extends BaseJDBCTestCase {
    private MBeanServerConnection jmxConnection;

    public MBeanTest(String name) {
        super(name);
    }

    protected static Test suite(Class<? extends MBeanTest> testClass, String suiteName) {
        NetworkServerTestSetup networkServerTestSetup;
        BaseTestSuite outerSuite = new BaseTestSuite(suiteName);
        BaseTestSuite platform = new BaseTestSuite(testClass, suiteName + ":platform");
        platform = TestConfiguration.clientServerDecorator((Test)platform);
        platform = JMXConnectionDecorator.platformMBeanServer((Test)platform);
        outerSuite.addTest((Test)platform);
        BaseTestSuite suite = new BaseTestSuite(testClass, suiteName + ":client");
        suite = JMXConnectionDecorator.remoteNoSecurity((Test)suite);
        NetworkServerTestSetup testSetup = networkServerTestSetup = new NetworkServerTestSetup((Test)suite, MBeanTest.getCommandLineProperties(false), new String[0], true);
        outerSuite.addTest(TestConfiguration.defaultServerDecorator((Test)testSetup));
        return outerSuite;
    }

    protected static String[] getCommandLineProperties(boolean authentication) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("com.sun.management.jmxremote.port=" + TestConfiguration.getCurrent().getJmxPort());
        list.add("com.sun.management.jmxremote.authenticate=" + Boolean.toString(authentication));
        list.add("com.sun.management.jmxremote.ssl=false");
        if (authentication) {
            list.add("com.sun.management.jmxremote.password.file=extin/jmx.password");
            list.add("com.sun.management.jmxremote.access.file=extin/jmx.access");
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.enableManagement();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.jmxConnection != null) {
            JMXConnectionGetter.mbeanServerConnector.get().close(this.jmxConnection);
            this.jmxConnection = null;
        }
    }

    protected MBeanServerConnection getMBeanServerConnection() throws Exception {
        if (this.jmxConnection == null) {
            this.jmxConnection = JMXConnectionGetter.mbeanServerConnector.get().getMBeanServerConnection(null, null);
        }
        return this.jmxConnection;
    }

    protected MBeanServerConnection getMBeanServerConnection(String user, String password) throws Exception {
        return JMXConnectionGetter.mbeanServerConnector.get().getMBeanServerConnection(user, password);
    }

    protected boolean isPlatformJMXClient() {
        return JMXConnectionGetter.mbeanServerConnector.get() instanceof PlatformConnectionGetter;
    }

    protected void enableManagement() throws Exception {
        ObjectName mgmtObjName = this.getApplicationManagementMBean();
        Boolean active = (Boolean)this.getAttribute(mgmtObjName, "ManagementActive");
        if (!active.booleanValue()) {
            this.invokeOperation(mgmtObjName, "startManagement");
            active = (Boolean)this.getAttribute(mgmtObjName, "ManagementActive");
        }
        MBeanTest.assertTrue((String)"Failed to activate Derby's JMX management", (boolean)active);
    }

    protected Set<ObjectName> getDerbyDomainMBeans() throws Exception {
        ObjectName derbyDomain = new ObjectName("org.apache.derby:*");
        return this.queryMBeans(derbyDomain);
    }

    Set<ObjectName> queryMBeans(ObjectName name) throws Exception {
        MBeanServerConnection serverConn = this.getMBeanServerConnection();
        return serverConn.queryNames(name, null);
    }

    protected ObjectName getApplicationManagementMBean() throws Exception {
        ObjectName mgmtObjName = new ObjectName("org.apache.derby", "type", "Management");
        MBeanServerConnection serverConn = this.getMBeanServerConnection();
        if (!serverConn.isRegistered(mgmtObjName)) {
            serverConn.createMBean("org.apache.derby.mbeans.Management", mgmtObjName);
        }
        return mgmtObjName;
    }

    protected ObjectName getDerbyMBeanName(Hashtable<String, String> keyProperties) throws Exception {
        String systemIdentifier = (String)this.getAttribute(this.getApplicationManagementMBean(), "SystemIdentifier");
        if (systemIdentifier != null) {
            keyProperties.put("system", systemIdentifier);
        }
        return new ObjectName("org.apache.derby", keyProperties);
    }

    protected Object invokeOperation(ObjectName objName, String name) throws Exception {
        return this.invokeOperation(objName, name, new Object[0], new String[0]);
    }

    protected Object invokeOperation(ObjectName objName, String name, Object[] params, String[] sign) throws Exception {
        MBeanServerConnection jmxConn = this.getMBeanServerConnection();
        return jmxConn.invoke(objName, name, params, sign);
    }

    void setAttribute(ObjectName objName, String name, Object value) throws Exception {
        MBeanServerConnection jmxConn = this.getMBeanServerConnection();
        Attribute attribute = new Attribute(name, value);
        jmxConn.setAttribute(objName, attribute);
    }

    protected Object getAttribute(ObjectName objName, String name) throws Exception {
        MBeanServerConnection jmxConn = this.getMBeanServerConnection();
        return jmxConn.getAttribute(objName, name);
    }

    protected void assertBooleanAttribute(boolean expected, ObjectName objName, String name) throws Exception {
        Boolean bool = (Boolean)this.getAttribute(objName, name);
        MBeanTest.assertNotNull((Object)bool);
        MBeanTest.assertEquals((boolean)expected, (boolean)bool);
    }

    protected void assertIntAttribute(int expected, ObjectName objName, String name) throws Exception {
        Integer integer = (Integer)this.getAttribute(objName, name);
        MBeanTest.assertNotNull((Object)integer);
        MBeanTest.assertEquals((int)expected, (int)integer);
    }

    protected void assertLongAttribute(int expected, ObjectName objName, String name) throws Exception {
        Long longNumber = (Long)this.getAttribute(objName, name);
        MBeanTest.assertNotNull((Object)longNumber);
        MBeanTest.assertEquals((long)expected, (long)longNumber);
    }

    protected void assertStringAttribute(String expected, ObjectName objName, String name) throws Exception {
        String str = (String)this.getAttribute(objName, name);
        MBeanTest.assertNotNull((Object)str);
        MBeanTest.assertEquals((String)expected, (String)str);
    }

    protected void checkBooleanAttributeValue(ObjectName objName, String name) throws Exception {
        Object value = this.getAttribute(objName, name);
        boolean unboxedValue = (Boolean)value;
        MBeanTest.println(name + " = " + unboxedValue);
    }

    protected void checkIntAttributeValue(ObjectName objName, String name) throws Exception {
        Object value = this.getAttribute(objName, name);
        int unboxedValue = (Integer)value;
        MBeanTest.println(name + " = " + unboxedValue);
    }

    protected void checkLongAttributeValue(ObjectName objName, String name) throws Exception {
        Object value = this.getAttribute(objName, name);
        long unboxedValue = (Long)value;
        MBeanTest.println(name + " = " + unboxedValue);
    }

    protected void checkStringAttributeValue(ObjectName objName, String name) throws Exception {
        String value = (String)this.getAttribute(objName, name);
        MBeanTest.println(name + " = " + value);
    }
}

