/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.storetests;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class st_derby1939
extends BaseJDBCTestCase {
    private final int VC_SIZE = 1024;

    public st_derby1939(String name) {
        super(name);
    }

    public static Test suite() {
        Properties sysprops = new Properties();
        sysprops.setProperty("derby.language.maxMemoryPerTable", "140");
        sysprops.setProperty("derby.optimizer.noTimeout", "true");
        return new SystemPropertyTestSetup((Test)new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(st_derby1939.class)), sysprops, true);
    }

    public void testDerby1939() throws SQLException {
        this.setAutoCommit(false);
        this.doLoad();
        this.doQuery();
    }

    private void doLoad() throws SQLException {
        Statement st = this.createStatement();
        st_derby1939.println("Creating tables and index...");
        st.execute("create table d1939_t1 (i smallint, vc varchar(1024))");
        st.execute("create table d1939_t2 (j smallint, val double, vc varchar(1024))");
        st.execute("create index ix_d1939_t1 on d1939_t1 (i)");
        PreparedStatement pSt = this.prepareStatement("insert into d1939_t1(i, vc) values (?, ?)");
        PreparedStatement pSt2 = this.prepareStatement("insert into d1939_t2 values (?, ?, ?)");
        st_derby1939.println("Doing inserts...");
        for (int i = 0; i < 69; ++i) {
            for (int j = 0; j < 10; ++j) {
                String str = this.buildString(i + ":" + j);
                pSt.setInt(1, i % 10);
                pSt.setString(2, str);
                pSt.execute();
                pSt2.setInt(1, i % 10);
                pSt2.setDouble(2, (double)j * 2.0);
                if (j % 2 == 1) {
                    pSt2.setString(3, "shorty-string");
                } else {
                    pSt2.setString(3, str);
                }
                pSt2.execute();
            }
            pSt2.setInt(1, i);
            pSt2.setDouble(2, (double)i * 2.0);
            pSt2.setNull(3, 12);
            pSt2.execute();
        }
        pSt2.setNull(1, 4);
        pSt2.setDouble(2, 48.0);
        pSt.close();
        this.commit();
    }

    private void doQuery() throws SQLException {
        PreparedStatement pSt = this.prepareStatement("select * from d1939_t2   left outer join     (select distinct d1939_t1.i, d1939_t2.j, d1939_t1.vc from d1939_t2       left outer join d1939_t1         on d1939_t2.j = d1939_t1.i         and d1939_t1.i = ?     ) x1   on d1939_t2.j = x1.i");
        st_derby1939.println("Done preparing, about to execute...");
        pSt.setShort(1, (short)8);
        int count = 0;
        try {
            ResultSet rs = pSt.executeQuery();
            for (count = 0; rs.next() && count < 10; ++count) {
            }
            rs.close();
            st_derby1939.println("Ran without error, retrieved first " + count + " rows.");
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("XSDA7")) {
                st_derby1939.fail("Reproduced DERBY-1939", se);
            }
            throw se;
        }
        pSt.close();
        this.rollback();
    }

    private String buildString(String s) {
        StringBuilder sb = new StringBuilder(1024);
        for (int i = 0; i < 1024; ++i) {
            sb.append(s.charAt(i % s.length()));
        }
        return sb.toString();
    }
}

