/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.derby.client.ClientXid;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.XaException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetXACallInfo;
import org.apache.derby.client.net.NetXAConnection;

public class NetXAResource
implements XAResource {
    private static final int INITIAL_CALLINFO_ELEMENTS = 1;
    static final ClientXid nullXid = new ClientXid();
    static final int XAFUNC_COMMIT = 1;
    private static final int XAFUNC_END = 2;
    private static final int XAFUNC_FORGET = 3;
    private static final int XAFUNC_PREPARE = 4;
    private static final int XAFUNC_RECOVER = 5;
    static final int XAFUNC_ROLLBACK = 6;
    private static final int XAFUNC_START = 7;
    private static final String XAFUNCSTR_NONE = "No XA Function";
    private static final String XAFUNCSTR_COMMIT = "XAResource.commit()";
    private static final String XAFUNCSTR_END = "XAResource.end()";
    private static final String XAFUNCSTR_FORGET = "XAResource.forget()";
    private static final String XAFUNCSTR_PREPARE = "XAResource.prepare()";
    private static final String XAFUNCSTR_RECOVER = "XAResource.recover()";
    private static final String XAFUNCSTR_ROLLBACK = "XAResource.rollback()";
    private static final String XAFUNCSTR_START = "XAResource.start()";
    SqlException exceptionsOnXA = null;
    NetXAConnection netXAConn_;
    NetConnection conn_;
    private boolean keepIsolationLevel;
    NetXACallInfo[] callInfoArray_ = new NetXACallInfo[1];
    private int timeoutSeconds = 0;

    public NetXAResource(XAConnection xaconn, NetXAConnection conn) {
        this.conn_ = conn.getNetConnection();
        this.netXAConn_ = conn;
        conn.setNetXAResource(this);
        this.conn_.currXACallInfoOffset_ = 0;
        for (int i = 0; i < 1; ++i) {
            this.callInfoArray_[i] = new NetXACallInfo(null, 0, null);
        }
        this.callInfoArray_[0].actualConn_ = conn;
        this.callInfoArray_[0].saveConnectionVariables();
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "commit", xid, onePhase);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xaFlags_ = onePhase ? 0x40000000 : 0;
        callInfo.xid_ = xid;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaCommit(this.conn_, xid);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaCommit(this.conn_);
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 1;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        if (rc != 0) {
            this.throwXAException(rc);
        }
    }

    private int getSqlExceptionXAErrorCode(SqlException sqle) {
        int seErrorCode = sqle.getErrorCode();
        return seErrorCode == 40000 ? -7 : -3;
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "end", xid, flags);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xaFlags_ = flags;
        callInfo.xid_ = xid;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaEndUnitOfWork(this.conn_);
            netAgent.flowOutsideUOW();
            rc = netAgent.netConnectionReply_.readXaEndUnitOfWork(this.conn_);
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 2;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        if (rc != 0) {
            this.throwXAException(rc);
        } else {
            this.conn_.setXAState(0);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "forget", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xid_ = xid;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaForget(netAgent.netConnection_, xid);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaForget(netAgent.netConnection_);
            netAgent.endReadChain();
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 3;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
        }
        catch (SqlException sqle) {
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
            this.throwXAException(this.getSqlExceptionXAErrorCode(sqle));
        }
        if (rc != 0) {
            this.throwXAException(rc);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "getTransactionTimeout", new Object[0]);
        }
        this.exceptionsOnXA = null;
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "getTransactionTimeout", this.timeoutSeconds);
        }
        return this.timeoutSeconds;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "prepare", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xid_ = xid;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaPrepare(this.conn_);
            netAgent.flowOutsideUOW();
            rc = netAgent.netConnectionReply_.readXaPrepare(this.conn_);
            if (callInfo.xaRetVal_ != 0 && callInfo.xaRetVal_ != 3) {
                callInfo.xaFunction_ = 4;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        if (rc != 0 && rc != 3) {
            this.throwXAException(rc);
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "prepare", rc);
        }
        return rc;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        int rc = 0;
        NetAgent netAgent = this.conn_.netAgent_;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "recover", flag);
        }
        this.exceptionsOnXA = null;
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        Xid[] xidList = null;
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xaFlags_ = flag;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaRecover(this.conn_, flag);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaRecover(this.conn_);
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 5;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
            xidList = this.conn_.getIndoubtTransactionIds();
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        if (rc != 0) {
            this.throwXAException(rc);
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "recover", xidList);
        }
        return xidList;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "rollback", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xid_ = xid;
        callInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaRollback(this.conn_, xid);
            netAgent.flowOutsideUOW();
            rc = netAgent.netConnectionReply_.readXaRollback(this.conn_);
            netAgent.endReadChain();
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 2;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        if (rc != 0) {
            this.throwXAException(rc);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "setTransactionTimeout", new Object[0]);
        }
        if (seconds < 0) {
            throw new XAException(-5);
        }
        this.exceptionsOnXA = null;
        this.timeoutSeconds = seconds;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "setTransactionTimeout", true);
        }
        return true;
    }

    public void setKeepCurrentIsolationLevel(boolean flag) {
        this.keepIsolationLevel = flag;
    }

    public boolean keepCurrentIsolationLevel() {
        return this.keepIsolationLevel;
    }

    @Override
    public synchronized void start(Xid xid, int flags) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int rc = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "start", xid, flags);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        try {
            if (this.conn_.autoCommit_) {
                this.conn_.flowAutoCommit();
            }
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        NetXACallInfo callInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        callInfo.xaFlags_ = flags;
        callInfo.xid_ = xid;
        callInfo.xaRetVal_ = 0;
        if (flags == 0) {
            if (this.timeoutSeconds == Integer.MAX_VALUE) {
                callInfo.xaTimeoutMillis_ = 0L;
            } else if (this.timeoutSeconds > 0) {
                callInfo.xaTimeoutMillis_ = 1000 * this.timeoutSeconds;
            } else if (this.timeoutSeconds == 0) {
                callInfo.xaTimeoutMillis_ = -1L;
            } else {
                this.throwXAException(-3);
            }
        }
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaStartUnitOfWork(this.conn_);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaStartUnitOfWork(this.conn_);
            if (callInfo.xaRetVal_ != 0) {
                callInfo.xaFunction_ = 7;
                rc = this.xaRetValErrorAccumSQL(callInfo, rc);
                callInfo.xaRetVal_ = 0;
            }
            if (rc == 0) {
                this.conn_.setXAState(1);
            }
        }
        catch (SqlException sqle) {
            rc = this.getSqlExceptionXAErrorCode(sqle);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqle, this.exceptionsOnXA);
        }
        if (rc != 0) {
            this.throwXAException(rc);
        }
    }

    private String getXAExceptionText(int rc) {
        return switch (rc) {
            case 100 -> "XA_RBROLLBACK";
            case 101 -> "XA_RBCOMMFAIL";
            case 102 -> "XA_RBDEADLOCK";
            case 103 -> "XA_RBINTEGRITY";
            case 104 -> "XA_RBOTHER";
            case 105 -> "XA_RBPROTO";
            case 106 -> "XA_RBTIMEOUT";
            case 107 -> "XA_RBTRANSIENT";
            case 9 -> "XA_NOMIGRATE";
            case 8 -> "XA_HEURHAZ";
            case 7 -> "XA_HEURCOM";
            case 6 -> "XA_HEURRB";
            case 5 -> "XA_HEURMIX";
            case 4 -> "XA_RETRY";
            case 3 -> "XA_RDONLY";
            case -2 -> "XAER_ASYNC";
            case -3 -> "XAER_RMERR";
            case -4 -> "XAER_NOTA";
            case -5 -> "XAER_INVAL";
            case -6 -> "XAER_PROTO";
            case -7 -> "XAER_RMFAIL";
            case -8 -> "XAER_DUPID";
            case -9 -> "XAER_OUTSIDE";
            case 0 -> "XA_OK";
            default -> "Unknown Error";
        };
    }

    private void throwXAException(int rc) throws XAException {
        StringBuilder xaExceptionText = new StringBuilder(64);
        xaExceptionText.append(this.getXAExceptionText(rc));
        SqlException sqlExceptions = this.exceptionsOnXA;
        while (this.exceptionsOnXA != null) {
            xaExceptionText.append(" : ").append(this.exceptionsOnXA.getMessage());
            this.exceptionsOnXA = this.exceptionsOnXA.getNextException();
        }
        XaException xaException = new XaException(this.conn_.agent_.logWriter_, sqlExceptions, xaExceptionText.toString());
        xaException.errorCode = rc;
        this.setXaStateForXAException(rc);
        throw xaException;
    }

    private void setXaStateForXAException(int rc) {
        switch (rc) {
            case -7: 
            case -3: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                this.conn_.setXAState(0);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        boolean isSame = false;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "isSameRM", xares);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        if (xares instanceof NetXAResource) {
            NetXAResource derbyxares = (NetXAResource)xares;
            if (this.conn_.databaseName_.equalsIgnoreCase(derbyxares.conn_.databaseName_)) {
                if (!this.conn_.netAgent_.server_.equalsIgnoreCase(derbyxares.conn_.netAgent_.server_)) {
                    try {
                        String server1 = this.processLocalHost(this.conn_.netAgent_.server_);
                        String server2 = this.processLocalHost(derbyxares.conn_.netAgent_.server_);
                        InetAddress serverIP1 = InetAddress.getByName(server1);
                        InetAddress serverIP2 = InetAddress.getByName(server2);
                        if (!serverIP1.equals(serverIP2)) {
                        }
                    }
                    catch (UnknownHostException ue) {}
                } else if (this.conn_.netAgent_.port_ == derbyxares.conn_.netAgent_.port_) {
                    isSame = true;
                }
            }
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "isSameRM", isSame);
        }
        return isSame;
    }

    public static boolean xidsEqual(Xid xid1, Xid xid2) {
        int i;
        if (xid1.getFormatId() != xid2.getFormatId()) {
            return false;
        }
        int xid1Length = xid1.getGlobalTransactionId().length;
        if (xid1Length != xid2.getGlobalTransactionId().length) {
            return false;
        }
        byte[] xid1Bytes = xid1.getGlobalTransactionId();
        byte[] xid2Bytes = xid2.getGlobalTransactionId();
        for (i = 0; i < xid1Length; ++i) {
            if (xid1Bytes[i] == xid2Bytes[i]) continue;
            return false;
        }
        xid1Length = xid1.getBranchQualifier().length;
        if (xid1Length != xid2.getBranchQualifier().length) {
            return false;
        }
        xid1Bytes = xid1.getBranchQualifier();
        xid2Bytes = xid2.getBranchQualifier();
        for (i = 0; i < xid1Length; ++i) {
            if (xid1Bytes[i] == xid2Bytes[i]) continue;
            return false;
        }
        return true;
    }

    private void connectionClosedFailure() throws XAException {
        this.exceptionsOnXA = Utils.accumulateSQLException(new SqlException(null, new ClientMessageId("08003"), new Object[0]), this.exceptionsOnXA);
        this.throwXAException(-7);
    }

    private String getXAFuncStr(int xaFunc) {
        switch (xaFunc) {
            case 1: {
                return XAFUNCSTR_COMMIT;
            }
            case 2: {
                return XAFUNCSTR_END;
            }
            case 3: {
                return XAFUNCSTR_FORGET;
            }
            case 4: {
                return XAFUNCSTR_PREPARE;
            }
            case 5: {
                return XAFUNCSTR_RECOVER;
            }
            case 6: {
                return XAFUNCSTR_ROLLBACK;
            }
            case 7: {
                return XAFUNCSTR_START;
            }
        }
        return XAFUNCSTR_NONE;
    }

    protected int xaRetValErrorAccumSQL(NetXACallInfo callInfo, int currentRC) {
        int rc = callInfo.xaRetVal_;
        if (rc != 0) {
            SqlException accumSql = new SqlException(this.conn_.netAgent_.logWriter_, new ClientMessageId("XN019.S"), SqlCode.queuedXAError, this.getXAFuncStr(callInfo.xaFunction_), this.getXAExceptionText(rc));
            this.exceptionsOnXA = Utils.accumulateSQLException(accumSql, this.exceptionsOnXA);
            if (currentRC != 0 && currentRC < 0) {
                return currentRC;
            }
        }
        return rc;
    }

    private String processLocalHost(String serverName) {
        if (serverName.equalsIgnoreCase("localhost")) {
            try {
                InetAddress localhostNameIA = InetAddress.getLocalHost();
                String localhostName = localhostNameIA.getHostName();
                return localhostName;
            }
            catch (UnknownHostException ue) {
                return serverName;
            }
        }
        return serverName;
    }
}

