/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby6725GetDatabaseName
extends BaseJDBCTestCase {
    public Derby6725GetDatabaseName(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = TestConfiguration.defaultSuite(Derby6725GetDatabaseName.class);
        object = TestConfiguration.additionalDatabaseDecorator(object, "FIRSTDB1");
        object = TestConfiguration.additionalDatabaseDecorator(object, "SECONDDB2");
        return object;
    }

    public void testDatabaseName() throws SQLException {
        this.checkDbName(this.getConnection(), "wombat");
        this.checkDbName(this.openConnection("FIRSTDB1"), "singleUse/oneuse0");
        this.checkDbName(this.openConnection("SECONDDB2"), "singleUse/oneuse1");
    }

    private void checkDbName(Connection connection, String string) throws SQLException {
        File file = new File("system");
        File file2 = new File(file, string);
        String string2 = PrivilegedFileOpsForTests.getAbsolutePath(file2);
        PreparedStatement preparedStatement = connection.prepareStatement("values syscs_util.SYSCS_GET_DATABASE_NAME()");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Derby6725GetDatabaseName.assertEquals((String)string2, (String)resultSet.getString(1));
        resultSet.close();
        preparedStatement.close();
    }
}

