/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.am.stmtcache.StatementKey;
import org.apache.derby.client.am.stmtcache.StatementKeyFactory;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBCStatementCacheTest
extends BaseJDBCTestCase {
    public JDBCStatementCacheTest(String string) {
        super(string);
    }

    public void testCreateCacheWithZeroOrNegativeMaxSize() {
        try {
            new JDBCStatementCache(-10);
            JDBCStatementCacheTest.fail((String)"Negative max size should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new JDBCStatementCache(0);
            JDBCStatementCacheTest.fail((String)"Zero max size should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBasicInsertion() throws SQLException {
        String string = "values 1";
        JDBCStatementCache jDBCStatementCache = new JDBCStatementCache(10);
        PreparedStatement preparedStatement = this.prepareStatement(string);
        StatementKey statementKey = StatementKeyFactory.newPrepared((String)string, (String)"app", (int)1);
        JDBCStatementCacheTest.assertTrue((boolean)jDBCStatementCache.cacheStatement(statementKey, preparedStatement));
        JDBCStatementCacheTest.assertEquals((Object)preparedStatement, (Object)jDBCStatementCache.getCached(statementKey));
    }

    public void testBasicDuplicateKeyInsertion() throws SQLException {
        String string = "values 1";
        JDBCStatementCache jDBCStatementCache = new JDBCStatementCache(10);
        PreparedStatement preparedStatement = this.prepareStatement(string);
        StatementKey statementKey = StatementKeyFactory.newPrepared((String)string, (String)"app", (int)1);
        JDBCStatementCacheTest.assertTrue((boolean)jDBCStatementCache.cacheStatement(statementKey, preparedStatement));
        JDBCStatementCacheTest.assertFalse((boolean)jDBCStatementCache.cacheStatement(statementKey, preparedStatement));
        JDBCStatementCacheTest.assertEquals((Object)preparedStatement, (Object)jDBCStatementCache.getCached(statementKey));
    }

    public void testBasicCallableVsPrepared() throws SQLException {
        String string = "values 7";
        String string2 = "MYAPP";
        int n = 1;
        JDBCStatementCache jDBCStatementCache = new JDBCStatementCache(10);
        PreparedStatement preparedStatement = this.prepareStatement(string);
        StatementKey statementKey = StatementKeyFactory.newPrepared((String)string, (String)string2, (int)n);
        JDBCStatementCacheTest.assertTrue((boolean)jDBCStatementCache.cacheStatement(statementKey, preparedStatement));
        StatementKey statementKey2 = StatementKeyFactory.newCallable((String)string, (String)string2, (int)n);
        JDBCStatementCacheTest.assertNotSame((Object)preparedStatement, (Object)jDBCStatementCache.getCached(statementKey2));
        CallableStatement callableStatement = this.prepareCall(string);
        JDBCStatementCacheTest.assertNull((Object)jDBCStatementCache.getCached(statementKey2));
        JDBCStatementCacheTest.assertTrue((boolean)jDBCStatementCache.cacheStatement(statementKey2, (PreparedStatement)callableStatement));
        JDBCStatementCacheTest.assertSame((Object)callableStatement, (Object)jDBCStatementCache.getCached(statementKey2));
        JDBCStatementCacheTest.assertNotSame((Object)callableStatement, (Object)jDBCStatementCache.getCached(statementKey));
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(JDBCStatementCacheTest.class);
    }
}

