/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ParseException;
import org.apache.derby.impl.tools.ij.ijFatalException;
import org.apache.derby.impl.tools.ij.mtGrammar;
import org.apache.derby.impl.tools.ij.mtTestCase;
import org.apache.derby.impl.tools.ij.mtTestSuite;
import org.apache.derby.impl.tools.ij.mtTester;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class MultiTest {
    private static final int MAX_WAIT_FOR_COMPLETION = 180;
    private static mtTestSuite suite;
    private static LocalizedOutput log;
    private static String inputDir;
    private static String outputDir;
    private static String testName;

    public static void syntax() {
        System.out.println("Syntax:\n\t <file>\t- the cmd file\n\t[-o <dir>]\t-the output directory\n\t[-i <dir>]\t-the input directory");
    }

    public static void main(String[] stringArray) throws IOException, ParseException, FileNotFoundException {
        int n;
        BufferedInputStream bufferedInputStream;
        String string = util.getFileArg((String[])stringArray);
        if (string == null) {
            MultiTest.syntax();
            return;
        }
        LocalizedResource.getInstance();
        testName = MultiTest.getTestName(string);
        inputDir = util.getArg((String)"-i", (String[])stringArray);
        outputDir = util.getArg((String)"-o", (String[])stringArray);
        String string2 = inputDir != null && string.indexOf("/") == -1 ? inputDir + "/" + string : string;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string2), 2048);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("MultiTest ERROR: config file not found: " + string);
            return;
        }
        mtGrammar mtGrammar2 = new mtGrammar((InputStream)bufferedInputStream);
        suite = mtGrammar2.grammarStatement();
        suite.setRoot(inputDir);
        suite.init();
        log = MultiTest.openFile(outputDir, testName + ".log");
        try {
            MultiTest.seqRunCases(suite.getInitCases(), "initialization", inputDir, outputDir);
        }
        catch (ijFatalException ijFatalException2) {
            System.exit(1);
        }
        int n2 = suite.getNumThreads();
        System.out.println("...running with " + n2 + " threads");
        mtTester[] mtTesterArray = new mtTester[n2];
        for (n = 0; n < n2; ++n) {
            String string3 = "Tester" + (n + 1);
            try {
                LocalizedOutput localizedOutput = MultiTest.openFile(outputDir, string3 + ".out");
                mtTesterArray[n] = new mtTester(string3, suite, localizedOutput, log);
                continue;
            }
            catch (IOException iOException) {
                System.out.println("MultiTest ERROR: unable open output file " + String.valueOf(iOException));
                return;
            }
        }
        long l = MultiTest.execTesters(mtTesterArray);
        log.println("");
        log.println("test ran " + l + " ms");
        log.println("total memory is " + Runtime.getRuntime().totalMemory());
        log.println("free memory  is " + Runtime.getRuntime().freeMemory());
        for (n = 0; n < n2; ++n) {
            if (mtTesterArray[n].noFailure()) {
                log.println("Deleting Tester" + (n + 1) + ".out(" + outputDir + ")");
                File file = new File(outputDir, "Tester" + (n + 1) + ".out");
                file.delete();
                continue;
            }
            log.println("Tester" + (n + 1) + " failed.");
        }
        System.exit(0);
    }

    private static long execTesters(mtTester[] mtTesterArray) throws FileNotFoundException, IOException {
        int n;
        boolean bl = false;
        boolean bl2 = true;
        long l = 0L;
        int n2 = mtTesterArray.length;
        ThreadGroup threadGroup = new ThreadGroup("workers");
        long l2 = System.currentTimeMillis();
        long l3 = suite.getTimeMillis();
        System.out.println("...running duration " + String.valueOf(suite.getTime()));
        byte[] byArray = new byte[4096];
        Thread[] threadArray = new Thread[n2];
        for (n = 0; n < n2; ++n) {
            threadArray[n] = new Thread(threadGroup, (Runnable)mtTesterArray[n]);
            threadArray[n].start();
        }
        while ((l = System.currentTimeMillis() - l2) < l3 && (bl2 = MultiTest.allAlive(threadArray)) && !bl) {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        System.out.println("...stopping testers");
        byArray = null;
        System.gc();
        for (n = 0; n < mtTesterArray.length; ++n) {
            mtTesterArray[n].stop();
        }
        System.out.println("...waiting for testers to complete");
        for (n = 0; n < 180; ++n) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("...Unexpected InterrupedException: " + String.valueOf(interruptedException));
            }
            if (MultiTest.allDead(threadArray)) break;
        }
        if (n == 180) {
            log.println("WARNING: testers didn't die willingly, so I'm going to kill 'em.");
            log.println("\tThis may result in connection resources that aren't cleaned up");
            log.println("\t(e.g. you may see problems in the final script run with deadlocks).");
        }
        TestUtil.dumpAllStackTracesIfSupported((PrintWriter)log);
        for (n = 0; n < 180 && !threadGroup.isDestroyed(); ++n) {
            threadGroup.interrupt();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                threadGroup.destroy();
                break;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                log.println("...waiting for ThreadGroup.interrupt() to work its magic");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (bl) {
            System.out.println("TEST CASE SUMMARY: run interrupted");
        } else if (!bl2) {
            System.out.println("TEST CASE SUMMARY: abnormal termination due to error(s) -- see test log (./" + testName + "/" + testName + ".log) for details ");
        } else {
            System.out.println("TEST CASE SUMMARY: normal termination");
            if (n < 180) {
                try {
                    MultiTest.seqRunCases(suite.getFinalCases(), "last checks", inputDir, outputDir);
                }
                catch (ijFatalException ijFatalException2) {
                    System.out.println("...error running final test cases");
                }
            } else {
                System.out.println("...timed out trying to kill all testers,\n   skipping last scripts (if any).  NOTE: the\n   likely cause of the problem killing testers is\n   probably not enough VM memory OR test cases that\n   run for very long periods of time (so testers do not\n   have a chance to notice stop() requests");
            }
        }
        return l;
    }

    public static boolean allAlive(Thread[] threadArray) {
        int n;
        for (n = 0; n < threadArray.length && threadArray[n].isAlive(); ++n) {
        }
        return n == threadArray.length;
    }

    public static boolean allDead(Thread[] threadArray) {
        int n;
        for (n = 0; n < threadArray.length && !threadArray[n].isAlive(); ++n) {
        }
        return n == threadArray.length;
    }

    private static LocalizedOutput openFile(String string, String string2) throws IOException {
        File file = new File(string, string2);
        return new LocalizedOutput((OutputStream)new FileOutputStream(file));
    }

    private static void seqRunCases(Vector vector, String string, String string2, String string3) throws FileNotFoundException, IOException, ijFatalException {
        if (vector == null) {
            System.out.println("...no " + string + " being performed");
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            mtTestCase mtTestCase2 = (mtTestCase)enumeration.nextElement();
            String string4 = mtTestCase2.getFile();
            System.out.println("...running " + string + " via " + string4);
            String string5 = string4.substring(0, string4.lastIndexOf(46));
            LocalizedOutput localizedOutput = MultiTest.openFile(string3, string5 + ".out");
            BufferedInputStream bufferedInputStream = mtTestCase2.initialize(string2);
            mtTestCase2.runMe(log, localizedOutput, bufferedInputStream);
        }
    }

    private static String getTestName(String string) {
        int n;
        int n2 = string.lastIndexOf("/");
        if (n2 == -1) {
            n2 = 0;
        }
        if ((n = string.lastIndexOf(".")) == -1) {
            n = string.length();
        }
        return string.substring(n2, n);
    }
}

