/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TestDbMetaData
extends BaseJDBCTestCase {
    private static final Integer FUNCTION_NO_TABLE_VALUE = 1;
    private DatabaseMetaData meta;
    private static final JDBC.GeneratedId GENERIC_NAME = new JDBC.GeneratedId();
    private static final Object[][] ALL_FUNCTIONS = new Object[][]{{null, "APP", "DUMMY1", "java.some.func", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "APP", "DUMMY2", "java.some.func", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "APP", "DUMMY3", "java.some.func", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "APP", "DUMMY4", "java.some.func", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "APP", "DUMMY5", "java.some.func", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSCS_UTIL", "SYSCS_CHECK_TABLE", "org.apache.derby.catalog.SystemProcedures.SYSCS_CHECK_TABLE", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSCS_UTIL", "SYSCS_GET_DATABASE_NAME", "org.apache.derby.catalog.SystemProcedures.SYSCS_GET_DATABASE_NAME", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSCS_UTIL", "SYSCS_GET_DATABASE_PROPERTY", "org.apache.derby.catalog.SystemProcedures.SYSCS_GET_DATABASE_PROPERTY", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSCS_UTIL", "SYSCS_GET_RUNTIMESTATISTICS", "org.apache.derby.catalog.SystemProcedures.SYSCS_GET_RUNTIMESTATISTICS", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSCS_UTIL", "SYSCS_GET_USER_ACCESS", "org.apache.derby.catalog.SystemProcedures.SYSCS_GET_USER_ACCESS", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSCS_UTIL", "SYSCS_GET_XPLAIN_MODE", "org.apache.derby.catalog.SystemProcedures.SYSCS_GET_XPLAIN_MODE", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSCS_UTIL", "SYSCS_GET_XPLAIN_SCHEMA", "org.apache.derby.catalog.SystemProcedures.SYSCS_GET_XPLAIN_SCHEMA", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSCS_UTIL", "SYSCS_PEEK_AT_IDENTITY", "org.apache.derby.catalog.SystemProcedures.SYSCS_PEEK_AT_IDENTITY", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSCS_UTIL", "SYSCS_PEEK_AT_SEQUENCE", "org.apache.derby.catalog.SystemProcedures.SYSCS_PEEK_AT_SEQUENCE", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSIBM", "BLOBCREATELOCATOR", "org.apache.derby.impl.jdbc.LOBStoredProcedure.BLOBCREATELOCATOR", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSIBM", "BLOBGETBYTES", "org.apache.derby.impl.jdbc.LOBStoredProcedure.BLOBGETBYTES", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSIBM", "BLOBGETLENGTH", "org.apache.derby.impl.jdbc.LOBStoredProcedure.BLOBGETLENGTH", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSIBM", "BLOBGETPOSITIONFROMBYTES", "org.apache.derby.impl.jdbc.LOBStoredProcedure.BLOBGETPOSITIONFROMBYTES", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSIBM", "BLOBGETPOSITIONFROMLOCATOR", "org.apache.derby.impl.jdbc.LOBStoredProcedure.BLOBGETPOSITIONFROMLOCATOR", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSIBM", "CLOBCREATELOCATOR", "org.apache.derby.impl.jdbc.LOBStoredProcedure.CLOBCREATELOCATOR", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSIBM", "CLOBGETLENGTH", "org.apache.derby.impl.jdbc.LOBStoredProcedure.CLOBGETLENGTH", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSIBM", "CLOBGETPOSITIONFROMLOCATOR", "org.apache.derby.impl.jdbc.LOBStoredProcedure.CLOBGETPOSITIONFROMLOCATOR", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSIBM", "CLOBGETPOSITIONFROMSTRING", "org.apache.derby.impl.jdbc.LOBStoredProcedure.CLOBGETPOSITIONFROMSTRING", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}, {null, "SYSIBM", "CLOBGETSUBSTRING", "org.apache.derby.impl.jdbc.LOBStoredProcedure.CLOBGETSUBSTRING", FUNCTION_NO_TABLE_VALUE, GENERIC_NAME}};

    public TestDbMetaData(String string) {
        super(string);
    }

    protected void setUp() throws SQLException {
        this.meta = this.getConnection().getMetaData();
    }

    @Override
    protected void tearDown() throws Exception {
        this.meta = null;
        super.tearDown();
    }

    private static void createFunctions(Statement statement) throws SQLException {
        statement.execute("CREATE FUNCTION DUMMY1 ( X SMALLINT ) RETURNS SMALLINT PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'java.some.func'");
        statement.execute("CREATE FUNCTION DUMMY2 ( X INTEGER, Y SMALLINT ) RETURNS INTEGER PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'java.some.func'");
        statement.execute("CREATE FUNCTION DUMMY3 ( X VARCHAR(16), Y INTEGER ) RETURNS VARCHAR(16) PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'java.some.func'");
        statement.execute("CREATE FUNCTION DUMMY4 ( X VARCHAR(128), Y INTEGER ) RETURNS INTEGER PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'java.some.func'");
        statement.execute("CREATE FUNCTION DUMMY5 ( X BOOLEAN ) RETURNS BOOLEAN PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'java.some.func'");
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(TestDbMetaData.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                TestDbMetaData.createFunctions(statement);
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("TestDbMetaData suite");
        baseTestSuite.addTest(TestDbMetaData.baseSuite("TestDbMetaData:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(TestDbMetaData.baseSuite("TestDbMetaData:client")));
        return baseTestSuite;
    }

    public void testSupportsStoredFunctionsUsingCallSyntax() throws SQLException {
        TestDbMetaData.assertTrue((boolean)this.meta.supportsStoredFunctionsUsingCallSyntax());
    }

    public void testAutoCommitFailureClosesAllResultSets() throws SQLException {
        if (TestDbMetaData.usingEmbedded()) {
            TestDbMetaData.assertTrue((boolean)this.meta.autoCommitFailureClosesAllResultSets());
        } else {
            TestDbMetaData.assertFalse((boolean)this.meta.autoCommitFailureClosesAllResultSets());
        }
    }

    public void testGetClientInfoProperties() throws SQLException {
        ResultSet resultSet = this.meta.getClientInfoProperties();
        JDBC.assertDatabaseMetaDataColumns(resultSet, null, "NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION");
        JDBC.assertEmpty(resultSet);
    }

    public void testFunctionNullable() {
        TestDbMetaData.assertEquals((int)1, (int)1);
    }

    private void assertGetFunctionsRs(ResultSet resultSet) throws SQLException {
        int[] nArray = new int[]{12, 12, 12, 12, 5, 12};
        JDBC.assertDatabaseMetaDataColumns(resultSet, nArray, "FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "REMARKS", "FUNCTION_TYPE", "SPECIFIC_NAME");
    }

    public void testGetFunctionsNullNullNull() throws SQLException {
        ResultSet resultSet = this.meta.getFunctions(null, null, null);
        this.assertGetFunctionsRs(resultSet);
        JDBC.assertFullResultSet(resultSet, ALL_FUNCTIONS, false);
    }

    public void testGetFunctionsDummySchema() throws SQLException {
        ResultSet resultSet = this.meta.getFunctions("Dummy Catalog", null, null);
        this.assertGetFunctionsRs(resultSet);
        JDBC.assertFullResultSet(resultSet, ALL_FUNCTIONS, false);
    }

    public void testGetFunctionsFromSysSchemas() throws SQLException {
        TestDbMetaData.getSysFunctions();
        ResultSet resultSet = this.meta.getFunctions(null, "SYS%", null);
        this.assertGetFunctionsRs(resultSet);
        JDBC.assertFullResultSet(resultSet, TestDbMetaData.getSysFunctions(), false);
    }

    private static Object[][] getSysFunctions() {
        int n = 0;
        for (int i = 0; i < ALL_FUNCTIONS.length; ++i) {
            String string = (String)ALL_FUNCTIONS[i][1];
            if (!string.startsWith("SYS")) continue;
            ++n;
        }
        Object[][] objectArray = new Object[n][];
        n = 0;
        for (int i = 0; i < ALL_FUNCTIONS.length; ++i) {
            String string = (String)ALL_FUNCTIONS[i][1];
            if (!string.startsWith("SYS")) continue;
            objectArray[n++] = ALL_FUNCTIONS[i];
        }
        return objectArray;
    }

    private static Object[][] getGetFunctions() {
        int n = 0;
        for (int i = 0; i < ALL_FUNCTIONS.length; ++i) {
            String string = (String)ALL_FUNCTIONS[i][2];
            if (string.indexOf("GET") == -1) continue;
            ++n;
        }
        Object[][] objectArray = new Object[n][];
        n = 0;
        for (int i = 0; i < ALL_FUNCTIONS.length; ++i) {
            String string = (String)ALL_FUNCTIONS[i][2];
            if (string.indexOf("GET") == -1) continue;
            objectArray[n++] = ALL_FUNCTIONS[i];
        }
        return objectArray;
    }

    public void testGetFunctionsContainingGET() throws SQLException {
        ResultSet resultSet = this.meta.getFunctions(null, null, "%GET%");
        this.assertGetFunctionsRs(resultSet);
        JDBC.assertFullResultSet(resultSet, TestDbMetaData.getGetFunctions(), false);
    }

    public void testGetFunctionsNoSchemaNoCatalog() throws SQLException {
        ResultSet resultSet = this.meta.getFunctions("", "", null);
        this.assertGetFunctionsRs(resultSet);
        JDBC.assertEmpty(resultSet);
    }

    private void assertGetFunctionColumnsRs(ResultSet resultSet) throws SQLException {
        JDBC.assertDatabaseMetaDataColumns(resultSet, null, "FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME", "METHOD_ID", "PARAMETER_ID");
    }

    public void testGetFunctionColumnsStartingWithDUMMY() throws SQLException {
        ResultSet resultSet = this.meta.getFunctionColumns(null, null, "DUMMY%", null);
        this.assertGetFunctionColumnsRs(resultSet);
        Object[][] objectArray = new Object[][]{{null, "APP", "DUMMY1", "", 4, 5, "SMALLINT", 5, 2, 0, 10, 1, null, null, 0, "YES", GENERIC_NAME, 1, -1}, {null, "APP", "DUMMY1", "X", 1, 5, "SMALLINT", 5, 2, 0, 10, 1, null, null, 1, "YES", GENERIC_NAME, 1, 0}, {null, "APP", "DUMMY2", "", 4, 4, "INTEGER", 10, 4, 0, 10, 1, null, null, 0, "YES", GENERIC_NAME, 2, -1}, {null, "APP", "DUMMY2", "X", 1, 4, "INTEGER", 10, 4, 0, 10, 1, null, null, 1, "YES", GENERIC_NAME, 2, 0}, {null, "APP", "DUMMY2", "Y", 1, 5, "SMALLINT", 5, 2, 0, 10, 1, null, null, 2, "YES", GENERIC_NAME, 2, 1}, {null, "APP", "DUMMY3", "", 4, 12, "VARCHAR", 16, 32, null, null, 1, null, 32, 0, "YES", GENERIC_NAME, 2, -1}, {null, "APP", "DUMMY3", "X", 1, 12, "VARCHAR", 16, 32, null, null, 1, null, 32, 1, "YES", GENERIC_NAME, 2, 0}, {null, "APP", "DUMMY3", "Y", 1, 4, "INTEGER", 10, 4, 0, 10, 1, null, null, 2, "YES", GENERIC_NAME, 2, 1}, {null, "APP", "DUMMY4", "", 4, 4, "INTEGER", 10, 4, 0, 10, 1, null, null, 0, "YES", GENERIC_NAME, 2, -1}, {null, "APP", "DUMMY4", "X", 1, 12, "VARCHAR", 128, 256, null, null, 1, null, 256, 1, "YES", GENERIC_NAME, 2, 0}, {null, "APP", "DUMMY4", "Y", 1, 4, "INTEGER", 10, 4, 0, 10, 1, null, null, 2, "YES", GENERIC_NAME, 2, 1}, {null, "APP", "DUMMY5", "", 4, 16, "BOOLEAN", 1, 1, null, null, 1, null, null, 0, "YES", GENERIC_NAME, 1, -1}, {null, "APP", "DUMMY5", "X", 1, 16, "BOOLEAN", 1, 1, null, null, 1, null, null, 1, "YES", GENERIC_NAME, 1, 0}};
        JDBC.assertFullResultSet(resultSet, objectArray, false);
    }

    public void testGetFunctionColumnsForDummyFunctions() throws SQLException {
        ResultSet resultSet = this.meta.getFunctionColumns(null, null, "DUMMY%", "");
        this.assertGetFunctionColumnsRs(resultSet);
        Object[][] objectArray = new Object[][]{{null, "APP", "DUMMY1", "", 4, 5, "SMALLINT", 5, 2, 0, 10, 1, null, null, 0, "YES", GENERIC_NAME, 1, -1}, {null, "APP", "DUMMY2", "", 4, 4, "INTEGER", 10, 4, 0, 10, 1, null, null, 0, "YES", GENERIC_NAME, 2, -1}, {null, "APP", "DUMMY3", "", 4, 12, "VARCHAR", 16, 32, null, null, 1, null, 32, 0, "YES", GENERIC_NAME, 2, -1}, {null, "APP", "DUMMY4", "", 4, 4, "INTEGER", 10, 4, 0, 10, 1, null, null, 0, "YES", GENERIC_NAME, 2, -1}, {null, "APP", "DUMMY5", "", 4, 16, "BOOLEAN", 1, 1, null, null, 1, null, null, 0, "YES", GENERIC_NAME, 1, -1}};
        JDBC.assertFullResultSet(resultSet, objectArray, false);
    }

    private void assertGetSchemasRs(ResultSet resultSet) throws SQLException {
        JDBC.assertDatabaseMetaDataColumns(resultSet, null, "TABLE_SCHEM", "TABLE_CATALOG");
    }

    public void testGetSchemasNullNull() throws SQLException {
        ResultSet resultSet = this.meta.getSchemas(null, null);
        this.assertGetSchemasRs(resultSet);
        Object[][] objectArray = new Object[][]{{"APP", null}, {"NULLID", null}, {"SQLJ", null}, {"SYS", null}, {"SYSCAT", null}, {"SYSCS_DIAG", null}, {"SYSCS_UTIL", null}, {"SYSFUN", null}, {"SYSIBM", null}, {"SYSPROC", null}, {"SYSSTAT", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, false);
    }

    public void testGetSchemasStartingWithSYS() throws SQLException {
        ResultSet resultSet = this.meta.getSchemas(null, "SYS%");
        this.assertGetSchemasRs(resultSet);
        Object[][] objectArray = new Object[][]{{"SYS", null}, {"SYSCAT", null}, {"SYSCS_DIAG", null}, {"SYSCS_UTIL", null}, {"SYSFUN", null}, {"SYSIBM", null}, {"SYSPROC", null}, {"SYSSTAT", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, false);
    }

    public void testGetSchemasMatchingAPP() throws SQLException {
        ResultSet resultSet = this.meta.getSchemas(null, "APP");
        this.assertGetSchemasRs(resultSet);
        Object[][] objectArray = new Object[][]{{"APP", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, false);
    }

    public void testGetSchemasMatchingBLAH() throws SQLException {
        ResultSet resultSet = this.meta.getSchemas(null, "BLAH");
        this.assertGetSchemasRs(resultSet);
        JDBC.assertEmpty(resultSet);
    }

    public void testStoredProcEscapeSyntax() throws SQLException {
        boolean bl;
        this.getConnection().setAutoCommit(false);
        String string = "{CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)}";
        Statement statement = this.createStatement();
        try {
            statement.execute(string);
            bl = true;
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        TestDbMetaData.assertEquals((String)"supportsStoredFunctionsUsingCallSyntax() returned value which doesn't match actual behaviour.", (boolean)bl, (boolean)this.meta.supportsStoredFunctionsUsingCallSyntax());
        statement.close();
    }

    /*
     * WARNING - void declaration
     */
    public void testAutoCommitFailure() throws SQLException {
        void var2_7;
        this.getConnection().setAutoCommit(true);
        ResultSet[] resultSetArray = new ResultSet[]{this.createStatement().executeQuery("VALUES 1, 2, 3, 4"), this.createStatement().executeQuery("SELECT * FROM SYSIBM.SYSDUMMY1")};
        for (ResultSet resultSet : resultSetArray) {
            TestDbMetaData.assertEquals((String)"ResultSet should be holdable", (int)1, (int)resultSet.getHoldability());
        }
        try {
            String sQLException = "SELECT dummy, nonexistent, phony FROM imaginarytable34521";
            this.createStatement().execute(sQLException);
            TestDbMetaData.fail((String)"Query didn't fail.");
        }
        catch (SQLException n) {
            // empty catch block
        }
        boolean bl = false;
        for (ResultSet resultSet : resultSetArray) {
            try {
                resultSet.next();
            }
            catch (SQLException sQLException) {
                TestDbMetaData.assertSQLState("XCL16", sQLException);
                TestDbMetaData.assertTrue((sQLException.getMessage().indexOf("next") > 0 ? 1 : 0) != 0);
                ++var2_7;
            }
        }
        boolean bl2 = var2_7 == resultSetArray.length;
        TestDbMetaData.assertEquals((String)"autoCommitFailureClosesAllResultSets() returned value which doesn't match actual behaviour.", (boolean)bl2, (boolean)this.meta.autoCommitFailureClosesAllResultSets());
        for (ResultSet resultSet : resultSetArray) {
            resultSet.close();
        }
    }

    public void testIsWrapperForPositive() throws SQLException {
        TestDbMetaData.assertTrue((String)"DatabaseMetaData should be wrapper for itself.", (boolean)this.meta.isWrapperFor(DatabaseMetaData.class));
    }

    public void testIsWrapperForNegative() throws SQLException {
        TestDbMetaData.assertFalse((String)"DatabaseMetaData should not wrap PreparedStatement.", (boolean)this.meta.isWrapperFor(PreparedStatement.class));
    }

    public void testGetWrapperPositive() throws SQLException {
        DatabaseMetaData databaseMetaData = this.meta.unwrap(DatabaseMetaData.class);
        TestDbMetaData.assertSame((String)"Unwrap should return same object.", (Object)this.meta, (Object)databaseMetaData);
    }

    public void testGetWrapperNegative() {
        try {
            PreparedStatement preparedStatement = this.meta.unwrap(PreparedStatement.class);
            TestDbMetaData.fail((String)"Unwrap should not return PreparedStatement.");
        }
        catch (SQLException sQLException) {
            TestDbMetaData.assertSQLState("XJ128", sQLException);
        }
    }
}

