/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BigDecimalHandler;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ParameterMappingTest
extends BaseJDBCTestCase {
    private static final boolean HAVE_BIG_DECIMAL = !JDBC.vmSupportsJSR169();
    private static final String BAD_TYPE = "42962";
    private static final String UTF8 = "UTF-8";
    private static final long BIG_INTEGER_SEED = 98L;
    private static final long DATE_SEED = 50L;
    private static final long CALENDAR_SEED = 60L;
    private static final String DATE_METHOD_NAME = "setObject(java.util.Date)";
    private static final String CALENDAR_METHOD_NAME = "setObject(java.util.Calendar)";
    private static final String WONT_FIT = "22003";
    private static final String TRUNCATED = "22001";
    private static int[] jdbcTypes = new int[]{-6, 5, 4, -5, 7, 6, 8, 3, 2, -7, 16, 1, 12, -1, 0, -3, 0, 91, 92, 93, 2005, 2004};
    private static String[] SQLTypes = new String[]{null, "SMALLINT", "INTEGER", "BIGINT", "REAL", "FLOAT", "DOUBLE", "DECIMAL(10,5)", null, null, "BOOLEAN", "CHAR(60)", "VARCHAR(60)", "LONG VARCHAR", "CHAR(60) FOR BIT DATA", "VARCHAR(60) FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "DATE", "TIME", "TIMESTAMP", "CLOB(1k)", "BLOB(1k)"};
    private static String[] validString = new String[]{null, "98", "98", "98", "98", "98", "98", "98", null, null, "TRUE", "98", "98", "98", "0x4", "0x4", "0x4", "2004-02-14", "00:00:00", "2004-02-14 00:00:00", "98", "0x4"};
    private static Class[] B3_GET_OBJECT = HAVE_BIG_DECIMAL ? new Class[]{Integer.class, Integer.class, Integer.class, Long.class, Float.class, Double.class, Double.class, BigDecimal.class, BigDecimal.class, Boolean.class, Boolean.class, String.class, String.class, String.class, byte[].class, byte[].class, byte[].class, Date.class, Time.class, Timestamp.class, Clob.class, Blob.class} : new Class[]{Integer.class, Integer.class, Integer.class, Long.class, Float.class, Double.class, Double.class, String.class, String.class, Boolean.class, Boolean.class, String.class, String.class, String.class, byte[].class, byte[].class, byte[].class, Date.class, Time.class, Timestamp.class, Clob.class, Blob.class};
    private static final boolean n = false;
    private static final boolean X = true;
    public static final boolean[][] B6 = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    public static boolean[][] B2_MOD = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    public static boolean[][] B5 = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, true, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, true, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}};
    public static final boolean[][] allowRegisterOut = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    private static final BigDecimal bdMaxShortValue = BigDecimal.valueOf(32767L);
    private static final BigDecimal bdMinShortValue = BigDecimal.valueOf(-32768L);
    private static final BigDecimal bdMaxIntValue = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal bdMinIntValue = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal bdMaxLongValue = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal bdMinLongValue = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal bdMaxFloatValue = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal bdSmallestPosFloatValue = new BigDecimal(1.4E-45f);
    private static final BigDecimal bdSmallestNegFloatValue = new BigDecimal(-1.4E-45f);
    private static final BigDecimal bdMaxDoubleValue = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal bdSmallestPosDoubleValue = new BigDecimal(Double.MIN_VALUE);
    private static final BigDecimal bdSmallestNegDoubleValue = new BigDecimal(-4.9E-324);
    static final float DB2_SMALLEST_REAL = -3.402E38f;
    static final float DB2_LARGEST_REAL = 3.402E38f;
    static final float DB2_SMALLEST_POSITIVE_REAL = 1.175E-37f;
    static final float DB2_LARGEST_NEGATIVE_REAL = -1.175E-37f;
    static final double DB2_SMALLEST_DOUBLE = -1.79769E308;
    static final double DB2_LARGEST_DOUBLE = 1.79769E308;
    static final double DB2_SMALLEST_POSITIVE_DOUBLE = 2.225E-307;
    static final double DB2_LARGEST_NEGATIVE_DOUBLE = -2.225E-307;
    private static final int _X = -1;
    private static final int XXX_BYTE = 0;
    private static final int XXX_SHORT = 1;
    private static final int XXX_INT = 2;
    private static final int XXX_LONG = 3;
    private static final int XXX_FLOAT = 4;
    private static final int XXX_DOUBLE = 5;

    public ParameterMappingTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE PM.LOB_GET(ID INT, B BLOB, C CLOB)");
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO PM.LOB_GET VALUES (?, ?, ?)");
        preparedStatement.setInt(1, 0);
        preparedStatement.setNull(2, 2004);
        preparedStatement.setNull(3, 2005);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 1);
        byte[] byArray = new byte[]{4, 3, 114, 67, 0, 55};
        preparedStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byArray), 6);
        preparedStatement.setCharacterStream(3, (Reader)new StringReader("72"), 2);
        preparedStatement.executeUpdate();
        statement.close();
        preparedStatement.close();
        connection.commit();
    }

    public void helperTestDerby6214(int n, int n2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder(53000);
        for (int i = 0; i < 53000; i += 10) {
            stringBuilder.append("1234567890");
        }
        PreparedStatement preparedStatement = this.prepareStatement("UPDATE Test3 SET C16 = ?, I07 = I07 + 1 WHERE S02 IN (?, ?)");
        switch (n2) {
            case 1: {
                preparedStatement.setString(1, "abc");
                break;
            }
            case 2: {
                preparedStatement.setString(1, stringBuilder.toString());
                break;
            }
            case 3: {
                preparedStatement.setObject(1, (Object)"abc", 2005);
                break;
            }
            case 4: {
                preparedStatement.setObject(1, (Object)stringBuilder.toString(), 2005);
            }
        }
        preparedStatement.setObject(2, (Object)"AAAAA", 12);
        if (n == 1) {
            preparedStatement.setObject(3, (Object)"AAAAA", 12);
        } else {
            preparedStatement.setObject(3, (Object)"EEEEE", 12);
        }
        preparedStatement.execute();
    }

    public void testDerby6214() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE Test3 (S02 VARCHAR(64) NOT NULL, I07 INTEGER, C16 CLOB)");
        statement.executeUpdate("INSERT INTO Test3 (S02, I07) VALUES ('AAAAA', 1)");
        statement.executeUpdate("INSERT INTO Test3 (S02, I07) VALUES ('EEEEE', 1)");
        for (int i = 1; i < 3; ++i) {
            for (int j = 1; j < 5; ++j) {
                if (ParameterMappingTest.usingDerbyNetClient() && i == 2 && (j == 2 || j == 3 || j == 4)) continue;
                this.helperTestDerby6214(i, j);
            }
        }
    }

    public void testDerby2073() throws Exception {
        if (!JDBC.vmSupportsJDBC3()) {
            return;
        }
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE DERBY_2073_TAB (dc DECIMAL(10,2), db double, r real, i int)");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO DERBY_2073_TAB VALUES(?,?,?,?)");
        BigDecimal bigDecimal = new BigDecimal("123.45");
        preparedStatement.setBigDecimal(1, bigDecimal);
        preparedStatement.setBigDecimal(2, bigDecimal);
        preparedStatement.setBigDecimal(3, bigDecimal);
        preparedStatement.setBigDecimal(4, bigDecimal);
        preparedStatement.executeUpdate();
        preparedStatement.setBigDecimal(1, null);
        preparedStatement.setBigDecimal(2, null);
        preparedStatement.setBigDecimal(3, null);
        preparedStatement.setBigDecimal(4, null);
        preparedStatement.executeUpdate();
        bigDecimal = JDBC.vmSupportsJDBC4() ? new BigDecimal(new BigInteger("2"), -3) : new BigDecimal("2000");
        preparedStatement.setBigDecimal(1, bigDecimal);
        preparedStatement.setBigDecimal(2, bigDecimal);
        preparedStatement.setBigDecimal(3, bigDecimal);
        preparedStatement.setBigDecimal(4, bigDecimal);
        preparedStatement.executeUpdate();
        bigDecimal = new BigDecimal("123.45");
        preparedStatement.setObject(1, (Object)bigDecimal, 3, 2);
        preparedStatement.setObject(2, (Object)bigDecimal, 3, 2);
        preparedStatement.setObject(3, (Object)bigDecimal, 3, 2);
        preparedStatement.setObject(4, (Object)bigDecimal, 3, 2);
        preparedStatement.executeUpdate();
        preparedStatement.setObject(1, (Object)bigDecimal, 3, 0);
        preparedStatement.setObject(2, (Object)bigDecimal, 3, 0);
        preparedStatement.setObject(3, (Object)bigDecimal, 3, 0);
        preparedStatement.setObject(4, (Object)bigDecimal, 3, 0);
        preparedStatement.executeUpdate();
        preparedStatement.setObject(1, (Object)bigDecimal, 3);
        preparedStatement.setObject(2, (Object)bigDecimal, 3);
        preparedStatement.setObject(3, (Object)bigDecimal, 3);
        preparedStatement.setObject(4, (Object)bigDecimal, 3);
        preparedStatement.executeUpdate();
        preparedStatement.setObject(1, bigDecimal);
        preparedStatement.setObject(2, bigDecimal);
        preparedStatement.setObject(3, bigDecimal);
        preparedStatement.setObject(4, bigDecimal);
        preparedStatement.executeUpdate();
        bigDecimal = JDBC.vmSupportsJDBC4() ? new BigDecimal(new BigInteger("2"), -3) : new BigDecimal("2000");
        preparedStatement.setObject(1, bigDecimal);
        preparedStatement.setObject(2, bigDecimal);
        preparedStatement.setObject(3, bigDecimal);
        preparedStatement.setObject(4, bigDecimal);
        preparedStatement.executeUpdate();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM DERBY_2073_TAB");
        String[][] stringArray = new String[][]{{"123.45", "123.45", "123.45", "123"}, {null, null, null, null}, {"2000.00", "2000.0", "2000.0", "2000"}, {"123.45", "123.45", "123.45", "123"}, {"123.00", "123.0", "123.0", "123"}, {"123.00", "123.0", "123.0", "123"}, {"123.45", "123.45", "123.45", "123"}, {"2000.00", "2000.0", "2000.0", "2000"}};
        if (ParameterMappingTest.usingDerbyNetClient()) {
            JDBC.assertFullResultSet(resultSet, stringArray);
        }
        statement.executeUpdate("DROP TABLE DERBY_2073_TAB");
    }

    public void testParameterMapping() throws Exception {
        Connection connection = this.getConnection();
        for (int i = 0; i < SQLTypes.length; ++i) {
            String string = SQLTypes[i];
            if (string == null || jdbcTypes[i] == 0) continue;
            Statement statement = connection.createStatement();
            try {
                statement.execute("DROP TABLE PM.TYPE_AS");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement.execute("CREATE TABLE PM.TYPE_AS(VAL " + SQLTypes[i] + ")");
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO PM.TYPE_AS(VAL) VALUES(?)");
            preparedStatement.setNull(1, jdbcTypes[i]);
            preparedStatement.executeUpdate();
            PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT VAL FROM PM.TYPE_AS");
            ResultSet resultSet = preparedStatement2.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            ParameterMappingTest.assertEquivalentDataType(jdbcTypes[i], resultSetMetaData.getColumnType(1));
            resultSet.close();
            ParameterMappingTest.getXXX(preparedStatement2, i, true);
            statement.execute("DELETE FROM PM.TYPE_AS");
            if (ParameterMappingTest.setValidValue(preparedStatement, 1, jdbcTypes[i])) {
                preparedStatement.executeUpdate();
                ParameterMappingTest.getXXX(preparedStatement2, i, false);
            }
            ParameterMappingTest.setXXX(statement, preparedStatement, preparedStatement2, i);
            preparedStatement.close();
            preparedStatement2.close();
            statement.execute("DROP TABLE PM.TYPE_AS");
            connection.commit();
            try {
                statement.execute("DROP PROCEDURE PMP.TYPE_AS");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            String string2 = "CREATE PROCEDURE PMP.TYPE_AS(IN P1 " + SQLTypes[i] + ", INOUT P2 " + SQLTypes[i] + ", OUT P3 " + SQLTypes[i] + ") LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL  EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMappingTest.pmap'";
            try {
                if (!HAVE_BIG_DECIMAL && SQLTypes[i].equals("DECIMAL(10,5)")) continue;
                ParameterMappingTest.println(string2);
                statement.execute(string2);
            }
            catch (SQLException sQLException) {
                if (BAD_TYPE.equals(sQLException.getSQLState())) continue;
                ParameterMappingTest.fail((String)(sQLException.getSQLState() + ":" + sQLException.getMessage()));
                continue;
            }
            for (int j = 0; j < jdbcTypes.length; ++j) {
                int n = jdbcTypes[j];
                if (n == 0) continue;
                CallableStatement callableStatement = connection.prepareCall("CALL PMP.TYPE_AS(?, ?, ?)");
                boolean bl = true;
                try {
                    callableStatement.registerOutParameter(2, n);
                }
                catch (SQLException sQLException) {
                    ParameterMappingTest.assertFalse((String)("INOUT " + string + " registerOutParameter(" + JDBC.sqlNameFromJdbc(n) + ") failed"), (boolean)allowRegisterOut[i][j]);
                    if (!"XCL25".equals(sQLException.getSQLState())) {
                        ParameterMappingTest.fail((String)("-- " + sQLException.getSQLState()));
                    }
                    bl = false;
                }
                try {
                    callableStatement.registerOutParameter(3, n);
                }
                catch (SQLException sQLException) {
                    if (!"XCL25".equals(sQLException.getSQLState())) {
                        ParameterMappingTest.fail((String)("-- " + sQLException.getSQLState()));
                    }
                    ParameterMappingTest.assertFalse((String)("OUT " + string + " registerOutParameter(" + JDBC.sqlNameFromJdbc(n) + "failed"), (boolean)allowRegisterOut[i][j]);
                    bl = false;
                }
                if (bl) {
                    try {
                        if (ParameterMappingTest.setValidValue(callableStatement, 1, jdbcTypes[i]) && ParameterMappingTest.setValidValue(callableStatement, 2, n)) {
                            callableStatement.execute();
                            ParameterMappingTest.getOutValue(callableStatement, 2, n, i);
                            ParameterMappingTest.getOutValue(callableStatement, 3, n, i);
                        }
                    }
                    catch (SQLException sQLException) {
                        boolean bl2;
                        boolean bl3 = bl2 = "22018".equals(sQLException.getSQLState()) || "22007".equals(sQLException.getSQLState()) || "22005".equals(sQLException.getSQLState());
                        if (!bl2) {
                            ParameterMappingTest.printStackTrace(sQLException);
                        }
                        ParameterMappingTest.assertTrue((String)("FAIL: Unexpected exception" + sQLException.getSQLState() + ":" + sQLException.getMessage()), (boolean)bl2);
                    }
                }
                callableStatement.close();
            }
            statement.execute("DROP PROCEDURE PMP.TYPE_AS");
            statement.close();
            connection.commit();
        }
    }

    public void testClobMapping() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "create procedure clobIn\n( in c clob, out result varchar( 100 ) )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".clobIn'\n");
        preparedStatement.execute();
        preparedStatement.close();
        CallableStatement callableStatement = this.chattyPrepareCall(connection, "call clobIn( cast( 'def' as clob ), ? )");
        callableStatement.registerOutParameter(1, 12);
        callableStatement.execute();
        ParameterMappingTest.assertEquals((String)"def", (String)callableStatement.getString(1));
        callableStatement.close();
        callableStatement = this.chattyPrepareCall(connection, "call clobIn( ?, ? )");
        callableStatement.setClob(1, (Clob)new HarmonySerialClob("ghi"));
        callableStatement.registerOutParameter(2, 12);
        callableStatement.execute();
        ParameterMappingTest.assertEquals((String)"ghi", (String)callableStatement.getString(2));
        callableStatement.close();
        preparedStatement = this.chattyPrepare(connection, "create procedure clobOut\n( out c clob )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".clobOut'\n");
        preparedStatement.execute();
        preparedStatement.close();
        callableStatement = this.chattyPrepareCall(connection, "call clobOut( ? )");
        callableStatement.registerOutParameter(1, 2005);
        callableStatement.execute();
        Clob clob = callableStatement.getClob(1);
        ParameterMappingTest.assertEquals((String)"abc", (String)clob.getSubString(1L, (int)clob.length()));
        callableStatement.close();
        preparedStatement = this.chattyPrepare(connection, "create procedure clobInOut\n( inout c clob )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".clobInOut'\n");
        preparedStatement.execute();
        preparedStatement.close();
        callableStatement = this.chattyPrepareCall(connection, "call clobInOut( ? )");
        callableStatement.setClob(1, (Clob)new HarmonySerialClob("ghi"));
        callableStatement.registerOutParameter(1, 2005);
        callableStatement.execute();
        clob = callableStatement.getClob(1);
        ParameterMappingTest.assertEquals((String)"ihg", (String)clob.getSubString(1L, (int)clob.length()));
        Clob clob2 = this.makeBigClob();
        callableStatement.setClob(1, clob2);
        callableStatement.execute();
        Clob clob3 = callableStatement.getClob(1);
        this.compareClobs(clob2, clob3);
        callableStatement.close();
    }

    private Clob makeBigClob() throws Exception {
        char[] cArray = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        int n = cArray.length;
        int n2 = 50000;
        char[] cArray2 = new char[n * n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                cArray2[n3++] = cArray[j];
            }
        }
        return new HarmonySerialClob(new String(cArray2));
    }

    private void compareClobs(Clob clob, Clob clob2) throws Exception {
        long l = clob.length();
        long l2 = clob2.length();
        ParameterMappingTest.println("Left clob has " + l + " characters and right clob has " + l2 + " characters.");
        ParameterMappingTest.assertEquals((long)l, (long)l2);
        if (l == l2) {
            // empty if block
        }
        String string = clob.getSubString(1L, (int)l);
        String string2 = clob2.getSubString(1L, (int)l2);
        int n = 0;
        while ((long)n < l) {
            char c;
            int n2 = n++;
            int n3 = (int)(l - (long)n2 - 1L);
            char c2 = string.charAt(n2);
            if (c2 != (c = string2.charAt(n3))) {
                ParameterMappingTest.println("left[ " + n2 + " ] = " + c2 + " but right[ " + n3 + " ] = " + c);
                return;
            }
            ParameterMappingTest.assertEquals((char)c2, (char)c);
        }
    }

    public void testBlobMapping() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "create procedure blobIn\n( in c blob, out result varchar( 100 ) )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".blobIn'\n");
        preparedStatement.execute();
        preparedStatement.close();
        CallableStatement callableStatement = this.chattyPrepareCall(connection, "call blobIn( ?, ? )");
        callableStatement.setBlob(1, (Blob)new HarmonySerialBlob("ghi".getBytes(UTF8)));
        callableStatement.registerOutParameter(2, 12);
        callableStatement.execute();
        ParameterMappingTest.assertEquals((String)"ghi", (String)callableStatement.getString(2));
        callableStatement.close();
        preparedStatement = this.chattyPrepare(connection, "create procedure blobOut\n( out c blob )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".blobOut'\n");
        preparedStatement.execute();
        preparedStatement.close();
        callableStatement = this.chattyPrepareCall(connection, "call blobOut( ? )");
        callableStatement.registerOutParameter(1, 2004);
        callableStatement.execute();
        Blob blob = callableStatement.getBlob(1);
        ParameterMappingTest.assertEquals((String)"abc", (String)ParameterMappingTest.getBlobValue(blob));
        callableStatement.close();
        preparedStatement = this.chattyPrepare(connection, "create procedure blobInOut\n( inout c blob )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".blobInOut'\n");
        preparedStatement.execute();
        preparedStatement.close();
        callableStatement = this.chattyPrepareCall(connection, "call blobInOut( ? )");
        callableStatement.setBlob(1, (Blob)new HarmonySerialBlob("ghi".getBytes(UTF8)));
        callableStatement.registerOutParameter(1, 2004);
        callableStatement.execute();
        blob = callableStatement.getBlob(1);
        ParameterMappingTest.assertEquals((String)"ihg", (String)ParameterMappingTest.getBlobValue(blob));
        Blob blob2 = this.makeBigBlob();
        callableStatement.setBlob(1, blob2);
        callableStatement.execute();
        Blob blob3 = callableStatement.getBlob(1);
        this.compareBlobs(blob2, blob3);
        callableStatement.close();
    }

    private Blob makeBigBlob() throws Exception {
        byte[] byArray = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int n = byArray.length;
        int n2 = 110000;
        byte[] byArray2 = new byte[n * n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                byArray2[n3++] = byArray[j];
            }
        }
        return new HarmonySerialBlob(byArray2);
    }

    private void compareBlobs(Blob blob, Blob blob2) throws Exception {
        long l = blob.length();
        long l2 = blob2.length();
        ParameterMappingTest.println("Left blob has " + l + " bytes and right blob has " + l2 + " bytes.");
        ParameterMappingTest.assertEquals((long)l, (long)l2);
        if (l == l2) {
            // empty if block
        }
        byte[] byArray = blob.getBytes(1L, (int)l);
        byte[] byArray2 = blob2.getBytes(1L, (int)l2);
        int n = 0;
        while ((long)n < l) {
            byte by;
            int n2;
            int n3 = (int)(l - (long)n2 - 1L);
            byte by2 = byArray2[n3];
            if ((by = byArray[n2 = n++]) != by2) {
                ParameterMappingTest.println("left[ " + n2 + " ] = " + by + " but right[ " + n3 + " ] = " + by2);
                return;
            }
            ParameterMappingTest.assertEquals((byte)by, (byte)by2);
        }
    }

    public void test_jdbc4_1_objectMappings() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        try {
            statement.execute("drop table t_object_map");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.execute("create table t_object_map( a int, b timestamp, c bigint )");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t_object_map( a, b, c ) values ( ?, ?, ? )");
        preparedStatement.setInt(1, 1);
        preparedStatement.setObject(2, new java.util.Date(50L));
        preparedStatement.setObject(3, null);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 2);
        preparedStatement.setObject(2, ParameterMappingTest.makeCalendar(60L));
        preparedStatement.setObject(3, null);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 3);
        preparedStatement.setObject(2, null);
        preparedStatement.setObject(3, new BigInteger(Long.toString(98L)));
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("select * from t_object_map order by a");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        ParameterMappingTest.assertEquals((long)50L, (long)resultSet.getTimestamp(2).getTime());
        resultSet.next();
        ParameterMappingTest.assertEquals((long)60L, (long)resultSet.getTimestamp(2).getTime());
        resultSet.next();
        ParameterMappingTest.assertEquals((long)98L, (long)resultSet.getLong(3));
        resultSet.close();
        preparedStatement.close();
    }

    private static Calendar makeCalendar(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date(l));
        return calendar;
    }

    public void testBigInteger() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        try {
            statement.execute("drop table t2_object_map");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.execute("create table t2_object_map( smallint_col smallint, int_col int, bigint_col bigint, real_col real, float_col float, double_col double, decimal_col decimal( 31 ), numeric_col numeric( 31 ), char_col char( 10 ), varchar_col varchar( 10 ) )");
        String[] stringArray = new String[]{"smallint_col", "int_col", "bigint_col", "real_col", "float_col", "double_col", "decimal_col", "numeric_col", "char_col", "varchar_col"};
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.endsWith("int_col")) continue;
            hashSet.add(string);
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.endsWith("char_col")) continue;
            hashSet2.add(string);
        }
        this.vetBigInteger(connection, "1", stringArray, new HashSet(), new HashSet());
        this.vetBigInteger(connection, "9223372036854775808", stringArray, hashSet, hashSet2);
        this.vetBigInteger(connection, "-9223372036854775809", stringArray, hashSet, hashSet2);
    }

    private void vetBigInteger(Connection connection, String string, String[] stringArray, HashSet hashSet, HashSet hashSet2) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = null;
            if (hashSet.contains(string2)) {
                string3 = WONT_FIT;
            } else if (hashSet2.contains(string2)) {
                string3 = TRUNCATED;
            }
            this.vetBigInteger(connection, string, string2, string3);
        }
    }

    private void vetBigInteger(Connection connection, String string, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("delete from t2_object_map");
        preparedStatement.executeUpdate();
        preparedStatement.close();
        String string4 = "insert into t2_object_map( " + string2 + " ) values ( ? )";
        preparedStatement = connection.prepareStatement(string4);
        try {
            preparedStatement.setObject(1, new BigInteger(string));
            preparedStatement.executeUpdate();
            if (string3 != null) {
                ParameterMappingTest.fail((String)("Expected '" + string4 + "' to fail for BigInteger( " + string + " )."));
            }
        }
        catch (SQLException sQLException) {
            ParameterMappingTest.assertEquals((String)("Expecting failure for seed = " + string + " and insertText = '" + string4 + "'"), (String)string3, (String)sQLException.getSQLState());
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        this.dropTable("PM.LOB_GET");
        this.commit();
        super.tearDown();
    }

    private static void getXXX(PreparedStatement preparedStatement, int n, boolean bl) throws SQLException, IOException {
        boolean bl2;
        boolean bl3;
        Object object;
        boolean bl4;
        boolean bl5;
        int n2;
        boolean bl6;
        boolean bl7;
        short s;
        int n3 = preparedStatement.getMetaData().getColumnType(1) == 16 ? 1 : 32;
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        SQLException sQLException = null;
        try {
            s = resultSet.getByte(1);
            bl7 = resultSet.wasNull();
            if (bl) {
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else {
                ParameterMappingTest.assertFalse((boolean)bl7);
                ParameterMappingTest.assertEquals((int)n3, (int)s);
            }
            bl6 = true;
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
            bl6 = false;
        }
        resultSet.close();
        ParameterMappingTest.judge_getXXX(bl6, sQLException, 0, n);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        sQLException = null;
        try {
            s = resultSet.getShort(1);
            bl7 = resultSet.wasNull();
            if (bl) {
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else {
                ParameterMappingTest.assertFalse((boolean)bl7);
                ParameterMappingTest.assertEquals((int)n3, (int)s);
            }
            bl6 = true;
        }
        catch (SQLException sQLException3) {
            sQLException = sQLException3;
            bl6 = false;
        }
        resultSet.close();
        ParameterMappingTest.judge_getXXX(bl6, sQLException, 1, n);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        sQLException = null;
        try {
            int n4 = resultSet.getInt(1);
            bl7 = resultSet.wasNull();
            if (bl) {
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else {
                ParameterMappingTest.assertFalse((boolean)bl);
                ParameterMappingTest.assertEquals((int)n3, (int)n4);
            }
            bl6 = true;
        }
        catch (SQLException sQLException4) {
            sQLException = sQLException4;
            bl6 = false;
        }
        resultSet.close();
        ParameterMappingTest.judge_getXXX(bl6, sQLException, 2, n);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        sQLException = null;
        try {
            long l = resultSet.getLong(1);
            n2 = resultSet.wasNull();
            if (bl) {
                ParameterMappingTest.assertTrue(n2 != 0);
            } else {
                ParameterMappingTest.assertEquals((long)n3, (long)l);
                ParameterMappingTest.assertFalse(n2 != 0);
            }
            bl6 = true;
        }
        catch (SQLException sQLException5) {
            sQLException = sQLException5;
            bl6 = false;
        }
        resultSet.close();
        ParameterMappingTest.judge_getXXX(bl6, sQLException, 3, n);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        sQLException = null;
        try {
            float f = resultSet.getFloat(1);
            bl7 = resultSet.wasNull();
            if (bl) {
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else {
                ParameterMappingTest.assertFalse((boolean)bl7);
                ParameterMappingTest.assertEquals((double)n3, (double)f, (double)1.0E-6);
            }
            bl6 = true;
        }
        catch (SQLException sQLException6) {
            sQLException = sQLException6;
            bl6 = false;
        }
        resultSet.close();
        ParameterMappingTest.judge_getXXX(bl6, sQLException, 4, n);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        SQLException sQLException7 = null;
        try {
            double d = resultSet.getDouble(1);
            n2 = resultSet.wasNull();
            if (bl) {
                ParameterMappingTest.assertTrue(n2 != 0);
            } else {
                ParameterMappingTest.assertFalse(n2 != 0);
                ParameterMappingTest.assertEquals((double)n3, (double)d, (double)1.0E-5);
            }
            bl5 = true;
        }
        catch (SQLException sQLException8) {
            sQLException7 = sQLException8;
            bl5 = false;
        }
        resultSet.close();
        ParameterMappingTest.judge_getXXX(bl5, sQLException7, 5, n);
        if (HAVE_BIG_DECIMAL) {
            boolean bl8;
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            SQLException sQLException9 = null;
            try {
                BigDecimal bigDecimal = resultSet.getBigDecimal(1);
                bl7 = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertTrue((boolean)bl7);
                    ParameterMappingTest.assertNull((Object)bigDecimal);
                } else {
                    ParameterMappingTest.assertFalse((boolean)bl7);
                    ParameterMappingTest.assertEquals((String)"BigDecimal comparison failed", (int)0, (int)BigDecimal.valueOf(n3).compareTo(bigDecimal));
                }
                bl8 = true;
            }
            catch (SQLException sQLException10) {
                sQLException9 = sQLException10;
                bl8 = false;
            }
            resultSet.close();
            ParameterMappingTest.judge_getXXX(bl8, sQLException9, 6, n);
        }
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Object object2 = null;
        try {
            boolean bl9 = resultSet.getBoolean(1);
            bl7 = resultSet.wasNull();
            if (bl) {
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else {
                ParameterMappingTest.assertFalse((boolean)bl7);
                ParameterMappingTest.assertTrue((boolean)bl9);
            }
            bl4 = true;
        }
        catch (SQLException sQLException11) {
            object2 = sQLException11;
            bl4 = false;
        }
        resultSet.close();
        ParameterMappingTest.judge_getXXX(bl4, (SQLException)object2, 7, n);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        object2 = null;
        try {
            object = resultSet.getString(1);
            bl7 = resultSet.wasNull();
            if (bl) {
                ParameterMappingTest.assertNull((Object)object);
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else {
                object = ((String)object).trim();
                n2 = jdbcTypes[n];
                switch (n2) {
                    case -5: 
                    case -1: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 12: {
                        ParameterMappingTest.assertEquals((String)Integer.toString(n3), (String)object);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        ParameterMappingTest.assertEquals((String)(n3 + ".0"), (String)object);
                        break;
                    }
                    case 2: 
                    case 3: {
                        ParameterMappingTest.assertEquals((String)(n3 + ".00000"), (String)object);
                        break;
                    }
                    case -3: 
                    case -2: {
                        ParameterMappingTest.assertEquals((String)"0403fdc373", (String)object);
                        break;
                    }
                    case 91: {
                        ParameterMappingTest.assertEquals((String)"2004-02-14", (String)object);
                        break;
                    }
                    case 92: {
                        ParameterMappingTest.assertEquals((String)"17:14:24", (String)object);
                        break;
                    }
                    case 93: {
                        ParameterMappingTest.assertEquals((String)"2004-02-14 17:14:24.097625551", (String)object);
                        break;
                    }
                    case 2005: {
                        ParameterMappingTest.assertEquals((String)"67", (String)object);
                        break;
                    }
                    case 2004: {
                        ParameterMappingTest.assertEquals((String)"8243cafe0032", (String)object);
                    }
                }
                ParameterMappingTest.assertFalse((boolean)bl7);
            }
            bl4 = true;
        }
        catch (SQLException sQLException12) {
            object2 = sQLException12;
            bl4 = false;
        }
        resultSet.close();
        ParameterMappingTest.judge_getXXX(bl4, (SQLException)object2, 8, n);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        object2 = null;
        try {
            object = resultSet.getBytes(1);
            bl7 = resultSet.wasNull();
            if (bl) {
                ParameterMappingTest.assertNull((Object)object);
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else {
                n2 = jdbcTypes[n];
                switch (n2) {
                    case -4: 
                    case -3: 
                    case -2: {
                        ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo((byte[])object));
                        break;
                    }
                    case 2004: {
                        ParameterMappingTest.assertEquals((String)"0x82,0x43", (String)ParameterMappingTest.showFirstTwo((byte[])object));
                    }
                }
                ParameterMappingTest.assertNotNull((Object)object);
                ParameterMappingTest.assertFalse((boolean)bl7);
            }
            bl4 = true;
        }
        catch (SQLException sQLException13) {
            object2 = sQLException13;
            bl4 = false;
        }
        resultSet.close();
        ParameterMappingTest.judge_getXXX(bl4, (SQLException)object2, 9, n);
        SQLException sQLException14 = null;
        object2 = null;
        try {
            object2 = preparedStatement.executeQuery();
            object2.next();
            object = object2.getDate(1);
            bl7 = object2.wasNull();
            if (bl) {
                ParameterMappingTest.assertNull((Object)object);
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else {
                ParameterMappingTest.assertEquals((String)"2004-02-14", (String)((Date)object).toString());
                ParameterMappingTest.assertNotNull((Object)object);
                ParameterMappingTest.assertFalse((boolean)bl7);
            }
            bl3 = true;
        }
        catch (SQLException sQLException15) {
            sQLException14 = sQLException15;
            bl3 = "22007".equals(sQLException15.getSQLState());
        }
        catch (Throwable throwable) {
            bl3 = false;
        }
        if (object2 != null) {
            object2.close();
        }
        ParameterMappingTest.judge_getXXX(bl3, sQLException14, 10, n);
        sQLException14 = null;
        object2 = null;
        try {
            object2 = preparedStatement.executeQuery();
            object2.next();
            object = object2.getTime(1);
            bl7 = object2.wasNull();
            if (bl) {
                ParameterMappingTest.assertNull((Object)object);
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else {
                ParameterMappingTest.assertFalse((boolean)bl7);
                ParameterMappingTest.assertEquals((String)"17:14:24", (String)((Time)object).toString());
            }
            bl3 = true;
        }
        catch (SQLException sQLException16) {
            sQLException14 = sQLException16;
            bl3 = "22007".equals(sQLException16.getSQLState());
        }
        catch (Throwable throwable) {
            bl3 = false;
        }
        if (object2 != null) {
            object2.close();
        }
        ParameterMappingTest.judge_getXXX(bl3, sQLException14, 11, n);
        sQLException14 = null;
        object2 = null;
        try {
            object2 = preparedStatement.executeQuery();
            object2.next();
            object = object2.getTimestamp(1);
            bl7 = object2.wasNull();
            if (bl) {
                ParameterMappingTest.assertNull((Object)object);
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else {
                if (n == 91 || n == 93) {
                    ParameterMappingTest.assertEquals((String)"2004-02-14 00:00:00.0", (String)((Timestamp)object).toString());
                }
                ParameterMappingTest.assertFalse((boolean)object2.wasNull());
            }
            bl3 = true;
        }
        catch (SQLException sQLException17) {
            sQLException14 = sQLException17;
            bl3 = "22007".equals(sQLException17.getSQLState());
        }
        catch (Throwable throwable) {
            bl3 = false;
        }
        if (object2 != null) {
            object2.close();
        }
        ParameterMappingTest.judge_getXXX(bl3, sQLException14, 12, n);
        ResultSet resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        object2 = null;
        try {
            object = resultSet2.getAsciiStream(1);
            bl7 = resultSet2.wasNull();
            if (bl) {
                ParameterMappingTest.assertTrue((boolean)bl7);
                ParameterMappingTest.assertNull((Object)object);
            } else {
                ParameterMappingTest.assertFalse((boolean)bl7);
                if (B6[13][n]) {
                    ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo((InputStream)object));
                }
            }
            bl2 = true;
        }
        catch (SQLException sQLException18) {
            object2 = sQLException18;
            bl2 = false;
        }
        boolean bl10 = B6[13][n] || ParameterMappingTest.specificCheck(resultSet2, bl2, (SQLException)object2, bl);
        resultSet2.close();
        if (bl10) {
            ParameterMappingTest.judge_getXXX(bl2, (SQLException)object2, 13, n);
        }
        resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        object2 = null;
        try {
            InputStream inputStream = resultSet2.getBinaryStream(1);
            if (bl) {
                ParameterMappingTest.assertTrue((boolean)resultSet2.wasNull());
                ParameterMappingTest.assertNull((Object)inputStream);
            } else if (B6[14][n]) {
                ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo(inputStream));
            }
            bl2 = true;
        }
        catch (SQLException sQLException19) {
            object2 = sQLException19;
            bl2 = false;
        }
        boolean bl11 = B6[14][n] || ParameterMappingTest.specificCheck(resultSet2, bl2, (SQLException)object2, bl);
        resultSet2.close();
        if (bl11) {
            ParameterMappingTest.judge_getXXX(bl2, (SQLException)object2, 14, n);
        }
        resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        object2 = null;
        try {
            Reader reader = resultSet2.getCharacterStream(1);
            bl7 = resultSet2.wasNull();
            if (bl) {
                ParameterMappingTest.assertNull((Object)reader);
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else if (B6[15][n]) {
                ParameterMappingTest.assertFalse((boolean)bl7);
                ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo(reader));
            }
            bl2 = true;
        }
        catch (SQLException sQLException20) {
            object2 = sQLException20;
            bl2 = false;
        }
        boolean bl12 = B6[15][n] || ParameterMappingTest.specificCheck(resultSet2, bl2, (SQLException)object2, bl);
        resultSet2.close();
        if (bl12) {
            ParameterMappingTest.judge_getXXX(bl2, (SQLException)object2, 15, n);
        }
        resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        object2 = null;
        try {
            Clob clob = resultSet2.getClob(1);
            bl7 = resultSet2.wasNull();
            if (bl) {
                ParameterMappingTest.assertNull((Object)clob);
                ParameterMappingTest.assertTrue((boolean)bl7);
            } else if (B6[16][n]) {
                ParameterMappingTest.assertFalse((boolean)bl7);
                ParameterMappingTest.assertNotNull((Object)clob.getSubString(1L, 10));
            }
            bl2 = true;
        }
        catch (SQLException sQLException21) {
            object2 = sQLException21;
            bl2 = false;
        }
        boolean bl13 = B6[16][n] || ParameterMappingTest.specificCheck(resultSet2, bl2, (SQLException)object2, bl);
        resultSet2.close();
        if (bl13) {
            ParameterMappingTest.judge_getXXX(bl2, (SQLException)object2, 16, n);
        }
        resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        object2 = null;
        try {
            Blob blob = resultSet2.getBlob(1);
            bl7 = resultSet2.wasNull();
            if (bl) {
                ParameterMappingTest.assertTrue((boolean)bl7);
                ParameterMappingTest.assertNull((Object)blob);
            } else if (B6[17][n]) {
                ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo(blob.getBinaryStream()));
            }
            bl2 = true;
        }
        catch (SQLException sQLException22) {
            object2 = sQLException22;
            bl2 = false;
        }
        boolean bl14 = B6[17][n] || ParameterMappingTest.specificCheck(resultSet2, bl2, (SQLException)object2, bl);
        resultSet2.close();
        if (bl14) {
            ParameterMappingTest.judge_getXXX(bl2, (SQLException)object2, 17, n);
        }
        resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        object2 = null;
        try {
            InputStream inputStream = resultSet2.getUnicodeStream(1);
            bl7 = resultSet2.wasNull();
            if (bl) {
                ParameterMappingTest.assertTrue((boolean)bl7);
                ParameterMappingTest.assertNull((Object)inputStream);
            } else {
                ParameterMappingTest.assertFalse((boolean)bl7);
                ParameterMappingTest.assertNotNull((Object)inputStream);
            }
            bl2 = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            bl2 = true;
        }
        catch (SQLException sQLException23) {
            object2 = sQLException23;
            bl2 = false;
        }
        resultSet2.close();
        if (JDBC.vmSupportsJDBC3()) {
            ParameterMappingTest.judge_getXXX(bl2, (SQLException)object2, 18, n);
        }
        resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        if (!SQLTypes[n].equals("DECIMAL(10,5)") || HAVE_BIG_DECIMAL) {
            object2 = resultSet2.getObject(1);
            boolean bl15 = resultSet2.wasNull();
            Class clazz = B3_GET_OBJECT[n];
            if (clazz.equals(byte[].class)) {
                String string = "byte[]";
            } else {
                String string = clazz.getName();
            }
            if (bl) {
                ParameterMappingTest.assertTrue((boolean)bl15);
                ParameterMappingTest.assertNull((Object)object2);
                bl2 = true;
            } else if (clazz.isInstance(object2)) {
                bl2 = true;
            } else {
                bl2 = false;
                ParameterMappingTest.fail((String)("FAIL NOT :" + clazz.getName() + " is " + object2.getClass().getName()));
            }
        } else {
            bl2 = true;
        }
        ParameterMappingTest.assertTrue((boolean)bl2);
        resultSet2.close();
    }

    private static boolean specificCheck(ResultSet resultSet, boolean bl, SQLException sQLException, boolean bl2) throws SQLException {
        boolean bl3 = true;
        if (bl && bl2 && resultSet.wasNull()) {
            if (ParameterMappingTest.usingDerbyNetClient()) {
                bl3 = false;
            }
        } else if (!bl && bl2 && ParameterMappingTest.usingDerbyNetClient() && "22005".equals(sQLException.getSQLState())) {
            bl3 = false;
        }
        return bl3;
    }

    private static void judge_getXXX(boolean bl, SQLException sQLException, int n, int n2) {
        boolean bl2 = false;
        if (B6[n][n2] && !bl) {
            ParameterMappingTest.fail((String)(" JDBC FAIL " + SQLTypes[n2] + " " + String.valueOf(sQLException)));
        } else if (!bl) {
            String string = sQLException.getSQLState();
            if ("0A000".equals(string)) {
                bl2 = true;
            }
            if ("0A000".equals(string)) {
                bl2 = true;
            }
            if ("22005".equals(string)) {
                bl2 = true;
            } else if (string == null && sQLException.getMessage().indexOf("Wrong result column type for requested conversion") != -1) {
                bl2 = true;
            }
            ParameterMappingTest.assertTrue((String)("FAIL: Expected conversion error but got " + String.valueOf(sQLException)), (boolean)bl2);
        }
    }

    private static void judge_setXXX(boolean bl, SQLException sQLException, int n, int n2) {
        Object object;
        boolean bl2 = B2_MOD[n][n2];
        if (bl && bl2) {
            object = " JDBC MATCH(OK)";
        } else if (bl) {
            object = " CLOUD EXT (OK)";
        } else if (sQLException != null && "0A000".equals(sQLException.getSQLState())) {
            object = " Not Implemented (OK)";
        } else if (bl2) {
            if (sQLException != null) {
                ParameterMappingTest.showException(sQLException);
            }
            object = " JDBC FAIL " + SQLTypes[n2];
        } else {
            object = ParameterMappingTest.checkForInvalidConversion(sQLException);
            if (object == null) {
                return;
            }
        }
        if (((String)object).startsWith("JDBC FAIL")) {
            ParameterMappingTest.fail((String)(" JDBC FAIL " + SQLTypes[n2]));
        }
    }

    private static void judge_setObject(boolean bl, SQLException sQLException, int n, int n2) {
        Object object;
        boolean bl2 = B5[n][n2];
        if (bl && bl2) {
            object = " JDBC MATCH(OK)";
        } else if (bl) {
            object = " CLOUD EXT (OK)";
        } else if ("0A000".equals(sQLException.getSQLState())) {
            object = " Not Implemented (OK)";
        } else if (bl2) {
            if (sQLException != null) {
                ParameterMappingTest.showException(sQLException);
            }
            object = " JDBC FAIL " + SQLTypes[n2];
        } else {
            object = ParameterMappingTest.checkForInvalidConversion(sQLException);
            if (object == null) {
                return;
            }
        }
        if (((String)object).startsWith("JDBC FAIL")) {
            ParameterMappingTest.fail((String)(" JDBC FAIL " + SQLTypes[n2]));
        }
    }

    private static String checkForInvalidConversion(SQLException sQLException) {
        if (sQLException == null) {
            return null;
        }
        boolean bl = true;
        for (SQLException sQLException2 = sQLException; sQLException2 != null && bl; sQLException2 = sQLException2.getNextException()) {
            if (!"22005".equals(sQLException2.getSQLState()) && !"XCL12".equals(sQLException2.getSQLState()) && sQLException2.getMessage().indexOf("Illegal Conv") == -1) continue;
            bl = false;
            if (!"0A000".equals(sQLException2.getSQLState()) || sQLException2.getMessage().indexOf("setUnicodeStream") == -1) break;
            bl = false;
            break;
        }
        if (bl) {
            ParameterMappingTest.showException(sQLException);
        }
        return " JDBC MATCH (INVALID)";
    }

    private static void setXXX(Statement statement, PreparedStatement preparedStatement, PreparedStatement preparedStatement2, int n) throws SQLException, IOException {
        Object object;
        Object object2;
        boolean bl;
        statement.execute("DELETE FROM PM.TYPE_AS");
        Object object3 = null;
        try {
            preparedStatement.setByte(1, (byte)98);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setByte");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 0, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setByte(1, (byte)98);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setByte");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 0, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setShort(1, (short)98);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setShort");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 1, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setShort(1, (short)98);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setShort");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 1, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setInt(1, 98);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setInt");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 2, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setInt(1, 98);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setInt");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 2, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setLong(1, 98L);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setLong");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 3, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setLong(1, 98L);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setLong");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 3, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setFloat(1, 98.4f);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setFloat");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 4, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setFloat(1, 98.4f);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setFloat");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 4, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setDouble(1, 98.5);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setDouble");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 5, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setDouble(1, 98.5);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setDouble");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 5, n);
        if (HAVE_BIG_DECIMAL) {
            statement.execute("DELETE FROM PM.TYPE_AS");
            object3 = null;
            try {
                preparedStatement.setBigDecimal(1, new BigDecimal(98.0));
                preparedStatement.executeUpdate();
                ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBigDecimal");
                bl = true;
            }
            catch (SQLException sQLException) {
                object3 = sQLException;
                bl = false;
            }
            ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 6, n);
            statement.execute("DELETE FROM PM.TYPE_AS");
            object3 = null;
            try {
                preparedStatement.setBigDecimal(1, new BigDecimal(98.0));
                preparedStatement.addBatch();
                preparedStatement.executeBatch();
                ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBigDecimal");
                bl = true;
            }
            catch (SQLException sQLException) {
                object3 = sQLException;
                bl = false;
            }
            ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 6, n);
            statement.execute("DELETE FROM PM.TYPE_AS");
            object3 = null;
            try {
                preparedStatement.setBigDecimal(1, null);
                preparedStatement.executeUpdate();
                ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBigDecimal");
                bl = true;
            }
            catch (SQLException sQLException) {
                object3 = sQLException;
                bl = false;
            }
            ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 6, n);
            statement.execute("DELETE FROM PM.TYPE_AS");
            object3 = null;
            try {
                preparedStatement.setBigDecimal(1, null);
                preparedStatement.addBatch();
                preparedStatement.executeBatch();
                ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBigDecimal");
                bl = true;
            }
            catch (SQLException sQLException) {
                object3 = sQLException;
                bl = false;
            }
            ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 6, n);
        }
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setBoolean(1, true);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBoolean");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 7, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setBoolean(1, true);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBoolean");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 7, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setString(1, validString[n]);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setString");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        catch (Throwable throwable) {
            bl = false;
            object3 = null;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 8, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setString(1, validString[n]);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setString");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        catch (Throwable throwable) {
            bl = false;
            object3 = null;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 8, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setString(1, null);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setString");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        catch (Throwable throwable) {
            bl = false;
            object3 = null;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 8, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setString(1, null);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setString");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        catch (Throwable throwable) {
            bl = false;
            object3 = null;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 8, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        ParameterMappingTest.testSetStringInvalidValue(n, preparedStatement);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            object2 = new byte[]{4, 3, -3, -61, 115};
            preparedStatement.setBytes(1, (byte[])object2);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBytes");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 9, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            object2 = new byte[]{4, 3, -3, -61, 115};
            preparedStatement.setBytes(1, (byte[])object2);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBytes");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 9, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setBytes(1, null);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBytes");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 9, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setBytes(1, null);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBytes");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 9, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setDate(1, Date.valueOf("2004-02-14"));
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setDate");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 10, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setDate(1, Date.valueOf("2004-02-14"));
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setDate");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 10, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setDate(1, null);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setDate");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 10, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setDate(1, null);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setDate");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 10, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setTime(1, Time.valueOf("00:00:00"));
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setTime");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 11, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setTime(1, Time.valueOf("00:00:00"));
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setTime");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 11, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setTime(1, null);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setTime");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 11, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setTime(1, null);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setTime");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 11, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setTimestamp(1, Timestamp.valueOf("2004-02-14 00:00:00.0"));
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setTimestamp");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 12, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setTimestamp(1, Timestamp.valueOf("2004-02-14 00:00:00.0"));
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setTimestamp");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 12, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setTimestamp(1, null);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setTimestamp");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 12, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setTimestamp(1, null);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setTimestamp");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 12, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            object2 = new byte[]{101, 103, 48, 49, 50, 100};
            preparedStatement.setAsciiStream(1, (InputStream)new ByteArrayInputStream((byte[])object2), 6);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setAsciiStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 13, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            object2 = new byte[]{101, 103, 48, 49, 50, 100};
            preparedStatement.setAsciiStream(1, (InputStream)new ByteArrayInputStream((byte[])object2), 6);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setAsciiStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 13, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setAsciiStream(1, (InputStream)null, 0);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setAsciiStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 13, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setAsciiStream(1, (InputStream)null, 0);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setAsciiStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 13, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            object2 = new byte[]{4, 3, -54, -2, 0, 50};
            preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream((byte[])object2), 6);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBinaryStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 14, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            object2 = new byte[]{4, 3, -54, -2, 0, 50};
            preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream((byte[])object2), 6);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "getBinaryStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 14, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setBinaryStream(1, (InputStream)null, 0);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBinaryStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 14, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setBinaryStream(1, (InputStream)null, 0);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBinaryStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 14, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setCharacterStream(1, (Reader)new StringReader("89"), 2);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setCharacterStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 15, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setCharacterStream(1, (Reader)new StringReader("89"), 2);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setCharacterStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 15, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setCharacterStream(1, (Reader)null, 0);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setCharacterStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 15, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setCharacterStream(1, (Reader)null, 0);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setCharacterStream");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 15, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            object2 = statement.executeQuery("SELECT C FROM PM.LOB_GET WHERE ID = 1");
            object2.next();
            object = object2.getClob(1);
            object2.close();
            preparedStatement.setClob(1, (Clob)object);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setClob");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 16, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            object2 = statement.executeQuery("SELECT C FROM PM.LOB_GET WHERE ID = 1");
            object2.next();
            object = object2.getClob(1);
            object2.close();
            preparedStatement.setClob(1, (Clob)object);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setClob");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 16, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setClob(1, (Clob)null);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setClob");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 16, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setClob(1, (Clob)null);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setClob");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 16, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            object2 = statement.executeQuery("SELECT B FROM PM.LOB_GET WHERE ID = 1");
            object2.next();
            object = object2.getBlob(1);
            object2.close();
            preparedStatement.setBlob(1, (Blob)object);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBlob");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 17, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            object2 = statement.executeQuery("SELECT B FROM PM.LOB_GET WHERE ID = 1");
            object2.next();
            object = object2.getBlob(1);
            object2.close();
            preparedStatement.setBlob(1, (Blob)object);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBlob");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 17, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setBlob(1, (Blob)null);
            preparedStatement.executeUpdate();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBlob");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 17, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            preparedStatement.setBlob(1, (Blob)null);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setBlob");
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 17, n);
        statement.execute("DELETE FROM PM.TYPE_AS");
        object3 = null;
        try {
            object2 = new byte[6];
            object2[0] = 4;
            object2[1] = 3;
            object2[2] = -54;
            object2[3] = -2;
            object2[4] = 0;
            object2[5] = 50;
            ParameterMappingTest.setUnicodeStream(preparedStatement, 1, new ByteArrayInputStream((byte[])object2), 6);
            if (JDBC.vmSupportsJDBC3()) {
                preparedStatement.executeUpdate();
                ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setUnicodeStream");
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            object3 = sQLException;
            bl = false;
        }
        if (JDBC.vmSupportsJDBC3()) {
            ParameterMappingTest.judge_setXXX(bl, (SQLException)object3, 14, n);
        }
        ParameterMappingTest.setXXX_setObjectNullNoTypeSpec(statement, preparedStatement, preparedStatement2, n);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, validString[n], "java.lang.String", 0);
        if (HAVE_BIG_DECIMAL) {
            ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, BigDecimal.valueOf(98L), "java.math.BigDecimal", 1);
        }
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, Boolean.TRUE, "java.lang.Boolean", 2);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, (byte)98, "java.lang.Byte", 1);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, (short)98, "java.lang.Short", 2);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, 98, "java.lang.Integer", 3);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, 98, "java.lang.Long", 4);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, Float.valueOf(98.0f), "java.lang.Float", 5);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, 98.0, "java.lang.Double", 6);
        object3 = new byte[]{4, 3};
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, object3, "byte[]", 7);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, Date.valueOf("2004-02-14"), "java.sql.Date", 8);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, Time.valueOf("00:00:00"), "java.sql.Time", 9);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, Timestamp.valueOf("2004-02-14 00:00:00.0"), "java.sql.Timestamp", 10);
        statement.getConnection().commit();
        object3 = statement.executeQuery("SELECT B FROM PM.LOB_GET WHERE ID = 1");
        object3.next();
        Object object4 = object3.getBlob(1);
        object3.close();
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, object4, "java.sql.Blob", 11);
        object3 = statement.executeQuery("SELECT C FROM PM.LOB_GET WHERE ID = 1");
        object3.next();
        object4 = object3.getClob(1);
        object3.close();
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, object4, "java.sql.Clob", 12);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, new BigInteger(Long.toString(98L)), "java.math.BigInteger", 15);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, new java.util.Date(50L), "java.util.Date", 16);
        ParameterMappingTest.setXXX_setObject(statement, preparedStatement, preparedStatement2, n, ParameterMappingTest.makeCalendar(60L), "java.util.Calendar", 17);
    }

    private static void setUnicodeStream(PreparedStatement preparedStatement, int n, InputStream inputStream, int n2) throws SQLException {
        preparedStatement.setUnicodeStream(n, inputStream, n2);
    }

    private static void setXXX_setObject(Statement statement, PreparedStatement preparedStatement, PreparedStatement preparedStatement2, int n, Object object, String string, int n2) throws SQLException, IOException {
        ParameterMappingTest.setXXX_setObject_doWork(statement, preparedStatement, preparedStatement2, n, object, string, n2, false, false);
        ParameterMappingTest.setXXX_setObject_doWork(statement, preparedStatement, preparedStatement2, n, object, string, n2, false, true);
        ParameterMappingTest.setXXX_setObject_doWork(statement, preparedStatement, preparedStatement2, n, object, string, n2, true, false);
        ParameterMappingTest.setXXX_setObject_doWork(statement, preparedStatement, preparedStatement2, n, object, string, n2, true, true);
    }

    private static void setXXX_setObject_doWork(Statement statement, PreparedStatement preparedStatement, PreparedStatement preparedStatement2, int n, Object object, String string, int n2, boolean bl, boolean bl2) throws SQLException, IOException {
        boolean bl3;
        int n3 = jdbcTypes[n];
        String string2 = "setObject(" + string + ")";
        statement.execute("DELETE FROM PM.TYPE_AS");
        SQLException sQLException = null;
        try {
            if (bl) {
                preparedStatement.setObject(1, object, n3);
            } else {
                preparedStatement.setObject(1, object);
            }
            if (bl2) {
                preparedStatement.addBatch();
                preparedStatement.executeBatch();
            } else {
                preparedStatement.executeUpdate();
            }
            ParameterMappingTest.getValidValue(preparedStatement2, n3, string2);
            bl3 = true;
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
            bl3 = false;
        }
        ParameterMappingTest.judge_setObject(bl3, sQLException, n2, n);
    }

    private static void setXXX_setObjectNullNoTypeSpec(Statement statement, PreparedStatement preparedStatement, PreparedStatement preparedStatement2, int n) throws SQLException, IOException {
        statement.execute("DELETE FROM PM.TYPE_AS");
        preparedStatement.setObject(1, null);
        preparedStatement.executeUpdate();
        ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setObject");
        statement.execute("DELETE FROM PM.TYPE_AS");
        preparedStatement.setObject(1, null);
        preparedStatement.addBatch();
        preparedStatement.executeBatch();
        ParameterMappingTest.getValidValue(preparedStatement2, jdbcTypes[n], "setObject");
    }

    private static void showException(SQLException sQLException) {
        String string;
        String string2 = sQLException.getSQLState();
        if (string2 == null) {
            string2 = "?????";
        }
        if ((string = sQLException.getMessage()) == null) {
            string = "?? no message ??";
        }
        ParameterMappingTest.fail(" (" + string2 + "):" + string, sQLException);
    }

    private static boolean setValidValue(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        switch (n2) {
            case -7: 
            case 16: {
                preparedStatement.setBoolean(n, true);
                return true;
            }
            case -6: {
                preparedStatement.setByte(n, (byte)32);
                return true;
            }
            case 5: {
                preparedStatement.setShort(n, (short)32);
                return true;
            }
            case 4: {
                preparedStatement.setInt(n, 32);
                return true;
            }
            case -5: {
                preparedStatement.setLong(n, 32L);
                return true;
            }
            case 7: {
                preparedStatement.setFloat(n, 32.0f);
                return true;
            }
            case 6: 
            case 8: {
                preparedStatement.setDouble(n, 32.0);
                return true;
            }
            case 3: {
                BigDecimalHandler.setBigDecimalString(preparedStatement, n, "32.0");
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                preparedStatement.setString(n, "32");
                return true;
            }
            case -3: 
            case -2: {
                byte[] byArray = new byte[]{4, 3, -3, -61, 115};
                preparedStatement.setBytes(n, byArray);
                return true;
            }
            case 91: {
                preparedStatement.setDate(n, Date.valueOf("2004-02-14"));
                return true;
            }
            case 92: {
                preparedStatement.setTime(n, Time.valueOf("17:14:24"));
                return true;
            }
            case 93: {
                preparedStatement.setTimestamp(n, Timestamp.valueOf("2004-02-14 17:14:24.097625551"));
                return true;
            }
            case 2005: {
                preparedStatement.setCharacterStream(n, (Reader)new StringReader("67"), 2);
                return true;
            }
            case 2004: {
                byte[] byArray = new byte[]{-126, 67, -54, -2, 0, 50};
                preparedStatement.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), 6);
                return true;
            }
        }
        return false;
    }

    private static boolean getValidValue(PreparedStatement preparedStatement, int n, String string) throws SQLException, IOException {
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        switch (n) {
            case 5: {
                short s = resultSet.getShort(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertEquals((int)0, (int)s);
                } else if (ParameterMappingTest.isBooleanMethod(string)) {
                    ParameterMappingTest.assertEquals((int)1, (int)s);
                } else {
                    ParameterMappingTest.assertEquals((int)98, (int)s);
                }
                return true;
            }
            case 4: {
                int n2 = resultSet.getInt(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertEquals((int)0, (int)n2);
                } else if (ParameterMappingTest.isBooleanMethod(string)) {
                    ParameterMappingTest.assertEquals((int)1, (int)n2);
                } else {
                    ParameterMappingTest.assertEquals((int)98, (int)n2);
                }
                return true;
            }
            case -5: {
                long l = resultSet.getLong(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertEquals((long)0L, (long)l);
                } else if (ParameterMappingTest.isBooleanMethod(string)) {
                    ParameterMappingTest.assertEquals((long)1L, (long)l);
                } else {
                    ParameterMappingTest.assertEquals((long)98L, (long)l);
                }
                return true;
            }
            case 7: {
                float f = resultSet.getFloat(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertEquals((double)0.0, (double)f, (double)0.001);
                } else if (ParameterMappingTest.isBooleanMethod(string)) {
                    ParameterMappingTest.assertEquals((double)1.0, (double)f, (double)0.001);
                } else if (string.equals("setFloat")) {
                    ParameterMappingTest.assertEquals((double)98.4, (double)f, (double)0.001);
                } else if (string.equals("setDouble")) {
                    ParameterMappingTest.assertEquals((double)98.5, (double)f, (double)0.001);
                } else {
                    ParameterMappingTest.assertEquals((double)98.0, (double)f, (double)0.001);
                }
                return true;
            }
            case 6: 
            case 8: {
                double d = resultSet.getDouble(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertEquals((double)0.0, (double)d, (double)0.001);
                } else if (ParameterMappingTest.isBooleanMethod(string)) {
                    ParameterMappingTest.assertEquals((double)1.0, (double)d, (double)0.001);
                } else if (string.equals("setFloat")) {
                    ParameterMappingTest.assertEquals((double)98.4, (double)d, (double)0.001);
                } else if (string.equals("setDouble")) {
                    ParameterMappingTest.assertEquals((double)98.5, (double)d, (double)0.001);
                } else {
                    ParameterMappingTest.assertEquals((double)98.0, (double)d, (double)0.001);
                }
                return true;
            }
            case 3: {
                String string2 = BigDecimalHandler.getBigDecimalString(resultSet, 1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertNull((Object)string2);
                } else if (ParameterMappingTest.isBooleanMethod(string)) {
                    ParameterMappingTest.assertEquals((String)"1.00000", (String)string2);
                } else if (string.equals("setFloat")) {
                    ParameterMappingTest.assertEquals((String)"98.40000", (String)string2);
                } else if (string.equals("setDouble")) {
                    ParameterMappingTest.assertEquals((String)"98.50000", (String)string2);
                } else {
                    ParameterMappingTest.assertEquals((String)"98.00000", (String)string2);
                }
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                String string3 = resultSet.getString(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertNull((Object)string3);
                } else {
                    int n3;
                    if (string3.startsWith("com.ibm.db2.jcc.") || string3.startsWith("org.apache.derby.client")) {
                        string3 = "<OBJECT.toString()>";
                    }
                    boolean bl2 = false;
                    for (int i = 0; i < string3.length(); ++i) {
                        n3 = string3.charAt(i);
                        if (n3 >= 32 && n3 < 127) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("EncodedString: >");
                        for (n3 = 0; n3 < string3.length(); ++n3) {
                            stringBuffer.append(' ');
                            stringBuffer.append((int)string3.charAt(n3));
                        }
                        stringBuffer.append(" <");
                        string3 = stringBuffer.toString();
                    }
                    ParameterMappingTest.checkValidStringValue(string, string3);
                }
                return true;
            }
            case -3: 
            case -2: {
                byte[] byArray = resultSet.getBytes(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertNull((Object)byArray);
                } else {
                    ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(byArray));
                }
                return true;
            }
            case -4: {
                InputStream inputStream = resultSet.getBinaryStream(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertNull((Object)inputStream);
                } else {
                    ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(inputStream));
                }
                return true;
            }
            case 91: {
                Date date = resultSet.getDate(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertNull((Object)date);
                } else if (DATE_METHOD_NAME.equals(string)) {
                    ParameterMappingTest.assertEquals((String)new Date(50L).toString(), (String)date.toString());
                } else if (CALENDAR_METHOD_NAME.equals(string)) {
                    ParameterMappingTest.assertEquals((String)new Date(60L).toString(), (String)date.toString());
                } else {
                    ParameterMappingTest.assertEquals((Object)Date.valueOf("2004-02-14"), (Object)date);
                }
                return true;
            }
            case 92: {
                Time time = resultSet.getTime(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertNull((Object)time);
                } else if (DATE_METHOD_NAME.equals(string)) {
                    ParameterMappingTest.assertEquals((String)new Time(50L).toString(), (String)time.toString());
                } else if (CALENDAR_METHOD_NAME.equals(string)) {
                    ParameterMappingTest.assertEquals((String)new Time(60L).toString(), (String)time.toString());
                } else {
                    ParameterMappingTest.assertEquals((Object)Time.valueOf("00:00:00"), (Object)time);
                }
                return true;
            }
            case 93: {
                Timestamp timestamp = resultSet.getTimestamp(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertNull((Object)resultSet.getTimestamp(1));
                } else if (DATE_METHOD_NAME.equals(string)) {
                    ParameterMappingTest.assertEquals((String)new Timestamp(50L).toString(), (String)timestamp.toString());
                } else if (CALENDAR_METHOD_NAME.equals(string)) {
                    ParameterMappingTest.assertEquals((String)new Timestamp(60L).toString(), (String)timestamp.toString());
                } else {
                    ParameterMappingTest.assertEquals((Object)Timestamp.valueOf("2004-02-14 00:00:00.0"), (Object)timestamp);
                }
                return true;
            }
            case 2005: {
                Clob clob = resultSet.getClob(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertNull((Object)clob);
                } else {
                    char[] cArray = new char[20];
                    int n4 = clob.getCharacterStream().read(cArray);
                    String string4 = new String(cArray, 0, n4);
                    if ("setString".equals(string)) {
                        ParameterMappingTest.assertEquals((String)"98", (String)string4);
                    } else if ("setAsciiStream".equals(string)) {
                        ParameterMappingTest.assertEquals((String)"eg012d", (String)string4);
                    } else if ("setCharacterStream".equals(string)) {
                        ParameterMappingTest.assertEquals((String)"89", (String)string4);
                    } else if ("setClob".equals(string)) {
                        ParameterMappingTest.assertEquals((String)"72", (String)string4);
                    } else if ("setObject(java.lang.String)".equals(string)) {
                        ParameterMappingTest.assertEquals((String)"98", (String)string4);
                    } else if ("setObject(java.lang.Clob)".equals(string)) {
                        ParameterMappingTest.assertEquals((String)"72", (String)string4);
                    }
                }
                return true;
            }
            case 2004: {
                Blob blob = resultSet.getBlob(1);
                boolean bl = resultSet.wasNull();
                if (bl) {
                    ParameterMappingTest.assertNull((Object)blob);
                } else {
                    ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(blob.getBinaryStream()));
                }
                return true;
            }
            case 16: {
                boolean bl = resultSet.getBoolean(1);
                boolean bl3 = resultSet.wasNull();
                if (bl3) {
                    ParameterMappingTest.assertFalse((boolean)bl);
                } else {
                    ParameterMappingTest.assertTrue((boolean)bl);
                }
                return true;
            }
        }
        ParameterMappingTest.fail((String)("FAIL JDBC TYPE IN getValidValue " + JDBC.sqlNameFromJdbc(n)));
        return false;
    }

    private static void checkValidStringValue(String string, String string2) {
        string2 = string2.trim();
        if (ParameterMappingTest.isBooleanMethod(string)) {
            ParameterMappingTest.assertEquals((String)"true", (String)string2);
        } else if ("setBytes".equals(string) || "setObject(byte[])".equals(string)) {
            ParameterMappingTest.assertEquals((String)"EncodedString: > 1027 ", (String)string2.substring(0, 22));
        } else if ("setFloat".equals(string)) {
            ParameterMappingTest.assertEquals((String)"98.4", (String)string2);
        } else if ("setDouble".equals(string)) {
            ParameterMappingTest.assertEquals((String)"98.5", (String)string2);
        } else if ("setDate".equals(string) || "setObject(java.sql.Date)".equals(string)) {
            ParameterMappingTest.assertEquals((String)"2004-02-14", (String)string2);
        } else if ("setTime".equals(string) || "setObject(java.sql.Time)".equals(string)) {
            ParameterMappingTest.assertEquals((String)"00:00:00", (String)string2);
        } else if ("setTimestamp".equals(string) || "setObject(java.sql.Timestamp)".equals(string)) {
            ParameterMappingTest.assertEquals((String)"2004-02-14 00:00:00.0", (String)string2);
        } else if ("setAsciiStream".equals(string)) {
            ParameterMappingTest.assertEquals((String)"eg012d", (String)string2);
        } else if ("setCharacterStream".equals(string)) {
            ParameterMappingTest.assertEquals((String)"89", (String)string2);
        } else if ("setObject(java.lang.Float)".equals(string) || "setObject(java.lang.Double)".equals(string)) {
            ParameterMappingTest.assertEquals((String)"98.0", (String)string2);
        } else if (DATE_METHOD_NAME.equals(string)) {
            ParameterMappingTest.assertEquals((String)new Timestamp(50L).toString(), (String)string2);
        } else if (CALENDAR_METHOD_NAME.equals(string)) {
            ParameterMappingTest.assertEquals((String)new Timestamp(60L).toString(), (String)string2);
        } else {
            ParameterMappingTest.assertEquals((String)"98", (String)string2.trim());
        }
    }

    private static boolean isBooleanMethod(String string) {
        return string.equals("setBoolean") || string.equals("setObject(java.lang.Boolean)");
    }

    private static boolean getOutValue(CallableStatement callableStatement, int n, int n2, int n3) throws SQLException, IOException {
        int n4 = jdbcTypes[n3];
        switch (n2) {
            case -7: 
            case 16: {
                boolean bl = callableStatement.getBoolean(n);
                boolean bl2 = callableStatement.wasNull();
                if (!bl2) {
                    ParameterMappingTest.assertTrue((boolean)bl);
                }
                return true;
            }
            case -6: {
                byte by = callableStatement.getByte(n);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, by);
                }
                return true;
            }
            case 5: {
                short s = callableStatement.getShort(n);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, s);
                }
                return true;
            }
            case 4: {
                int n5 = callableStatement.getInt(n);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, n5);
                }
                return true;
            }
            case -5: {
                long l = callableStatement.getLong(n);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, l);
                }
                return true;
            }
            case 7: {
                float f = callableStatement.getFloat(n);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, f);
                }
                return true;
            }
            case 6: 
            case 8: {
                double d = callableStatement.getDouble(n);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, d);
                }
                return true;
            }
            case 3: {
                String string = BigDecimalHandler.getBigDecimalString(callableStatement, n, n2);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, string);
                }
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                String string = callableStatement.getString(n);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, string.trim());
                }
                return true;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = callableStatement.getBytes(n);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, byArray);
                }
                return true;
            }
            case 91: {
                Date date = callableStatement.getDate(n);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, date);
                }
                return true;
            }
            case 92: {
                Time time = callableStatement.getTime(n);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, time);
                }
                return true;
            }
            case 93: {
                Timestamp timestamp = callableStatement.getTimestamp(n);
                boolean bl = callableStatement.wasNull();
                if (!bl) {
                    ParameterMappingTest.checkProcedureOutput(n, n3, timestamp);
                }
                return true;
            }
            case 2005: {
                Clob clob = callableStatement.getClob(n);
                boolean bl = callableStatement.wasNull();
                return true;
            }
            case 2004: {
                Blob blob = callableStatement.getBlob(n);
                boolean bl = callableStatement.wasNull();
                return true;
            }
        }
        ParameterMappingTest.fail((String)("FAIL JDBC TYPE IN getOutValue " + JDBC.sqlNameFromJdbc(n2)));
        return false;
    }

    private static void checkProcedureOutput(int n, int n2, byte by) {
        ParameterMappingTest.checkProcedureOutput(n, n2, (long)by);
    }

    private static void checkProcedureOutput(int n, int n2, short s) {
        ParameterMappingTest.checkProcedureOutput(n, n2, (long)s);
    }

    private static void checkProcedureOutput(int n, int n2, int n3) {
        ParameterMappingTest.checkProcedureOutput(n, n2, (long)n3);
    }

    private static void checkProcedureOutput(int n, int n2, long l) {
        switch (jdbcTypes[n2]) {
            case 5: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((long)38L, (long)l);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((long)77L, (long)l);
                break;
            }
            case 4: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((long)41L, (long)l);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((long)88L, (long)l);
                break;
            }
            case -5: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((long)40L, (long)l);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((long)99L, (long)l);
                break;
            }
            case 6: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((long)35L, (long)l);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((long)66L, (long)l);
                break;
            }
            case 7: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((long)41L, (long)l);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((long)88L, (long)l);
                break;
            }
            case 3: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((long)34L, (long)l);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((long)84L, (long)l);
                break;
            }
            case 8: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((long)35L, (long)l);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((long)66L, (long)l);
            }
        }
    }

    private static void checkProcedureOutput(int n, int n2, float f) {
        ParameterMappingTest.checkProcedureOutput(n, n2, (double)f);
    }

    private static void checkProcedureOutput(int n, int n2, double d) {
        switch (jdbcTypes[n2]) {
            case 5: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((double)38.0, (double)d, (double)1.0E-5);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((double)77.0, (double)d, (double)1.0E-5);
                break;
            }
            case 4: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((double)41.0, (double)d, (double)1.0E-5);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((double)88.0, (double)d, (double)1.0E-5);
                break;
            }
            case -5: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((double)40.0, (double)d, (double)1.0E-5);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((double)99.0, (double)d, (double)1.0E-5);
                break;
            }
            case 6: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((double)35.9, (double)d, (double)1.0E-5);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((double)66.8, (double)d, (double)1.0E-5);
                break;
            }
            case 7: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((double)41.9, (double)d, (double)1.0E-5);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((double)88.8, (double)d, (double)1.0E-5);
                break;
            }
            case 3: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((double)34.29999, (double)d, (double)1.0E-4);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((double)84.09999, (double)d, (double)1.0E-4);
                break;
            }
            case 8: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((double)35.9, (double)d, (double)1.0E-5);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((double)66.8, (double)d, (double)1.0E-5);
            }
        }
    }

    private static void checkProcedureOutput(int n, int n2, String string) {
        switch (jdbcTypes[n2]) {
            case 5: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"38", (String)string);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"77", (String)string);
                break;
            }
            case 4: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"41", (String)string);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"88", (String)string);
                break;
            }
            case -5: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"40", (String)string);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"99", (String)string);
                break;
            }
            case 6: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"35.9", (String)string);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"66.8", (String)string);
                break;
            }
            case 7: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"41.9", (String)string);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"88.8", (String)string);
                break;
            }
            case 3: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"34.29999", (String)string);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"84.09999", (String)string);
                break;
            }
            case 8: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"35.9", (String)string);
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"66.8", (String)string);
            }
        }
    }

    private static void checkProcedureOutput(int n, int n2, byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = jdbcTypes[n2] == 2004;
        if (n == 2) {
            if (bl) {
                ParameterMappingTest.assertEquals((String)"0x82,0x43", (String)ParameterMappingTest.showFirstTwo(byArray));
            } else {
                ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(byArray));
            }
        } else if (n == 3) {
            if (bl) {
                ParameterMappingTest.assertEquals((String)"0x1,0x2", (String)ParameterMappingTest.showFirstTwo(byArray));
            } else {
                ParameterMappingTest.assertEquals((String)"0x9,0xfe", (String)ParameterMappingTest.showFirstTwo(byArray));
            }
        }
    }

    private static void checkProcedureOutput(int n, int n2, Date date) {
        switch (jdbcTypes[n2]) {
            case 91: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"2004-03-08", (String)date.toString());
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"2005-03-08", (String)date.toString());
                break;
            }
            case 93: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"2004-03-12", (String)date.toString());
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"2004-04-12", (String)date.toString());
            }
        }
    }

    private static void checkProcedureOutput(int n, int n2, Time time) {
        switch (jdbcTypes[n2]) {
            case 92: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"19:44:42", (String)time.toString());
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"20:44:42", (String)time.toString());
                break;
            }
            case 93: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"21:14:24", (String)time.toString());
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"04:25:26", (String)time.toString());
            }
        }
    }

    private static void checkProcedureOutput(int n, int n2, Timestamp timestamp) {
        switch (jdbcTypes[n2]) {
            case 91: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"2004-03-08 00:00:00.0", (String)timestamp.toString());
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"2005-03-08 00:00:00.0", (String)timestamp.toString());
                break;
            }
            case 92: {
                ParameterMappingTest.assertNotNull((Object)timestamp);
                break;
            }
            case 93: {
                if (n == 2) {
                    ParameterMappingTest.assertEquals((String)"2004-03-12 21:14:24.938222433", (String)timestamp.toString());
                    break;
                }
                if (n != 3) break;
                ParameterMappingTest.assertEquals((String)"2004-04-12 04:25:26.462983731", (String)timestamp.toString());
            }
        }
    }

    static void dumpSQLExceptions(SQLException sQLException) {
        while (sQLException != null) {
            System.out.println("SQLSTATE(" + sQLException.getSQLState() + "): " + sQLException.toString());
            sQLException = sQLException.getNextException();
        }
    }

    private static void testSetStringInvalidValue(int n, PreparedStatement preparedStatement) {
        switch (jdbcTypes[n]) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return;
            }
        }
        String string = SQLTypes[n];
        try {
            preparedStatement.setString(1, "Invalid Value");
            preparedStatement.executeUpdate();
            String string2 = "FAIL - setString(1,\"Invalld Value\") for type " + string + " did not throw an exception as expected";
        }
        catch (SQLException sQLException) {
            if (!("22018".equals(sQLException.getSQLState()) || "XCL12".equals(sQLException.getSQLState()) || "22007".equals(sQLException.getSQLState()) || "22005".equals(sQLException.getSQLState()) || sQLException.getMessage().indexOf("Invalid data conversion") != -1 || sQLException.getMessage().indexOf("Illegal Conversion") != -1)) {
                ParameterMappingTest.fail((String)("FAIL:" + sQLException.getMessage()));
            }
        }
        catch (Exception exception) {
            ParameterMappingTest.fail((String)("FAIL: Unexpected Exception " + exception.getMessage()));
        }
    }

    private static String showFirstTwo(Reader reader) throws IOException {
        int n = reader.read();
        int n2 = reader.read();
        reader.close();
        return "0x" + Integer.toHexString(n) + ",0x" + Integer.toHexString(n2);
    }

    private static String showFirstTwo(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        inputStream.close();
        return "0x" + Integer.toHexString(n) + ",0x" + Integer.toHexString(n2);
    }

    private static String showFirstTwo(byte[] byArray) {
        byte by = byArray[0];
        byte by2 = byArray[1];
        return "0x" + Integer.toHexString(by & 0xFF) + ",0x" + Integer.toHexString(by2 & 0xFF);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ParameterMappingTest.class);
    }

    public static void pmap(short s, short[] sArray, short[] sArray2) {
        sArray[0] = (short)(sArray[0] + 6);
        sArray2[0] = 77;
    }

    public static void pmap(int n, int[] nArray, int[] nArray2) {
        nArray[0] = nArray[0] + 9;
        nArray2[0] = 88;
    }

    public static void pmap(boolean bl, boolean[] blArray, boolean[] blArray2) {
        blArray[0] = true;
        blArray2[0] = true;
    }

    public static void pmap(long l, long[] lArray, long[] lArray2) {
        lArray[0] = lArray[0] + 8L;
        lArray2[0] = 99L;
    }

    public static void pmap(float f, float[] fArray, float[] fArray2) {
        fArray[0] = fArray[0] + 9.9f;
        fArray2[0] = 88.8f;
    }

    public static void pmap(double d, double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] + 3.9;
        dArray2[0] = 66.8;
    }

    public static void pmap(byte[] byArray, byte[][] byArray2, byte[][] byArray3) {
        byArray2[0][2] = 86;
        byArray3[0] = new byte[4];
        byArray3[0][0] = 9;
        byArray3[0][1] = -2;
        byArray3[0][2] = -19;
        byArray3[0][3] = 2;
    }

    public static void pmap(Date date, Date[] dateArray, Date[] dateArray2) {
        dateArray[0] = Date.valueOf("2004-03-08");
        dateArray2[0] = Date.valueOf("2005-03-08");
    }

    public static void pmap(Time time, Time[] timeArray, Time[] timeArray2) {
        timeArray[0] = Time.valueOf("19:44:42");
        timeArray2[0] = Time.valueOf("20:44:42");
    }

    public static void pmap(Timestamp timestamp, Timestamp[] timestampArray, Timestamp[] timestampArray2) {
        timestampArray[0] = Timestamp.valueOf("2004-03-12 21:14:24.938222433");
        timestampArray2[0] = Timestamp.valueOf("2004-04-12 04:25:26.462983731");
    }

    public static void pmap(String string, String[] stringArray, String[] stringArray2) {
        stringArray[0] = stringArray[0].trim().concat("P2-PMAP");
        stringArray2[0] = "P3-PMAP";
    }

    public static void pmap(BigDecimal bigDecimal, BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        bigDecimalArray[0] = bigDecimalArray[0].add(new BigDecimal(2.3));
        bigDecimalArray2[0] = new BigDecimal(84.1);
    }

    public static void pmap(Blob blob, Blob[] blobArray, Blob[] blobArray2) throws SQLException {
        int n = (int)blob.length();
        int n2 = (int)blobArray[0].length();
        byte[] byArray = blob.getBytes(1L, n);
        byte[] byArray2 = blobArray[0].getBytes(1L, n2);
        byte[] byArray3 = new byte[n + n2];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, n2);
        blobArray[0] = new HarmonySerialBlob(byArray3);
        blobArray2[0] = new HarmonySerialBlob(new byte[]{1, 2, 3});
    }

    public static void pmap(Clob clob, Clob[] clobArray, Clob[] clobArray2) throws SQLException {
        clobArray[0] = new HarmonySerialClob(clob.getSubString(1L, (int)clob.length()) + clobArray[0].getSubString(1L, (int)clobArray[0].length()));
        clobArray2[0] = new HarmonySerialClob("abc");
    }

    public static void clobIn(Clob clob, String[] stringArray) throws SQLException {
        stringArray[0] = ParameterMappingTest.getClobValue(clob);
    }

    public static void clobOut(Clob[] clobArray) throws SQLException {
        clobArray[0] = new HarmonySerialClob("abc");
    }

    public static void clobInOut(Clob[] clobArray) throws SQLException {
        String string = ParameterMappingTest.getClobValue(clobArray[0]);
        char[] cArray = string.toCharArray();
        char[] cArray2 = ParameterMappingTest.reverse(cArray);
        clobArray[0] = new HarmonySerialClob(new String(cArray2));
    }

    private static String getClobValue(Clob clob) throws SQLException {
        return clob.getSubString(1L, (int)clob.length());
    }

    private static char[] reverse(char[] cArray) {
        int n = cArray.length;
        char[] cArray2 = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray2[i] = cArray[n - i - 1];
        }
        return cArray2;
    }

    public static void blobIn(Blob blob, String[] stringArray) throws Exception {
        stringArray[0] = ParameterMappingTest.getBlobValue(blob);
    }

    public static void blobOut(Blob[] blobArray) throws Exception {
        blobArray[0] = new HarmonySerialBlob("abc".getBytes(UTF8));
    }

    public static void blobInOut(Blob[] blobArray) throws Exception {
        String string = ParameterMappingTest.getBlobValue(blobArray[0]);
        char[] cArray = string.toCharArray();
        char[] cArray2 = ParameterMappingTest.reverse(cArray);
        blobArray[0] = new HarmonySerialBlob(new String(cArray2).getBytes(UTF8));
    }

    private static String getBlobValue(Blob blob) throws Exception {
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        return new String(byArray, UTF8);
    }

    @Override
    protected PreparedStatement chattyPrepare(Connection connection, String string) throws SQLException {
        ParameterMappingTest.println("Preparing statement:\n\t" + string);
        return connection.prepareStatement(string);
    }

    @Override
    protected CallableStatement chattyPrepareCall(Connection connection, String string) throws SQLException {
        ParameterMappingTest.println("Preparing statement:\n\t" + string);
        return connection.prepareCall(string);
    }

    @Override
    protected void expectCompilationError(String string, String string2) {
        ParameterMappingTest.println("\nExpecting " + string + " when preparing:\n\t" + string2);
        this.assertCompileError(string, string2);
    }

    public void testDerby5533GetXXX() throws SQLException {
        String string = "CREATE TABLE MultiTypeTable (F01 SMALLINT,F02 INTEGER,F03 BIGINT,F04 REAL,F05 FLOAT,F06 DOUBLE,F07 DECIMAL(31),F08 NUMERIC,F09 CHAR(100),F10 VARCHAR(256),F11 BOOLEAN)";
        Statement statement = this.createStatement();
        statement.executeUpdate(string);
        PreparedStatement preparedStatement = this.prepareStatement("insert into MultiTypeTable values(?,?,?,?,?,?,?,?,?,?,?)");
        preparedStatement.setShort(1, (short)128);
        preparedStatement.setInt(2, 32768);
        preparedStatement.setLong(3, 0x80000000L);
        preparedStatement.setFloat(4, 9.223372E19f);
        preparedStatement.setFloat(5, 9.223372E19f);
        preparedStatement.setDouble(6, 3.4028234663852886E39);
        preparedStatement.setBigDecimal(7, new BigDecimal("9999999999999999999999999999999"));
        preparedStatement.setInt(8, -1);
        preparedStatement.setString(9, " ");
        preparedStatement.setString(10, " ");
        preparedStatement.setBoolean(11, true);
        preparedStatement.executeUpdate();
        PreparedStatement preparedStatement2 = this.prepareStatement("select * from MultiTypeTable");
        ResultSet resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        this.assertGetState(resultSet, "F01", 0, WONT_FIT);
        this.assertGetState(resultSet, "F02", 0, WONT_FIT);
        this.assertGetState(resultSet, "F03", 0, WONT_FIT);
        this.assertGetState(resultSet, "F04", 0, WONT_FIT);
        this.assertGetState(resultSet, "F05", 0, WONT_FIT);
        this.assertGetState(resultSet, "F06", 0, WONT_FIT);
        this.assertGetState(resultSet, "F07", 0, WONT_FIT);
        this.assertGetState(resultSet, "F02", 1, WONT_FIT);
        this.assertGetState(resultSet, "F03", 1, WONT_FIT);
        this.assertGetState(resultSet, "F04", 1, WONT_FIT);
        this.assertGetState(resultSet, "F05", 1, WONT_FIT);
        this.assertGetState(resultSet, "F06", 1, WONT_FIT);
        this.assertGetState(resultSet, "F07", 1, WONT_FIT);
        this.assertGetState(resultSet, "F03", 2, WONT_FIT);
        this.assertGetState(resultSet, "F04", 2, WONT_FIT);
        this.assertGetState(resultSet, "F05", 2, WONT_FIT);
        this.assertGetState(resultSet, "F06", 2, WONT_FIT);
        this.assertGetState(resultSet, "F07", 2, WONT_FIT);
        this.assertGetState(resultSet, "F04", 3, WONT_FIT);
        this.assertGetState(resultSet, "F05", 3, WONT_FIT);
        this.assertGetState(resultSet, "F06", 3, WONT_FIT);
        this.assertGetState(resultSet, "F07", 3, WONT_FIT);
        resultSet.close();
        PreparedStatement preparedStatement3 = this.prepareStatement("SELECT * FROM MultiTypeTable", 1003, 1008);
        resultSet = preparedStatement3.executeQuery();
        resultSet.next();
        resultSet.updateDouble("F06", 3.4028234663852886E39);
        resultSet.updateRow();
        resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        this.assertGetState(resultSet, "F06", 4, WONT_FIT);
        PreparedStatement preparedStatement4 = this.prepareStatement("delete from MultiTypeTable");
        preparedStatement4.executeUpdate();
        preparedStatement.setShort(1, (short)-129);
        preparedStatement.setInt(2, -32769);
        preparedStatement.setLong(3, -2147483649L);
        preparedStatement.setFloat(4, -9.223372E19f);
        preparedStatement.setFloat(5, -9.223372E19f);
        preparedStatement.setDouble(6, -3.4028234663852886E39);
        preparedStatement.setBigDecimal(7, new BigDecimal("-999999999999999999999999999999"));
        preparedStatement.setInt(8, -1);
        preparedStatement.setString(9, " ");
        preparedStatement.setString(10, " ");
        preparedStatement.setBoolean(11, false);
        preparedStatement.executeUpdate();
        resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        this.assertGetState(resultSet, "F01", 0, WONT_FIT);
        this.assertGetState(resultSet, "F02", 0, WONT_FIT);
        this.assertGetState(resultSet, "F03", 0, WONT_FIT);
        this.assertGetState(resultSet, "F04", 0, WONT_FIT);
        this.assertGetState(resultSet, "F05", 0, WONT_FIT);
        this.assertGetState(resultSet, "F06", 0, WONT_FIT);
        this.assertGetState(resultSet, "F07", 0, WONT_FIT);
        this.assertGetState(resultSet, "F02", 1, WONT_FIT);
        this.assertGetState(resultSet, "F03", 1, WONT_FIT);
        this.assertGetState(resultSet, "F04", 1, WONT_FIT);
        this.assertGetState(resultSet, "F05", 1, WONT_FIT);
        this.assertGetState(resultSet, "F06", 1, WONT_FIT);
        this.assertGetState(resultSet, "F07", 1, WONT_FIT);
        this.assertGetState(resultSet, "F03", 2, WONT_FIT);
        this.assertGetState(resultSet, "F04", 2, WONT_FIT);
        this.assertGetState(resultSet, "F05", 2, WONT_FIT);
        this.assertGetState(resultSet, "F06", 2, WONT_FIT);
        this.assertGetState(resultSet, "F07", 2, WONT_FIT);
        this.assertGetState(resultSet, "F04", 3, WONT_FIT);
        this.assertGetState(resultSet, "F05", 3, WONT_FIT);
        this.assertGetState(resultSet, "F06", 3, WONT_FIT);
        resultSet.close();
        resultSet = preparedStatement3.executeQuery();
        resultSet.next();
        resultSet.updateDouble("F06", -3.4028234663852886E39);
        resultSet.updateRow();
        resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        this.assertGetState(resultSet, "F06", 4, WONT_FIT);
    }

    public void testDerby5533UpdateXXX() throws SQLException {
        String string = "CREATE TABLE MultiTypeTable (F01 SMALLINT,F02 INTEGER,F03 BIGINT,F04 REAL,F05 FLOAT,F06 DOUBLE,F07 DECIMAL(31),F08 NUMERIC,F09 CHAR(100),F10 VARCHAR(256),F11 BOOLEAN)";
        Statement statement = this.createStatement();
        statement.executeUpdate(string);
        PreparedStatement preparedStatement = this.prepareStatement("insert into MultiTypeTable values(?,?,?,?,?,?,?,?,?,?,?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from MultiTypeTable");
        preparedStatement.setShort(1, (short)1);
        preparedStatement.setInt(2, 1);
        preparedStatement.setLong(3, 1L);
        preparedStatement.setFloat(4, 1.0f);
        preparedStatement.setDouble(5, 1.0);
        preparedStatement.setDouble(6, 1.0);
        preparedStatement.setString(7, "1");
        preparedStatement.setString(8, "1");
        preparedStatement.setString(9, "1");
        preparedStatement.setString(10, "1");
        preparedStatement.setBoolean(11, true);
        preparedStatement.executeUpdate();
        Statement statement2 = this.createStatement(1003, 1008);
        ResultSet resultSet = statement2.executeQuery("SELECT * FROM MultiTypeTable");
        resultSet.next();
        this.assertUpdateState(resultSet, "F01", 32768L, -1.0, 2, WONT_FIT);
        this.assertUpdateState(resultSet, "F01", -1L, 32768.0, 5, WONT_FIT);
        this.assertUpdateState(resultSet, "F01", 32768L, -1.0, 3, WONT_FIT);
        this.assertUpdateState(resultSet, "F01", -1L, 32768.0, 4, WONT_FIT);
        this.assertUpdateState(resultSet, "F01", bdMaxShortValue.add(BigDecimal.ONE), WONT_FIT);
        this.assertUpdateState(resultSet, "F01", -32769L, -1.0, 2, WONT_FIT);
        this.assertUpdateState(resultSet, "F01", -1L, -32769.0, 5, WONT_FIT);
        this.assertUpdateState(resultSet, "F01", -32769L, -1.0, 3, WONT_FIT);
        this.assertUpdateState(resultSet, "F01", -1L, -32769.0, 4, WONT_FIT);
        this.assertUpdateState(resultSet, "F01", bdMinShortValue.subtract(BigDecimal.ONE), WONT_FIT);
        this.assertUpdateState(resultSet, "F02", 0x80000000L, -1.0, 3, WONT_FIT);
        this.assertUpdateState(resultSet, "F02", -1L, 2.147483648E10, 4, WONT_FIT);
        this.assertUpdateState(resultSet, "F02", -1L, 2.147483647E10, 5, WONT_FIT);
        this.assertUpdateState(resultSet, "F02", bdMaxIntValue.add(BigDecimal.ONE), WONT_FIT);
        this.assertUpdateState(resultSet, "F02", -2147483649L, -1.0, 3, WONT_FIT);
        this.assertUpdateState(resultSet, "F02", -1L, -2.147483648E10, 4, WONT_FIT);
        this.assertUpdateState(resultSet, "F02", -1L, -2.147483648E10, 5, WONT_FIT);
        this.assertUpdateState(resultSet, "F02", bdMinIntValue.subtract(BigDecimal.ONE), WONT_FIT);
        this.assertUpdateState(resultSet, "F03", -1L, 9.223372036854776E19, 4, WONT_FIT);
        this.assertUpdateState(resultSet, "F03", -1L, 9.223372036854776E19, 5, WONT_FIT);
        this.assertUpdateState(resultSet, "F03", bdMaxLongValue.add(BigDecimal.ONE), WONT_FIT);
        this.assertUpdateState(resultSet, "F03", -1L, -9.223372036854776E19, 4, WONT_FIT);
        this.assertUpdateState(resultSet, "F03", -1L, -9.223372036854776E19, 5, WONT_FIT);
        this.assertUpdateState(resultSet, "F03", bdMinLongValue.subtract(BigDecimal.ONE), WONT_FIT);
        Float f = Float.valueOf(Float.MAX_VALUE);
        this.assertUpdateState(resultSet, "F04", -1L, f.doubleValue() * 10.0, 5, WONT_FIT);
        this.assertUpdateState(resultSet, "F04", -1L, Double.NEGATIVE_INFINITY, 4, WONT_FIT);
        this.assertUpdateState(resultSet, "F04", bdMaxFloatValue.multiply(BigDecimal.TEN), WONT_FIT);
        this.assertUpdateState(resultSet, "F04", -1L, -f.doubleValue() * 10.0, 5, WONT_FIT);
        this.assertUpdateState(resultSet, "F04", -1L, Double.POSITIVE_INFINITY, 4, WONT_FIT);
        this.assertUpdateState(resultSet, "F04", -1L, Double.NEGATIVE_INFINITY, 4, WONT_FIT);
        this.assertUpdateState(resultSet, "F04", bdMinFloatValue.multiply(BigDecimal.TEN), WONT_FIT);
        this.assertUpdateOK(resultSet, "F04", -1L, 1.4E-45f, 4);
        this.assertUpdateOK(resultSet, "F04", -1L, -1.4E-45f, 4);
        if (ParameterMappingTest.usingEmbedded()) {
            this.assertUpdateState(resultSet, "F04", -1L, Double.NaN, 4, WONT_FIT);
            this.assertUpdateState(resultSet, "F04", -1L, Double.MIN_VALUE, 5, WONT_FIT);
            this.assertUpdateState(resultSet, "F04", -1L, -4.9E-324, 5, WONT_FIT);
        }
        if (ParameterMappingTest.usingEmbedded()) {
            this.assertUpdateState(resultSet, "F04", bdSmallestPosDoubleValue, WONT_FIT);
            this.assertUpdateState(resultSet, "F04", bdSmallestNegDoubleValue, WONT_FIT);
        }
        String[] stringArray = new String[]{"F05", "F06"};
        for (int i = 0; i < 2; ++i) {
            this.assertUpdateState(resultSet, stringArray[i], -1L, Double.POSITIVE_INFINITY, 4, WONT_FIT);
            this.assertUpdateState(resultSet, stringArray[i], -1L, Double.POSITIVE_INFINITY, 5, WONT_FIT);
            this.assertUpdateState(resultSet, stringArray[i], bdMaxDoubleValue.multiply(BigDecimal.TEN), WONT_FIT);
            this.assertUpdateState(resultSet, stringArray[i], -1L, Double.NEGATIVE_INFINITY, 4, WONT_FIT);
            this.assertUpdateState(resultSet, stringArray[i], -1L, Double.NEGATIVE_INFINITY, 5, WONT_FIT);
            this.assertUpdateState(resultSet, stringArray[i], bdMinDoubleValue.multiply(BigDecimal.TEN), WONT_FIT);
            if (ParameterMappingTest.usingEmbedded()) {
                this.assertUpdateState(resultSet, stringArray[i], -1L, Double.NaN, 5, WONT_FIT);
            }
            if (ParameterMappingTest.usingEmbedded()) {
                this.assertUpdateState(resultSet, stringArray[i], bdSmallestPosDoubleValue.divide(BigDecimal.TEN), WONT_FIT);
                this.assertUpdateState(resultSet, stringArray[i], bdSmallestNegDoubleValue.divide(BigDecimal.TEN), WONT_FIT);
            }
            this.assertUpdateOK(resultSet, stringArray[i], -1L, Double.MIN_VALUE, 5);
            this.assertUpdateOK(resultSet, stringArray[i], -1L, -4.9E-324, 5);
        }
    }

    public void testDerby5536() throws SQLException {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{new BigDecimal(123456789012345678L), new BigDecimal(-12345678901234567L)};
        BigDecimal[] bigDecimalArray2 = new BigDecimal[]{new BigDecimal(1234567890123456789L), new BigDecimal(-123456789012345678L)};
        this.createStatement().executeUpdate("create table t5536(d1 decimal(19,1),                   d2 decimal(20,1),                   i int generated always as identity                         (start with 1, increment by 1))");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t5536 values (?, ?, default)");
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < bigDecimalArray.length; ++j) {
                preparedStatement.setBigDecimal(1, new BigDecimal(bigDecimalArray[j].toBigInteger(), i));
                preparedStatement.setBigDecimal(2, new BigDecimal(bigDecimalArray2[j].toBigInteger(), i));
                preparedStatement.execute();
            }
        }
        ResultSet resultSet = this.createStatement().executeQuery("select * from t5536 order by i");
        BigDecimal[] bigDecimalArray3 = new BigDecimal[]{BigDecimal.ONE, BigDecimal.TEN};
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < bigDecimalArray.length; ++j) {
                resultSet.next();
                ParameterMappingTest.assertEquals((String)"round-trip conversion error", (long)bigDecimalArray[j].divide(bigDecimalArray3[i], RoundingMode.DOWN).longValue(), (long)resultSet.getLong(1));
                ParameterMappingTest.assertEquals((String)"round-trip conversion error", (long)bigDecimalArray2[j].divide(bigDecimalArray3[i], RoundingMode.DOWN).longValue(), (long)resultSet.getLong(2));
            }
        }
        resultSet.close();
    }

    public void testDerby6902() throws SQLException {
        this.createStatement().executeUpdate("create table test6902 (  id bigint primary key,  big_number bigint not null,  small_number int not null)");
        PreparedStatement preparedStatement = this.prepareStatement("delete from test6902   where big_number < ? - small_number * 1000");
        try {
            preparedStatement.setLong(1, 1470362049757L);
            preparedStatement.executeUpdate();
            ParameterMappingTest.fail((String)"without cast, expected setLong to fail");
        }
        catch (SQLException sQLException) {
            ParameterMappingTest.assertSQLState(WONT_FIT, sQLException);
        }
        preparedStatement.setLong(1, 1479058636L);
        preparedStatement.executeUpdate();
        preparedStatement = this.prepareStatement("delete from test6902   where big_number <         ? - cast( small_number as bigint) * 1000");
        preparedStatement.setLong(1, 1470362049757L);
        preparedStatement.executeUpdate();
        preparedStatement = this.prepareStatement("delete from test6902   where big_number <         cast( ? as bigint) - small_number * 1000");
        preparedStatement.setLong(1, 1470362049757L);
        preparedStatement.executeUpdate();
        try {
            preparedStatement.setString(1, "abcde");
            preparedStatement.executeUpdate();
            ParameterMappingTest.fail((String)"expected setString to fail with non-numeric string");
        }
        catch (SQLException sQLException) {
            ParameterMappingTest.assertSQLState("22018", sQLException);
        }
        preparedStatement.setString(1, "1479058636");
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, "1470362049757");
        preparedStatement.executeUpdate();
        try {
            preparedStatement = this.prepareStatement("delete from test6902 where small_number * 1000 > ?");
            preparedStatement.setLong(1, 1470362049757L);
            preparedStatement.executeUpdate();
            ParameterMappingTest.fail((String)"Expected out of range exception.");
        }
        catch (SQLException sQLException) {
            ParameterMappingTest.assertSQLState(WONT_FIT, sQLException);
        }
        preparedStatement = this.prepareStatement("delete from test6902   where big_number + small_number * 1000 < ?");
        preparedStatement.setLong(1, 1470362049757L);
        preparedStatement.executeUpdate();
        preparedStatement = this.prepareStatement("delete from test6902   where big_number < ? - small_number * 1000");
        preparedStatement.setString(1, "1479058636");
        preparedStatement.executeUpdate();
        try {
            preparedStatement.setString(1, "1470362049757");
            preparedStatement.executeUpdate();
            ParameterMappingTest.fail((String)"expected setString to fail with numeric string > INT_MAX");
        }
        catch (SQLException sQLException) {
            ParameterMappingTest.assertSQLState("22018", sQLException);
        }
    }

    private void assertUpdateState(ResultSet resultSet, String string, BigDecimal bigDecimal, String string2) throws SQLException {
        try {
            resultSet.updateBigDecimal(string, bigDecimal);
            ParameterMappingTest.fail((String)"exception expected");
        }
        catch (SQLException sQLException) {
            ParameterMappingTest.println(sQLException.toString());
            ParameterMappingTest.assertSQLState(string2, sQLException);
        }
    }

    private void assertUpdateOK(ResultSet resultSet, String string, long l, double d, int n) throws SQLException {
        this.assertUpdateState(resultSet, string, l, d, n, null);
    }

    private void assertUpdateState(ResultSet resultSet, String string, long l, double d, int n, String string2) throws SQLException {
        try {
            switch (n) {
                case 0: {
                    resultSet.updateByte(string, (byte)l);
                    break;
                }
                case 1: {
                    resultSet.updateShort(string, (short)l);
                }
                case 2: {
                    resultSet.updateInt(string, (int)l);
                    break;
                }
                case 3: {
                    resultSet.updateLong(string, l);
                    break;
                }
                case 4: {
                    resultSet.updateFloat(string, (float)d);
                    break;
                }
                case 5: {
                    resultSet.updateDouble(string, d);
                    break;
                }
                default: {
                    ParameterMappingTest.fail((String)"wrong argument");
                }
            }
            if (string2 != null) {
                ParameterMappingTest.fail((String)"exception expected");
            }
        }
        catch (SQLException sQLException) {
            if (string2 == null) {
                throw sQLException;
            }
            ParameterMappingTest.println(sQLException.toString());
            ParameterMappingTest.assertSQLState(string2, sQLException);
        }
    }

    private void assertGetState(ResultSet resultSet, String string, int n, String string2) throws SQLException {
        try {
            switch (n) {
                case 0: {
                    resultSet.getByte(string);
                    break;
                }
                case 1: {
                    resultSet.getShort(string);
                    break;
                }
                case 2: {
                    resultSet.getInt(string);
                    break;
                }
                case 3: {
                    resultSet.getLong(string);
                    break;
                }
                case 4: {
                    resultSet.getFloat(string);
                    break;
                }
                case 5: {
                    resultSet.getDouble(string);
                    break;
                }
                default: {
                    ParameterMappingTest.fail((String)"wrong argument");
                }
            }
            ParameterMappingTest.fail((String)"exception expected");
        }
        catch (SQLException sQLException) {
            ParameterMappingTest.println(sQLException.toString());
            ParameterMappingTest.assertSQLState(string2, sQLException);
        }
    }

    private static boolean compareClobReader2CharArray(char[] cArray, Reader reader) throws Exception {
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        int n2 = 0;
        do {
            if ((n = reader.read(cArray2, n2, cArray.length - n2)) == -1) continue;
            n2 += n;
        } while (n != -1 && n2 < cArray.length);
        reader.close();
        return Arrays.equals(cArray, cArray2);
    }

    public void testUpdateSetCharacterStreamClob() throws Exception {
        this.helperTestClobOrVarchar(true);
    }

    public void testUpdateSetCharacterStreamVarchar() throws Exception {
        this.helperTestClobOrVarchar(false);
    }

    private void helperTestClobOrVarchar(boolean bl) throws Exception {
        Statement statement = this.createStatement();
        this.dropTable("TESTUPDATECHARSTREAM");
        statement.executeUpdate("CREATE TABLE TestUpdateCharStream (c1 VARCHAR(64) NOT NULL, c2 INTEGER, c3 CLOB, c4 VARCHAR(32000))");
        statement.executeUpdate("INSERT INTO TestUpdateCharStream (c1, c2) VALUES ('AAAAA', 1)");
        statement.executeUpdate("INSERT INTO TestUpdateCharStream (c1, c2) VALUES ('EEEEE', 1)");
        this.helperTestDerby6237(1, 1, bl);
        this.helperTestDerby6237(1, 2, bl);
        if (!bl) {
            this.helperTestDerby6237(2, 1, bl);
        }
        if (!bl) {
            this.helperTestDerby6237(2, 2, bl);
        }
        this.dropTable("TESTUPDATECHARSTREAM");
        statement.close();
    }

    private void helperTestDerby6237(int n, int n2, boolean bl) throws Exception {
        CharAlphabet charAlphabet = CharAlphabet.singleChar('a');
        PreparedStatement preparedStatement = this.prepareStatement("UPDATE TestUpdateCharStream SET " + (bl ? "c3" : "c4") + " = ?, c2 = c2 + 1 WHERE c1 IN (?, ?)");
        switch (n2) {
            case 1: {
                preparedStatement.setCharacterStream(1, (Reader)new LoopingAlphabetReader(50L, charAlphabet), 50);
                break;
            }
            case 2: {
                if (bl) {
                    preparedStatement.setCharacterStream(1, (Reader)new LoopingAlphabetReader(50000L, charAlphabet), 50000);
                    break;
                }
                preparedStatement.setCharacterStream(1, (Reader)new LoopingAlphabetReader(32000L, charAlphabet), 32000);
            }
        }
        preparedStatement.setCharacterStream(2, (Reader)new CharArrayReader("AAAAA".toCharArray()), 5);
        if (n == 1) {
            preparedStatement.setObject(3, (Object)"AAAAA", 12);
        } else {
            preparedStatement.setObject(3, (Object)"EEEEE", 12);
        }
        preparedStatement.execute();
        preparedStatement = this.prepareStatement("select " + (bl ? "c3 " : "c4 ") + "from TestUpdateCharStream WHERE c1 IN (?, ?)");
        preparedStatement.setCharacterStream(1, (Reader)new CharArrayReader("AAAAA".toCharArray()), 5);
        if (n == 1) {
            preparedStatement.setObject(2, (Object)"AAAAA", 12);
        } else {
            preparedStatement.setObject(2, (Object)"EEEEE", 12);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        char[] cArray = n2 == 1 ? new char[50] : (bl ? new char[50000] : new char[32000]);
        Arrays.fill(cArray, 'a');
        for (int i = 0; i < n; ++i) {
            resultSet.next();
            if (ParameterMappingTest.compareClobReader2CharArray(cArray, resultSet.getCharacterStream(1))) continue;
            System.out.println("FAIL: " + (bl ? "CLOB " : "VARCHAR ") + "data should have matched");
            resultSet.close();
            preparedStatement.close();
            return;
        }
        resultSet.close();
        preparedStatement.close();
    }
}

