/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public abstract class SURBaseTest
extends BaseJDBCTestCase {
    final int recordCount;
    static final String FOR_UPDATE_NOT_PERMITTED_SQL_STATE = "42Y90";
    static final String CURSOR_NOT_UPDATABLE_SQL_STATE = "42X23";
    static final String RESULTSET_NOT_UPDATABLE_SQL_STATE = "XJ083";
    static final String LOCK_TIMEOUT_SQL_STATE = "40XL1";
    static final String LOCK_TIMEOUT_EXPRESSION_SQL_STATE = "38000";
    static final String INVALID_CURSOR_STATE_NO_CURRENT_ROW = "24000";
    static final String CURSOR_OPERATION_CONFLICT = "01001";
    static final String QUERY_NOT_QUALIFIED_FOR_UPDATABLE_RESULTSET = "01J06";
    static final String CURSOR_NOT_POSITIONED_ON_INSERT_ROW = "XJ086";

    public SURBaseTest(String string) {
        super(string);
        this.recordCount = 10;
    }

    public SURBaseTest(String string, int n) {
        super(string);
        this.recordCount = n;
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(4);
    }

    protected void verifyTuple(ResultSet resultSet) throws SQLException {
        int n = resultSet.getInt(1);
        int n2 = resultSet.getInt(2);
        int n3 = resultSet.getInt(3);
        int n4 = n2 + n + 17;
        SURBaseTest.println("Reading tuple:(" + n + "," + n2 + "," + n3 + ",'" + resultSet.getString(4) + "', '" + resultSet.getString(5) + "'");
        SURBaseTest.assertEquals((String)"Expecting b==id+a+17", (int)n4, (int)n3);
    }

    protected void updateTuple(ResultSet resultSet) throws SQLException {
        int n = resultSet.getInt(1);
        int n2 = resultSet.getInt(2);
        int n3 = resultSet.getInt(3);
        int n4 = n2 * 2 + n + 37;
        int n5 = n4 + n + 17;
        SURBaseTest.println("Updating record (" + n + "," + n4 + "," + n5 + ")");
        resultSet.updateInt(2, n4);
        resultSet.updateInt(3, n5);
        resultSet.updateRow();
    }

    protected void updateTuplePositioned(ResultSet resultSet) throws SQLException {
        int n = resultSet.getInt(1);
        int n2 = resultSet.getInt(2);
        int n3 = resultSet.getInt(3);
        int n4 = n2 * 2 + n + 37;
        int n5 = n4 + n + 17;
        PreparedStatement preparedStatement = this.prepareStatement("update T1 set a=?,b=? where current of " + resultSet.getCursorName());
        preparedStatement.setInt(1, n4);
        preparedStatement.setInt(2, n5);
        SURBaseTest.assertEquals((String)"Expected one tuple to be updated", (int)1, (int)preparedStatement.executeUpdate());
        preparedStatement.close();
    }

    protected void scrollForward(ResultSet resultSet) throws SQLException {
        boolean bl = resultSet.getType() == 1003 || !resultSet.isBeforeFirst();
        int n = 0;
        while (resultSet.next()) {
            ++n;
            this.verifyTuple(resultSet);
        }
        if (!bl) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)n);
        }
    }

    protected void scrollBackward(ResultSet resultSet) throws SQLException {
        boolean bl = resultSet.getType() == 1003 || !resultSet.isAfterLast();
        int n = 0;
        while (resultSet.previous()) {
            ++n;
            this.verifyTuple(resultSet);
        }
        if (!bl) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)n);
        }
    }

    protected void scrollForwardAndUpdate(ResultSet resultSet) throws SQLException {
        boolean bl;
        int n = 0;
        boolean bl2 = bl = resultSet.getType() == 1003 || !resultSet.isBeforeFirst();
        while (resultSet.next()) {
            ++n;
            this.verifyTuple(resultSet);
            this.updateTuple(resultSet);
        }
        if (!bl) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)n);
        }
        SURBaseTest.assertNotNull((String)"rs.getCursorName()", (Object)resultSet.getCursorName());
    }

    protected void scrollForwardAndUpdatePositioned(ResultSet resultSet) throws SQLException {
        boolean bl;
        int n = 0;
        boolean bl2 = bl = resultSet.getType() == 1003 || !resultSet.isBeforeFirst();
        while (resultSet.next()) {
            ++n;
            this.verifyTuple(resultSet);
            this.updateTuplePositioned(resultSet);
        }
        if (!bl) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)n);
        }
        SURBaseTest.assertNotNull((String)"rs.getCursorName()", (Object)resultSet.getCursorName());
    }

    protected void scrollBackwardAndUpdate(ResultSet resultSet) throws SQLException {
        boolean bl;
        int n = 0;
        boolean bl2 = bl = resultSet.getType() == 1003 || !resultSet.isAfterLast();
        while (resultSet.previous()) {
            ++n;
            this.verifyTuple(resultSet);
            this.updateTuple(resultSet);
        }
        if (!bl) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)n);
        }
        SURBaseTest.assertNotNull((String)"rs.getCursorName()", (Object)resultSet.getCursorName());
    }

    protected void scrollBackwardAndUpdatePositioned(ResultSet resultSet) throws SQLException {
        boolean bl;
        int n = 0;
        boolean bl2 = bl = resultSet.getType() == 1003 || !resultSet.isAfterLast();
        while (resultSet.previous()) {
            ++n;
            this.verifyTuple(resultSet);
            this.updateTuplePositioned(resultSet);
        }
        if (!bl) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)n);
        }
        SURBaseTest.assertNotNull((String)"rs.getCursorName()", (Object)resultSet.getCursorName());
    }

    protected void assertFailOnUpdate(ResultSet resultSet) throws SQLException {
        boolean bl = false;
        try {
            this.updateTuple(resultSet);
        }
        catch (SQLException sQLException) {
            bl = true;
            SURBaseTest.assertEquals((String)"Unexpected SQL state", (String)RESULTSET_NOT_UPDATABLE_SQL_STATE, (String)sQLException.getSQLState());
        }
        SURBaseTest.assertTrue((String)"Expected cursor to fail on update, since it is read only", (boolean)bl);
    }

    protected void assertWarning(SQLWarning sQLWarning, String string) throws SQLException {
        if (sQLWarning != null || SURBaseTest.usingEmbedded()) {
            SURBaseTest.assertEquals((String)"Unexpected SQL state", (String)string, (String)sQLWarning.getSQLState());
        } else {
            SURBaseTest.println("Expected warning with SQLState = '" + string + "', however warning not propagated to client driver");
        }
    }
}

