/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementJdbc30Test
extends BaseJDBCTestCase {
    private static final String CLIENT_SUITE_NAME = "StatementJdbc30Test:client";

    public StatementJdbc30Test(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("StatementJdbc30Test");
        baseTestSuite.addTest(StatementJdbc30Test.baseSuite("StatementJdbc30Test:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(StatementJdbc30Test.baseSuite(CLIENT_SUITE_NAME)));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(StatementJdbc30Test.class);
        if (string.equals(CLIENT_SUITE_NAME)) {
            baseTestSuite.addTest((Test)new StatementJdbc30Test("xtestMultiExecWithQueryTimeout"));
            baseTestSuite.addTest((Test)new StatementJdbc30Test("xtestMaxOpenStatementsWithQueryTimeout"));
        }
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table tab1 (i int, s smallint, r real)");
                statement.executeUpdate("insert into tab1 values(1, 2, 3.1)");
            }
        };
    }

    public void testReadingData() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from tab1");
        StatementJdbc30Test.assertTrue((boolean)resultSet.next());
        resultSet.close();
    }

    public void testGetMoreResults() throws SQLException {
        Statement statement = this.createStatement();
        StatementJdbc30Test.assertFalse((boolean)statement.getMoreResults(1));
    }

    public void testInsertNoGenKeys() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into tab1 values(2, 3, 4.1)", 2);
        StatementJdbc30Test.assertNull((String)"Expected NULL ResultSet after stmt.execute()", (Object)statement.getGeneratedKeys());
    }

    public void testExecuteUpdateNoAutoGenColumnIndex() throws SQLException {
        Statement statement = this.createStatement();
        int[] nArray = new int[]{1, 2};
        try {
            statement.executeUpdate("insert into tab1 values(2, 3, 4.1)", nArray);
            StatementJdbc30Test.fail((String)"FAIL -- executeUpdate should have failed...");
        }
        catch (SQLException sQLException) {
            this.assertFailedExecuteUpdateForColumnIndex(sQLException);
        }
    }

    public void testExecuteUpdateNoAutoGenColumnName() throws SQLException {
        Statement statement = this.createStatement();
        String[] stringArray = new String[]{"I", "S"};
        try {
            statement.executeUpdate("insert into tab1 values(2, 3, 4.1)", stringArray);
            StatementJdbc30Test.fail((String)"FAIL -- executeUpdate should have failed...");
        }
        catch (SQLException sQLException) {
            this.assertFailedExecuteUpdateForColumnName(sQLException);
        }
    }

    public void testSelectNoGenKeys() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("select * from tab1", 2);
        StatementJdbc30Test.assertNull((String)"Expected NULL ResultSet after stmt.execute()", (Object)statement.getGeneratedKeys());
    }

    public void testExecuteNoAutoGenColumnIndex() throws SQLException {
        Statement statement = this.createStatement();
        int[] nArray = new int[]{1, 2};
        try {
            statement.execute("insert into tab1 values(2, 3, 4.1)", nArray);
            StatementJdbc30Test.fail((String)"FAIL -- executeUpdate should have failed...");
        }
        catch (SQLException sQLException) {
            this.assertFailedExecuteUpdateForColumnIndex(sQLException);
        }
    }

    private void assertFailedExecuteUpdateForColumnIndex(SQLException sQLException) {
        if (StatementJdbc30Test.usingDerbyNetClient()) {
            StatementJdbc30Test.assertSQLState("X0X0D", sQLException);
        } else {
            StatementJdbc30Test.assertSQLState("X0X0E", sQLException);
        }
    }

    private void assertFailedExecuteUpdateForColumnName(SQLException sQLException) {
        if (StatementJdbc30Test.usingDerbyNetClient()) {
            StatementJdbc30Test.assertSQLState("X0X0D", sQLException);
        } else {
            StatementJdbc30Test.assertSQLState("X0X0F", sQLException);
        }
    }

    public void testExecuteNoAutoGenColumnName() throws SQLException {
        Statement statement = this.createStatement();
        String[] stringArray = new String[]{"I", "S"};
        try {
            statement.executeUpdate("insert into tab1 values(2, 3, 4.1)", stringArray);
            StatementJdbc30Test.fail((String)"FAIL -- executeUpdate should have failed...");
        }
        catch (SQLException sQLException) {
            this.assertFailedExecuteUpdateForColumnName(sQLException);
        }
    }

    public void xtestMultiExecWithQueryTimeout() throws SQLException {
        Statement statement = this.createStatement();
        statement.setQueryTimeout(10);
        for (int i = 0; i < 33000; ++i) {
            ResultSet resultSet = statement.executeQuery("VALUES(1)");
            resultSet.close();
        }
    }

    public void xtestMaxOpenStatementsWithQueryTimeout() throws SQLException {
        int n;
        this.setAutoCommit(false);
        Statement[] statementArray = new Statement[16500];
        try {
            for (n = 0; n < 16500; ++n) {
                statementArray[n] = this.createStatement();
                statementArray[n].setQueryTimeout(10);
                statementArray[n].executeQuery("VALUES(1)");
            }
        }
        catch (SQLException sQLException) {
            StatementJdbc30Test.assertSQLState("XJ200", sQLException);
            StatementJdbc30Test.assertTrue((String)("16383 >= (i=" + n + ")"), (16383 >= n ? 1 : 0) != 0);
        }
    }

    public void testGetResultSetHoldability() throws SQLException {
        Statement statement = this.createStatement();
        StatementJdbc30Test.assertEquals((int)1, (int)statement.getResultSetHoldability());
    }

    public void testGetGenerateKeys() throws SQLException {
        Statement statement = this.createStatement();
        StatementJdbc30Test.assertNull((Object)statement.getGeneratedKeys());
    }
}

