/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbc4.BlobClobTestSetup;
import org.apache.derbyTesting.functionTests.tests.jdbc4.ExemptClobMD;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobTest
extends BaseJDBCTestCase {
    private Clob clob = null;
    private static final ExemptClobMD[] emd = new ExemptClobMD[]{new ExemptClobMD("getCharacterStream", new Class[]{Long.TYPE, Long.TYPE}, true, true), new ExemptClobMD("setString", new Class[]{Long.TYPE, String.class}, false, true), new ExemptClobMD("truncate", new Class[]{Long.TYPE}, false, true), new ExemptClobMD("free", null, true, true)};
    private HashMap<Method, ExemptClobMD> excludedMethodSet = new HashMap();
    private static final String LOCK_TIMEOUT = "40XL1";

    public ClobTest(String string) {
        super(string);
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.clob != null) {
            this.clob.free();
            this.clob = null;
        }
        this.excludedMethodSet = null;
        super.tearDown();
    }

    void buildHashSet() {
        Class<Clob> clazz = Clob.class;
        for (int i = 0; i < emd.length; ++i) {
            try {
                Method method = clazz.getMethod(emd[i].getMethodName(), emd[i].getParams());
                this.excludedMethodSet.put(method, emd[i]);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ClobTest.fail((String)"The method could not be found in the interface");
            }
        }
    }

    public void testFreeAfterImplicitFree() throws SQLException {
        Connection connection = this.getConnection();
        this.clob = BlobClobTestSetup.getSampleClob(connection);
        connection.commit();
        this.clob.free();
    }

    public void testFreeandMethodsAfterCallingFree() throws IllegalAccessException, InvocationTargetException, SQLException {
        this.clob = BlobClobTestSetup.getSampleClob(this.getConnection());
        this.buildHashSet();
        InputStream inputStream = this.clob.getAsciiStream();
        Reader reader = this.clob.getCharacterStream();
        this.clob.free();
        this.clob.free();
        this.buildMethodList(this.clob);
    }

    void buildMethodList(Object object) throws IllegalAccessException, InvocationTargetException {
        int n;
        boolean bl = true;
        Vector<Method> vector = new Vector<Method>();
        Class<Clob> clazz = Clob.class;
        Method[] methodArray = clazz.getMethods();
        for (n = 0; n < methodArray.length; ++n) {
            if (this.checkIfExempted(methodArray[n])) continue;
            bl = this.checkIfMethodThrowsSQLException(object, methodArray[n]);
            if (!bl) {
                vector.add(methodArray[n]);
            }
            bl = true;
        }
        if (!vector.isEmpty()) {
            n = 0;
            Object object2 = "The Following methods don't throw required exception - ";
            for (Method method : vector) {
                if (++n == vector.size() && n != 1) {
                    object2 = (String)object2 + " & ";
                } else if (n != 1) {
                    object2 = (String)object2 + " , ";
                }
                object2 = (String)object2 + method.getName();
            }
            ClobTest.fail((String)object2);
        }
    }

    boolean checkIfExempted(Method method) {
        ExemptClobMD exemptClobMD = this.excludedMethodSet.get(method);
        boolean bl = false;
        if (exemptClobMD != null) {
            if (ClobTest.usingDerbyNetClient()) {
                bl = exemptClobMD.getIfClientFramework();
            } else if (ClobTest.usingEmbedded()) {
                bl = exemptClobMD.getIfEmbeddedFramework();
            } else {
                ClobTest.fail((String)"Unknown test environment/framework");
            }
        }
        return bl;
    }

    boolean checkIfMethodThrowsSQLException(Object object, Method method) throws IllegalAccessException, InvocationTargetException {
        try {
            method.invoke(object, this.getNullValues(method.getParameterTypes()));
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof SQLException) {
                return ((SQLException)throwable).getSQLState().equals("XJ215");
            }
            throw invocationTargetException;
        }
        return false;
    }

    Object[] getNullValues(Class<?>[] classArray) {
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = this.getNullValueForType(classArray[i]);
        }
        return objectArray;
    }

    Object getNullValueForType(Class clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        ClobTest.fail((String)("Don't know how to handle type " + String.valueOf(clazz)));
        return null;
    }

    public void testGetCharacterStreamLong() throws Exception {
        String string = "This is a test String. This is a test String";
        StringReader stringReader = new StringReader(string);
        PreparedStatement preparedStatement = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int n = BlobClobTestSetup.getID();
        preparedStatement.setInt(1, n);
        preparedStatement.setCharacterStream(2, stringReader);
        preparedStatement.execute();
        preparedStatement.close();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select CLOBDATA from BLOBCLOB where ID=" + n);
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        Reader reader = clob.getCharacterStream(2L, 5L);
        String string2 = string.substring(1, 6);
        StringReader stringReader2 = new StringReader(string2);
        ClobTest.assertEquals(stringReader2, reader);
        resultSet.close();
        statement.close();
    }

    public void testGetCharacterStreamLongLastCharLatin() throws IOException, SQLException {
        CharAlphabet charAlphabet = CharAlphabet.modernLatinLowercase();
        int n = 5000;
        PreparedStatement preparedStatement = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int n2 = BlobClobTestSetup.getID();
        preparedStatement.setInt(1, n2);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)n, charAlphabet), n);
        preparedStatement.execute();
        preparedStatement.close();
        this.getCharacterStreamLongLastChar(n2, n, charAlphabet);
    }

    public void testGetCharacterStreamLongLastCharCJK() throws IOException, SQLException {
        CharAlphabet charAlphabet = CharAlphabet.cjkSubset();
        int n = 9001;
        PreparedStatement preparedStatement = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int n2 = BlobClobTestSetup.getID();
        preparedStatement.setInt(1, n2);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)n, charAlphabet), n);
        preparedStatement.execute();
        preparedStatement.close();
        this.getCharacterStreamLongLastChar(n2, n, charAlphabet);
    }

    private void getCharacterStreamLongLastChar(int n, int n2, CharAlphabet charAlphabet) throws IOException, SQLException {
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader((long)n2, charAlphabet);
        loopingAlphabetReader.skip(n2 - 1);
        char c = (char)((Reader)loopingAlphabetReader).read();
        ClobTest.assertTrue((((Reader)loopingAlphabetReader).read() == -1 ? 1 : 0) != 0);
        PreparedStatement preparedStatement = this.prepareStatement("select CLOBDATA from BLOBCLOB where ID=?");
        preparedStatement.setInt(1, n);
        int n3 = n2;
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Reader reader = resultSet.getClob(1).getCharacterStream(n2 - n3 + 1, n3);
        char c2 = ClobTest.getLastCharInStream(reader, n3);
        ClobTest.assertEquals((char)c, (char)c2);
        reader.close();
        resultSet.close();
        n3 = n2 / 4;
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        reader = resultSet.getClob(1).getCharacterStream(n2 - n3 + 1, n3);
        c2 = ClobTest.getLastCharInStream(reader, n3);
        ClobTest.assertEquals((char)c, (char)c2);
        reader.close();
        resultSet.close();
        n3 = 1;
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        reader = resultSet.getClob(1).getCharacterStream(n2 - n3 + 1, n3);
        c2 = ClobTest.getLastCharInStream(reader, n3);
        ClobTest.assertEquals((char)c, (char)c2);
        reader.close();
        resultSet.close();
    }

    public void testGetCharacterStreamLongOnLargeClob() throws Exception {
        int n;
        this.getConnection().setAutoCommit(false);
        StringBuilder stringBuilder = new StringBuilder(33000);
        for (n = 0; n < 33000; n += 10) {
            stringBuilder.append("1234567890");
        }
        n = BlobClobTestSetup.getID();
        PreparedStatement preparedStatement = this.prepareStatement("insert into blobclob(id, clobdata) values (?,cast(? as clob))");
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, stringBuilder.toString());
        preparedStatement.executeUpdate();
        preparedStatement.close();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select clobdata from blobclob where id = " + n);
        ClobTest.assertTrue((boolean)resultSet.next());
        Clob clob = resultSet.getClob(1);
        BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream(4L, 3L));
        ClobTest.assertEquals((String)"456", (String)bufferedReader.readLine());
        bufferedReader.close();
        clob.free();
        resultSet.close();
        statement.close();
        this.rollback();
    }

    public void testGetCharacterStreamLongExceptionConditions() throws SQLException {
        String string = "This is a test String. This is a test String";
        StringReader stringReader = new StringReader(string);
        PreparedStatement preparedStatement = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int n = BlobClobTestSetup.getID();
        preparedStatement.setInt(1, n);
        preparedStatement.setCharacterStream(2, stringReader);
        preparedStatement.execute();
        preparedStatement.close();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select CLOBDATA from BLOBCLOB where ID=" + n);
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        try {
            clob.getCharacterStream(-2L, 5L);
            ClobTest.fail((String)"FAIL: Expected SQLException for pos being negative not thrown");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ070", sQLException);
        }
        try {
            clob.getCharacterStream(clob.length() + 1L, 5L);
            ClobTest.fail((String)"FAIL: Expected SQLException for position being greater than length of LOB not thrown");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ087", sQLException);
        }
        try {
            clob.getCharacterStream(2L, -5L);
            ClobTest.fail((String)"Fail: expected exception for the length being negative not thrown");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ071", sQLException);
        }
        try {
            clob.getCharacterStream(clob.length() - 4L, 10L);
            ClobTest.fail((String)"Fail: expected exception for the sum of position and length being greater than the LOB size not thrown");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ087", sQLException);
        }
    }

    public void testGetAsciiStreamCreateClob() throws Exception {
        String string = "Hi I am the insert String";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("US-ASCII"));
        Clob clob = this.getConnection().createClob();
        InputStream inputStream = clob.getAsciiStream();
        clob.setString(1L, string);
        ClobTest.assertEquals(byteArrayInputStream, inputStream);
    }

    public void testGetCharacterStreamCreateClob() throws Exception {
        String string = "Hi I am the insert String";
        StringReader stringReader = new StringReader(string);
        Clob clob = this.getConnection().createClob();
        Reader reader = clob.getCharacterStream();
        clob.setString(1L, string);
        ClobTest.assertEquals(stringReader, reader);
    }

    public void testGetAsciiStreamClobUpdates() throws Exception {
        String string = "Hi I am the insert string";
        byte[] byArray = string.getBytes();
        String string2 = "Hi I am the update string";
        Clob clob = this.getConnection().createClob();
        InputStream inputStream = clob.getAsciiStream();
        OutputStream outputStream = clob.setAsciiStream(1L);
        outputStream.write(byArray);
        clob.setString(byArray.length + 1, string2);
        InputStream inputStream2 = clob.getAsciiStream();
        ClobTest.assertEquals(inputStream, inputStream2);
    }

    public void testGetCharacterStreamClobUpdates() throws Exception {
        String string = "Hi I am the insert string";
        String string2 = "Hi I am the update string";
        Clob clob = this.getConnection().createClob();
        Reader reader = clob.getCharacterStream();
        Writer writer = clob.setCharacterStream(1L);
        char[] cArray = new char[string.length()];
        string2.getChars(0, string.length(), cArray, 0);
        writer.write(cArray);
        clob.setString(string.length() + 1, string2);
        Reader reader2 = clob.getCharacterStream();
        ClobTest.assertEquals(reader, reader2);
    }

    public void testLockingAfterFree() throws SQLException {
        int n = this.initializeLongClob();
        this.executeParallelUpdate(n, true);
        this.clob.free();
        this.executeParallelUpdate(n, false);
        this.commit();
    }

    public void testLockingAfterFreeWithRR() throws SQLException {
        this.getConnection().setTransactionIsolation(4);
        int n = this.initializeLongClob();
        this.executeParallelUpdate(n, true);
        this.clob.free();
        this.executeParallelUpdate(n, true);
        this.commit();
        this.executeParallelUpdate(n, false);
    }

    public void testLockingAfterFreeWithDirtyReads() throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        int n = this.initializeLongClob();
        this.executeParallelUpdate(n, true);
        this.clob.free();
        this.executeParallelUpdate(n, false);
        this.commit();
    }

    public void testInsertAndFetchZeroLength() throws IOException, SQLException {
        this.insertAndFetchTest(0L);
    }

    public void testInsertAndFetchVerySmall() throws IOException, SQLException {
        this.insertAndFetchTest(7L);
    }

    public void testInsertAndFetchSmall() throws IOException, SQLException {
        this.insertAndFetchTest(1587L);
    }

    public void testInsertAndFetchMedium() throws IOException, SQLException {
        this.insertAndFetchTest(32000L);
    }

    public void testInsertAndFetchMediumPlus() throws IOException, SQLException {
        this.insertAndFetchTest(64000L);
    }

    public void testInsertAndFetchLarge() throws IOException, SQLException {
        this.insertAndFetchTest(128022L);
    }

    public void testInsertAndFetchLarger() throws IOException, SQLException {
        this.insertAndFetchTest(0x300000L);
    }

    private void insertAndFetchTest(long l) throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int n = BlobClobTestSetup.getID();
        preparedStatement.setInt(1, n);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(l), l);
        long l2 = System.currentTimeMillis();
        preparedStatement.execute();
        ClobTest.println("Inserted " + l + " chars (length specified) in " + (System.currentTimeMillis() - l2) + " ms");
        Statement statement = this.createStatement();
        l2 = System.currentTimeMillis();
        ResultSet resultSet = statement.executeQuery("select CLOBDATA from BLOBCLOB where id = " + n);
        ClobTest.assertTrue((String)"Clob not inserted", (boolean)resultSet.next());
        Clob clob = resultSet.getClob(1);
        ClobTest.assertEquals((String)"Invalid length", (long)l, (long)clob.length());
        ClobTest.println("Fetched length (" + l + ") in " + (System.currentTimeMillis() - l2) + " ms");
        resultSet.close();
        n = BlobClobTestSetup.getID();
        preparedStatement.setInt(1, n);
        preparedStatement.setCharacterStream(2, new LoopingAlphabetReader(l));
        l2 = System.currentTimeMillis();
        preparedStatement.executeUpdate();
        ClobTest.println("Inserted " + l + " chars (length unspecified) in " + (System.currentTimeMillis() - l2) + " ms");
        resultSet = statement.executeQuery("select CLOBDATA from BLOBCLOB where id = " + n);
        ClobTest.assertTrue((String)"Clob not inserted", (boolean)resultSet.next());
        clob = resultSet.getClob(1);
        ClobTest.assertEquals((String)"Invalid length", (long)l, (long)clob.length());
        ClobTest.println("Fetched length (" + l + ") in " + (System.currentTimeMillis() - l2) + " ms");
        resultSet.close();
        this.rollback();
    }

    private int initializeLongClob() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int n = BlobClobTestSetup.getID();
        preparedStatement.setInt(1, n);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(40000L), 40000);
        preparedStatement.execute();
        preparedStatement.close();
        this.commit();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select CLOBDATA from BLOBCLOB where ID=" + n);
        resultSet.next();
        this.clob = resultSet.getClob(1);
        resultSet.close();
        statement.close();
        return n;
    }

    private void executeParallelUpdate(int n, boolean bl) throws SQLException {
        Connection connection = this.openDefaultConnection();
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("update BLOBCLOB set BLOBDATA = cast(X'FFFFFF' as blob) where ID=" + n);
            statement.close();
            connection.commit();
            connection.close();
            if (bl) {
                ClobTest.fail((String)"FAIL - should have gotten lock timeout");
            }
        }
        catch (SQLException sQLException) {
            statement.close();
            connection.rollback();
            connection.close();
            if (bl) {
                ClobTest.assertSQLState(LOCK_TIMEOUT, sQLException);
            }
            throw sQLException;
        }
    }

    public static char getLastCharInStream(Reader reader, int n) throws IOException {
        int n2 = 0;
        char[] cArray = new char[256];
        ClobTest.assertTrue((cArray.length > 0 ? 1 : 0) != 0);
        while (true) {
            int n3;
            if ((n3 = reader.read(cArray, 0, cArray.length)) < 0) {
                ClobTest.assertEquals((String)"Invalid return value from stream", (int)-1, (int)n3);
                ClobTest.fail((String)("Reached EOF prematurely, expected " + n + ", got " + n2));
            } else if (n3 == 0) {
                ClobTest.fail((String)("Stream breaks contract, read zero chars: " + String.valueOf(reader)));
            }
            if ((n2 += n3) == n) {
                return cArray[n3 - 1];
            }
            if (n2 <= n) continue;
            ClobTest.fail((String)("Too many chars in stream, expected " + n + "have " + n2 + "(EOF not reached/confirmed)"));
        }
    }

    public static Test suite() {
        return new BlobClobTestSetup(DatabasePropertyTestSetup.setLockTimeouts(TestConfiguration.defaultSuite(ClobTest.class, false), 2, 4));
    }
}

