/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class CheckConstraintTest
extends BaseJDBCTestCase {
    private static final String IMPORT_FILE_NAME = "t_bi_1.dat";
    static boolean funcWasCalled;

    public CheckConstraintTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("checkConstraint Test");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(CheckConstraintTest.class));
        return new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/tests/lang/t_bi_1.dat"});
    }

    public void testNotAllowedInCheckConstraints() throws Exception {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        CheckConstraintTest.assertStatementError("42Y39", statement, "create table neg1(c1 int check(?))");
        CheckConstraintTest.assertStatementError("42Y39", statement, " create table neg1(c1 int check(c1 in (select c1 from neg1)))");
        CheckConstraintTest.assertStatementError("42Y39", statement, " create table neg1(c1 int check(CURRENT_DATE = CURRENT_DATE))");
        CheckConstraintTest.assertStatementError("42Y39", statement, " create table neg1(c1 int check(CURRENT_TIME = CURRENT_TIME))");
        CheckConstraintTest.assertStatementError("42Y39", statement, " create table neg1(c1 int check(CURRENT_TIMESTAMP = CURRENT_TIMESTAMP))");
        CheckConstraintTest.assertStatementError("42X19", statement, "create table neg1(c1 int check(c1))");
        CheckConstraintTest.assertStatementError("42X19", statement, " create table neg1(c1 int check(1))");
        CheckConstraintTest.assertStatementError("42X19", statement, " create table neg1(c1 int check(c1+c1))");
        CheckConstraintTest.assertStatementError("42X04", statement, "create table neg1(c1 int check((c2 = 1)))");
        statement.executeUpdate("create table t1(c1 int constraint asdf check(c1 = 1))");
        CheckConstraintTest.assertStatementError("42Y48", statement, " select * from t1 --derby-properties constraint = asdf ");
        this.rollback();
        CheckConstraintTest.assertStatementError("42621", statement, "create table neg1(c1 int check(c2 = 1), c2 int)");
        CheckConstraintTest.assertStatementError("42621", statement, " create table neg2(c1 int constraint asdf check(c2 = 1), c2 int)");
        this.rollback();
    }

    public void testCheckConstraints() throws SQLException {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table pos1(c1 int check(c1 > 0), constraint asdf check(c1 < 10))");
        CheckConstraintTest.assertStatementError("23513", statement, "insert into pos1 values 0");
        statement.executeUpdate(" insert into pos1 values 1");
        statement.executeUpdate(" insert into pos1 values 9");
        CheckConstraintTest.assertStatementError("23513", statement, " insert into pos1 values 10");
        ResultSet resultSet = statement.executeQuery("select * from pos1");
        String[] stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1"}, {"9"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        CheckConstraintTest.assertStatementError("23513", statement, "update pos1 set c1 = c1 + 1");
        resultSet = statement.executeQuery(" select * from pos1");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"9"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        CheckConstraintTest.assertStatementError("23513", statement, " update pos1 set c1 = c1 - 1");
        resultSet = statement.executeQuery(" select * from pos1");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"9"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.rollback();
        statement.executeUpdate("create table negcks(c1 int constraint ck1st check(c1 > 4), c2 int constraint ck2nd check(c2 > 2), c3 int, constraint ckLast check(c2 > c1))");
        CheckConstraintTest.assertStatementError("23513", statement, "insert into negcks values (1, 3, 3)");
        CheckConstraintTest.assertStatementError("23513", statement, "insert into negcks values (5, 1, 3)");
        CheckConstraintTest.assertStatementError("23513", statement, "insert into negcks values (2, 3, 3)");
        this.rollback();
        statement.executeUpdate("create table pos1(c1 int, c2 int, constraint ck1 check (c1 < c2))");
        statement.executeUpdate(" insert into pos1 values (1, 2), (2, 3), (3, 4)");
        this.commit();
        statement.executeUpdate("insert into pos1 select * from pos1");
        resultSet = statement.executeQuery(" select count(*) from pos1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        CheckConstraintTest.assertUpdateCount(statement, 6, " update pos1 set c2 = (select max(c1) from pos1), c1 = (select min(c2) from pos1)");
        resultSet = statement.executeQuery(" select * from pos1");
        stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2", "3"}, {"2", "3"}, {"2", "3"}, {"2", "3"}, {"2", "3"}, {"2", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.rollback();
        CheckConstraintTest.assertStatementError("23513", statement, "insert into pos1 select c2, c1 from pos1");
        resultSet = statement.executeQuery(" select count(*) from pos1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        CheckConstraintTest.assertStatementError("23513", statement, " update pos1 set c2 = (select min(c1) from pos1), c1 = (select max(c2) from pos1)");
        resultSet = statement.executeQuery(" select * from pos1");
        stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2"}, {"2", "3"}, {"3", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" drop table pos1");
        this.commit();
        statement.executeUpdate("create table t1(c1 int, c2 int, constraint ck1 check(c1 = c2))");
        CheckConstraintTest.assertStatementError("23513", statement, " insert into t1 values (1, 1), (2, 1)");
        resultSet = statement.executeQuery(" select * from t1");
        stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("insert into t1 values (1.0, 1)");
        CheckConstraintTest.assertStatementError("23513", statement, " insert into t1 values (2.0, 1)");
        resultSet = statement.executeQuery(" select * from t1");
        stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        CheckConstraintTest.assertUpdateCount(statement, 1, " update t1 set c2 = 1.0");
        CheckConstraintTest.assertStatementError("23513", statement, " update t1 set c2 = 2.0");
        resultSet = statement.executeQuery(" select * from t1");
        stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        CheckConstraintTest.assertUpdateCount(statement, 1, " update t1 set c1 = 3.0, c2 = 3.0");
        resultSet = statement.executeQuery(" select * from t1");
        stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.rollback();
    }

    public void testPositionalUpdate() throws SQLException {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table t1(c1 int, c2 int, constraint ck1 check(c1 = c2), constraint ck2 check(c2=c1))");
        statement.executeUpdate(" insert into t1 values (1, 1), (2, 2), (3, 3), (4, 4)");
        statement.executeUpdate(" create index i1 on t1(c1)");
        Statement statement2 = this.createStatement();
        statement2.setCursorName("c1");
        ResultSet resultSet = statement2.executeQuery("select * from t1 where c2=2 for update of C1");
        resultSet.next();
        this.setAutoCommit(false);
        CheckConstraintTest.assertUpdateCount(statement, 1, "update t1 set c1 = c1 where current of \"c1\"");
        CheckConstraintTest.assertStatementError("23513", statement, "update t1 set c1 = c1 + 1 where current of \"c1\"");
        statement2.close();
        resultSet.close();
        Statement statement3 = this.createStatement();
        statement3.setCursorName("c2");
        ResultSet resultSet2 = statement3.executeQuery("select * from t1 where c1 = 2 for update of c2");
        resultSet2.next();
        this.setAutoCommit(false);
        CheckConstraintTest.assertUpdateCount(statement, 1, "update t1 set c2 = c2 where current of \"c2\"");
        CheckConstraintTest.assertStatementError("23513", statement, "update t1 set c2 = c2 + 1 where current of \"c2\"");
        statement3.close();
        resultSet2.close();
        Statement statement4 = this.createStatement();
        statement4.setCursorName("c3");
        ResultSet resultSet3 = statement4.executeQuery("select * from t1 where c1 = 2 for update of c1, c2");
        resultSet3.next();
        this.setAutoCommit(false);
        CheckConstraintTest.assertUpdateCount(statement, 1, "update t1 set c2 = c1, c1 = c2 where current of \"c3\"");
        CheckConstraintTest.assertStatementError("23513", statement, "update t1 set c2 = c2 + 1, c1 = c1 + 3 where current of \"c3\"");
        CheckConstraintTest.assertUpdateCount(statement, 1, "update t1 set c2 = c1 + 3, c1 = c2 + 3 where current of \"c3\"");
        statement4.close();
        resultSet3.close();
        ResultSet resultSet4 = statement.executeQuery("select * from t1");
        String[] stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet4, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1"}, {"5", "5"}, {"3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(resultSet4, objectArray, true);
        this.rollback();
        statement.executeUpdate("create table t1(c1 int check((c1 + c1) = (c1 * c1) or (c1 + c1)/2 = (c1 * c1)), c2 int)");
        statement.executeUpdate("insert into t1 values (1, 9), (2, 10)");
        CheckConstraintTest.assertUpdateCount(statement, 2, "update t1 set c2 = c2 * c2");
        CheckConstraintTest.assertUpdateCount(statement, 1, " update t1 set c1 = 2 where c1 = 1");
        CheckConstraintTest.assertUpdateCount(statement, 2, " update t1 set c1 = 1 where c1 = 2");
        CheckConstraintTest.assertStatementError("23513", statement, "update t1 set c1 = c2");
        resultSet4 = statement.executeQuery(" select * from t1");
        stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet4, stringArray);
        objectArray = new String[][]{{"1", "81"}, {"1", "100"}};
        JDBC.assertFullResultSet(resultSet4, objectArray, true);
        this.rollback();
    }

    public void testBuiltInFunctions() throws SQLException {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table charTab (c1 char(4) check(CHAR(c1) = c1))");
        statement.executeUpdate(" insert into charTab values 'asdf'");
        statement.executeUpdate(" insert into charTab values 'fdsa'");
        statement.executeUpdate("create table intTab (c1 int check(INT(1) = c1))");
        statement.executeUpdate(" insert into intTab values 1");
        CheckConstraintTest.assertStatementError("23513", statement, "insert into intTab values 2");
        statement.executeUpdate(" create table maxIntTab (c1 int check(INT(2147483647) > c1))");
        statement.executeUpdate(" insert into maxIntTab values 1");
        CheckConstraintTest.assertStatementError("23513", statement, "insert into maxIntTab values 2147483647");
        this.rollback();
        statement.executeUpdate("create table t1(c1 int not null constraint asdf primary key)");
        statement.executeUpdate(" insert into t1 values 1, 2, 3, 4, 5");
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values 1");
        PreparedStatement preparedStatement2 = this.prepareStatement("update t1 set c1 = 3 where c1 = 4");
        PreparedStatement preparedStatement3 = this.prepareStatement("select * from t1");
        CheckConstraintTest.assertStatementError("23505", preparedStatement);
        CheckConstraintTest.assertStatementError("23505", preparedStatement2);
        ResultSet resultSet = preparedStatement3.executeQuery();
        String[] stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" alter table t1 drop constraint asdf");
        this.rollback();
        CheckConstraintTest.assertStatementError("23505", preparedStatement);
        CheckConstraintTest.assertStatementError("23505", preparedStatement2);
        resultSet = preparedStatement3.executeQuery();
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" drop table t1");
        statement.executeUpdate("create table t1(c1 int constraint asdf check(c1 = 1))");
        PreparedStatement preparedStatement4 = this.prepareStatement("insert into t1 values (?)");
        resultSet = statement.executeQuery("values (1)");
        resultSet.next();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            preparedStatement4.setObject(i, resultSet.getObject(i));
        }
        CheckConstraintTest.assertUpdateCount(preparedStatement4, 1);
        statement.executeUpdate("drop table t1");
        statement.executeUpdate(" create table t1(active_flag char(2) check(active_flag IN ('Y', 'N')), araccount_active_flag char(2) check(araccount_active_flag IN ('Y', 'N')), automatic_refill_flag char(2) check(automatic_refill_flag IN ('Y', 'N')), call_when_ready_flag char(2) check(call_when_ready_flag IN ('Y', 'N')), compliance_flag char(2) check(compliance_flag IN ('Y', 'N')), delivery_flag char(2) check(delivery_flag IN ('Y', 'N')), double_count_flag char(2) check(double_count_flag IN ('Y', 'N')), gender_ind char(2) check(gender_ind IN ('M', 'F', 'U')), geriatric_flag char(2) check(geriatric_flag IN ('Y', 'N')), refuse_inquiry_flag char(2) check(refuse_inquiry_flag IN ('Y', 'N')), animal_flag char(2) check(animal_flag IN ('Y', 'N')), terminal_flag char(2) check(terminal_flag IN ('Y', 'N')), unit_flag char(2) check(unit_flag IN ('Y', 'N')), VIP_flag char(2) check(VIP_flag IN ('Y', 'N')), snap_cap_flag char(2) check(snap_cap_flag IN ('Y', 'N')), consent_on_file_flag char(2) check(consent_on_file_flag IN ('Y', 'N')), enlarged_SIG_flag char(2) check(enlarged_SIG_flag IN ('Y', 'N')),aquired_patient_flag char(2) check(aquired_patient_flag IN ('Y', 'N')))");
        statement.executeUpdate("drop table t1");
        statement.executeUpdate(" create table t1 (c1 int not null primary key, c2 int not null unique, c3 int check (c3>=0))");
        statement.executeUpdate(" alter table t1 add column c4 int not null default 1");
        statement.executeUpdate(" alter table t1 add constraint c4_unique UNIQUE(c4)");
        statement.executeUpdate(" alter table t1 add column c5 int check(c5 >= 0)");
        resultSet = statement.executeQuery(" select  c.type from sys.sysconstraints c, sys.systables t where c.tableid = t.tableid and tablename='T1'");
        stringArray = new String[]{"TYPE"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"P"}, {"U"}, {"C"}, {"U"}, {"C"}};
        JDBC.assertUnorderedResultSet(resultSet, objectArray, true);
        CheckConstraintTest.assertStatementError("42Y55", statement, " drop table t2");
        statement.executeUpdate(" create table t2 (c21 int references t1)");
        resultSet = statement.executeQuery(" select c.type from sys.sysconstraints c, sys.systables t where c.tableid = t.tableid and tablename='T2'");
        stringArray = new String[]{"TYPE"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"F"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        CheckConstraintTest.assertStatementError("42Y55", statement, " drop table t3");
        statement.executeUpdate(" create table t3 (c1 int check (c1 >= 0), c2 int check (c2 >= 0), c3 int check (c3 >= 0), c4 int check (c4 >= 0), c5 int check (c5 >= 0), c6 int check (c6 >= 0), c7 int check (c7 >= 0), c8 int check (c8 >= 0), c9 int check (c9 >= 0), c10 int check (c10 >= 0), c11 int check (c11 >= 0), c12 int check (c12 >= 0), c13 int check (c13 >= 0))");
        resultSet = statement.executeQuery(" select c.type from sys.sysconstraints c, sys.systables t where c.tableid = t.tableid and tablename='T3'");
        stringArray = new String[]{"TYPE"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        CheckConstraintTest.assertStatementError("42Y55", statement, " drop table t4");
        statement.executeUpdate(" create table t4(c11 int not null, c12 int not null, primary key (c11, c12))");
        resultSet = statement.executeQuery(" select c.type from sys.sysconstraints c, sys.systables t where c.tableid = t.tableid and tablename='T4'");
        stringArray = new String[]{"TYPE"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"P"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table t4");
        statement.executeUpdate("drop table t3");
        statement.executeUpdate("drop table t2");
        statement.executeUpdate("drop table t1");
        this.commit();
    }

    public void testJira2989() throws SQLException {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("CREATE TABLE \"indicator\" (c CHAR(1) DEFAULT 'N')");
        statement.executeUpdate(" ALTER TABLE  \"indicator\" ADD CONSTRAINT my_constraint CHECK ((c IN ('Y','N')))");
        statement.executeUpdate(" INSERT INTO  \"indicator\" VALUES ('N')");
        statement.executeUpdate(" ALTER TABLE  \"indicator\" DROP CONSTRAINT my_constraint");
        statement.executeUpdate(" DROP TABLE   \"indicator\"");
        this.getConnection().rollback();
        statement.close();
    }

    public void testJira4282() throws SQLException {
        if (CheckConstraintTest.usingEmbedded()) {
            return;
        }
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t4282(c1 int, c2 int, constraint ck1 check(c1 = c2), constraint ck2 check(c2=c1))");
        statement.executeUpdate("insert into t4282 values (1,1),(2,2),(3,3),(4,4)");
        Statement statement2 = this.createStatement();
        statement2.setCursorName("c1");
        ResultSet resultSet = statement2.executeQuery("select * from t4282 for update");
        CheckConstraintTest.assertTrue((String)"Failed to retrieve row for update", (boolean)resultSet.next());
        statement.executeUpdate("update t4282 set c1 = c1 where current of \"c1\"");
        statement2.close();
        statement.close();
        this.dropTable("t4282");
    }

    public void testPrimaryKeyPageSizeDerby3947() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table d3947 (x varchar(1000) primary key)");
        char[] cArray = new char[994];
        PreparedStatement preparedStatement = this.prepareStatement("insert into d3947 values (?)");
        preparedStatement.setString(1, new String(cArray));
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this.checkLargePageSize(statement, "D3947");
        statement.executeUpdate("drop table d3947");
        statement.executeUpdate("create table d3947 (x varchar(1000) not null,  y varchar(1000))");
        statement.executeUpdate("alter table d3947 add constraint constraint1 primary key (x)");
        statement.executeUpdate("alter table d3947 add constraint constraint2 foreign key (y) references d3947(x)");
        this.checkLargePageSize(statement, "D3947");
        CheckConstraintTest.assertStatementError("42X14", statement, "alter table d3947 add constraint constraint3 foreign key (z) references d3947(x)");
        statement.executeUpdate("drop table d3947");
        statement.close();
    }

    private void checkLargePageSize(Statement statement, String string) throws SQLException {
        ResultSet resultSet = statement.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('" + string + "')) T");
        while (resultSet.next()) {
            if ("1".equals(resultSet.getString("isindex"))) {
                CheckConstraintTest.assertEquals((int)32768, (int)resultSet.getInt("pagesize"));
                continue;
            }
            CheckConstraintTest.assertEquals((int)4096, (int)resultSet.getInt("pagesize"));
        }
        resultSet.close();
    }

    public void testDerby6362() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create schema d6362_s1");
        statement.execute("create schema d6362_s2");
        statement.execute("set schema d6362_s1");
        statement.execute("create function f(x int) returns int deterministic language java  parameter style java external name 'java.lang.Math.abs' no sql");
        statement.execute("create type typ external name 'java.util.ArrayList' language java");
        statement.execute("create table d6362_s2.t(x int, constraint c001 check(f(x) < 3))");
        statement.execute("alter table d6362_s2.t add constraint c002 check(f(x) >= 0)");
        statement.execute("alter table d6362_s2.t add constraint c003 check(cast(null as typ) is null)");
        statement.execute("alter table d6362_s2.t add constraint c004 check(f(x) > cos(pi()))");
        statement.execute("alter table d6362_s2.t add constraint c005 check(abs(f(x)) < pi())");
        statement.execute("set schema d6362_s2");
        statement.execute("alter table t add constraint c101 check(x < 3)");
        statement.execute("alter table t add constraint c102 check(t.x < 4)");
        statement.execute("alter table t add constraint c103 check(x <= d6362_s1.f(t.x))");
        statement.execute("alter table t add constraint c201 check(d6362_s2.t.x < 5)");
        statement.execute("alter table t add constraint c202 check(d6362_s1.f(x) < 5)");
        statement.execute("alter table t add constraint c203 check(cast(null as d6362_s1.typ) is null)");
        String[][] stringArray = new String[][]{{"C001", "(\"D6362_S1\".\"F\"(x) < 3)"}, {"C002", "(\"D6362_S1\".\"F\"(x) >= 0)"}, {"C003", "(cast(null as \"D6362_S1\".\"TYP\") is null)"}, {"C004", "(\"D6362_S1\".\"F\"(x) > \"SYSFUN\".\"COS\"(\"SYSFUN\".\"PI\"()))"}, {"C005", "(abs(\"D6362_S1\".\"F\"(x)) < \"SYSFUN\".\"PI\"())"}, {"C101", "(x < 3)"}, {"C102", "(\"D6362_S2\".\"T\".x < 4)"}, {"C103", "(x <= \"D6362_S1\".\"F\"(\"D6362_S2\".\"T\".x))"}, {"C201", "(\"D6362_S2\".\"T\".x < 5)"}, {"C202", "(\"D6362_S1\".\"F\"(x) < 5)"}, {"C203", "(cast(null as \"D6362_S1\".\"TYP\") is null)"}};
        JDBC.assertFullResultSet(statement.executeQuery("select constraintname, checkdefinition from sys.syschecks natural join sys.sysconstraints natural join sys.sysschemas where schemaname = 'D6362_S2' and type = 'C' order by constraintname"), stringArray);
        statement.execute("insert into t values 1,2");
        CheckConstraintTest.assertStatementError("23513", statement, "insert into t values -10");
        CheckConstraintTest.assertStatementError("23513", statement, "insert into t values 10");
    }

    private void setupForBulkInsert(Statement statement, int n) throws SQLException {
        statement.executeUpdate("create table t_bi_1( a int, b int check (b < " + n + "))");
        statement.executeUpdate("create function func () returns int     language java parameter style java deterministic no sql     external name '" + ((Object)((Object)this)).getClass().getName() + ".func'");
    }

    public void testbulkInsert() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        this.setupForBulkInsert(statement, 0);
        CheckConstraintTest.assertStatementError("23513", statement, "call syscs_util.syscs_import_data(     null,     'T_BI_1',     'A, B',     '1, 2',     'extin/t_bi_1.dat',     null, null, null, 0 )");
        this.setupForBulkInsert(statement, 10);
        statement.executeUpdate("create trigger dagstrigger no cascade before insert on t_bi_1     values func() ");
        funcWasCalled = false;
        statement.executeUpdate("call syscs_util.syscs_import_data(     null,     'T_BI_1',     'A, B',     '1, 2',     'extin/t_bi_1.dat',     null, null, null, 0 )");
        CheckConstraintTest.assertTrue((boolean)funcWasCalled);
    }

    public static int func() {
        funcWasCalled = true;
        return 0;
    }
}

