/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;

public class StatementPlanCacheTest
extends BaseJDBCTestCase {
    private static int CACHE_SIZE;
    private int statmentCacheSize = CACHE_SIZE;
    private PreparedStatement cacheInPlanPS_ID;
    private PreparedStatement cacheInPlanPS_TEXT;

    public StatementPlanCacheTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("StatementPlanCacheTest");
        CACHE_SIZE = 100;
        baseTestSuite.addTest(StatementPlanCacheTest.baseSuite("default"));
        baseTestSuite.addTest(StatementPlanCacheTest.suiteWithSizeSet(5));
        baseTestSuite.addTest(StatementPlanCacheTest.suiteWithSizeSet(140));
        baseTestSuite.addTest(DatabasePropertyTestSetup.singleProperty((Test)new StatementPlanCacheTest("noCachingTest"), "derby.language.statementCacheSize", "0", true));
        return new CleanDatabaseTestSetup((Test)baseTestSuite);
    }

    private static Test suiteWithSizeSet(int n) {
        CACHE_SIZE = n;
        String string = Integer.toString(n);
        return DatabasePropertyTestSetup.singleProperty(StatementPlanCacheTest.baseSuite(string), "derby.language.statementCacheSize", string, true);
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("StatementPlanCacheTest:derby.language.statementCacheSize=" + string);
        baseTestSuite.addTestSuite(StatementPlanCacheTest.class);
        return baseTestSuite;
    }

    protected void setUp() throws SQLException {
        this.cacheInPlanPS_ID = this.prepareStatement("SELECT COUNT(ID) FROM SYSCS_DIAG.STATEMENT_CACHE WHERE ID = ?");
        this.cacheInPlanPS_TEXT = this.prepareStatement("SELECT COUNT(ID) FROM SYSCS_DIAG.STATEMENT_CACHE WHERE SCHEMANAME = ? AND SQL_TEXT = ?");
        this.emptyStatementCache();
    }

    @Override
    protected void tearDown() throws Exception {
        this.cacheInPlanPS_ID.close();
        this.cacheInPlanPS_ID = null;
        this.cacheInPlanPS_TEXT.close();
        this.cacheInPlanPS_TEXT = null;
        super.tearDown();
    }

    public void noCachingTest() throws SQLException {
        String string = this.getTestConfiguration().getUserName();
        String string2 = "VALUES 1";
        Statement statement = this.createStatement();
        statement.executeQuery(string2).close();
        statement.close();
        StatementPlanCacheTest.assertFalse((String)string2, (boolean)this.isPlanInCache(string, string2));
        this.prepareStatement(string2).close();
        StatementPlanCacheTest.assertFalse((String)string2, (boolean)this.isPlanInCache(string, string2));
        string2 = "CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)";
        this.prepareCall(string2).close();
        StatementPlanCacheTest.assertFalse((String)string2, (boolean)this.isPlanInCache(string, string2));
    }

    public void testAcrossStatementObjects() throws SQLException {
        String string = this.getTestConfiguration().getUserName();
        String string2 = "CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)";
        string2 = "CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)";
        Statement statement = this.createStatement();
        statement.execute(string2);
        statement.close();
        StatementPlanCacheTest.assertTrue((String)string2, (boolean)this.isPlanInCache(string, string2));
        PreparedStatement preparedStatement = this.prepareStatement(string2);
        StatementPlanCacheTest.assertTrue((String)string2, (boolean)this.isPlanInCache(preparedStatement));
        CallableStatement callableStatement = this.prepareCall(string2);
        StatementPlanCacheTest.assertTrue((String)string2, (boolean)this.isPlanInCache(callableStatement));
        StatementPlanCacheTest.assertEquals((String)preparedStatement.toString(), (String)callableStatement.toString());
        preparedStatement.close();
        callableStatement.close();
    }

    public void testCompileFailuresNotInCache() throws SQLException {
        String string = this.getTestConfiguration().getUserName();
        String string2 = "TO BE OR NOT TO BE";
        this.assertCompileError("42X01", string2);
        StatementPlanCacheTest.assertFalse((String)string2, (boolean)this.isPlanInCache(string, string2));
        string2 = "CREATE PROCEDURE BAD_PROC() EXTERNAL NAME 'lll' LANGUAGE JAVA";
        this.assertCompileError("42X01", string2);
        StatementPlanCacheTest.assertFalse((String)string2, (boolean)this.isPlanInCache(string, string2));
        string2 = "SELECT * FROM NO_SUCH_TABLE_EXISTS";
        this.assertCompileError("42X05", string2);
        StatementPlanCacheTest.assertFalse((String)string2, (boolean)this.isPlanInCache(string, string2));
    }

    public void testPreparedStatementPlanCaching() throws SQLException {
        this.checkPreparedPlanInCache(this.statmentCacheSize, "VALUES &");
    }

    public void testCallableStatementPlanCaching() throws SQLException {
        this.checkPreparedPlanInCache(this.statmentCacheSize, "CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(&)");
    }

    private void checkPreparedPlanInCache(int n, String string) throws SQLException {
        int n2;
        AutoCloseable autoCloseable;
        Object object;
        PreparedStatement preparedStatement;
        int n3;
        boolean bl = string.startsWith("CALL ");
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[stringArray.length];
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            stringArray[n3] = StatementPlanCacheTest.getSQL(string, n3);
            preparedStatement = bl ? this.prepareCall(stringArray[n3]) : this.prepareStatement(stringArray[n3]);
            StatementPlanCacheTest.assertTrue((String)stringArray[n3], (boolean)this.isPlanInCache(preparedStatement));
            stringArray2[n3] = preparedStatement.toString();
            preparedStatement.close();
        }
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            preparedStatement = bl ? this.prepareCall(stringArray[n3]) : this.prepareStatement(stringArray[n3]);
            object = bl ? this.prepareCall(stringArray[n3]) : this.prepareStatement(stringArray[n3]);
            StatementPlanCacheTest.assertTrue((String)stringArray[n3], (boolean)this.isPlanInCache(preparedStatement));
            StatementPlanCacheTest.assertEquals((String)stringArray[n3], (String)stringArray2[n3], (String)preparedStatement.toString());
            StatementPlanCacheTest.assertEquals((String)stringArray[n3], (String)preparedStatement.toString(), (String)object.toString());
            preparedStatement.close();
            object.close();
            autoCloseable = this.openDefaultConnection();
            PreparedStatement preparedStatement2 = bl ? autoCloseable.prepareCall(stringArray[n3]) : autoCloseable.prepareStatement(stringArray[n3]);
            StatementPlanCacheTest.assertEquals((String)stringArray[n3], (String)stringArray2[n3], (String)preparedStatement2.toString());
            preparedStatement2.close();
            autoCloseable.close();
        }
        String string2 = this.getTestConfiguration().getUserName();
        for (n2 = stringArray2.length; n2 < stringArray2.length * 2; ++n2) {
            object = StatementPlanCacheTest.getSQL(string, n2);
            autoCloseable = bl ? this.prepareCall((String)object) : this.prepareStatement((String)object);
            StatementPlanCacheTest.assertTrue((String)object, (boolean)this.isPlanInCache((PreparedStatement)autoCloseable));
            autoCloseable.close();
        }
        n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isPlanInCache(string2, stringArray[i])) continue;
            n2 = 1;
            break;
        }
        StatementPlanCacheTest.assertTrue((String)"Expect a plan to thrown out", n2 != 0);
    }

    private static String getSQL(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf(38);
        stringBuffer.append(string.substring(0, n2));
        stringBuffer.append(n);
        if (n2 + 1 < string.length()) {
            stringBuffer.append(string.substring(n2 + 1));
        }
        return stringBuffer.toString();
    }

    private boolean isPlanInCache(PreparedStatement preparedStatement) throws SQLException {
        this.cacheInPlanPS_ID.setString(1, preparedStatement.toString());
        ResultSet resultSet = this.cacheInPlanPS_ID.executeQuery();
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        StatementPlanCacheTest.assertTrue((String)"Statement in cache multiple times ", (n <= 1 ? 1 : 0) != 0);
        return n == 1;
    }

    private boolean isPlanInCache(String string, String string2) throws SQLException {
        this.cacheInPlanPS_TEXT.setString(1, string);
        this.cacheInPlanPS_TEXT.setString(2, string2);
        ResultSet resultSet = this.cacheInPlanPS_TEXT.executeQuery();
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        StatementPlanCacheTest.assertTrue((String)"Statement in cache multiple times ", (n <= 1 ? 1 : 0) != 0);
        this.cacheInPlanPS_TEXT.clearParameters();
        return n == 1;
    }
}

