/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.perf.basic.jdbc.BaseLoad100IdxTestSetup;
import org.apache.derbyTesting.perf.basic.jdbc.HeapScan;

public class CoveredIdxScan
extends HeapScan {
    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("CoveredIdxScanTests");
        int n = 700;
        int n2 = 4;
        baseTestSuite.addTest((Test)new CoveredIdxScan("ScanCoveredIdxInt", n, n2));
        return new BaseLoad100IdxTestSetup((Test)baseTestSuite, rowcount * 2, tableName);
    }

    public CoveredIdxScan(String string, int n, int n2) {
        super(string, n, n2);
    }

    @Override
    public void setUp() throws Exception {
        this.select = this.prepareStatement("SELECT i1 FROM " + tableName + " WHERE i1 > ? and i1 <= ?");
    }

    @Override
    public void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public void ScanCoveredIdxInt() throws Exception {
        this.select.setInt(1, rowcount * 2 / 4);
        this.select.setInt(2, rowcount * 2 / 4 * 3);
        ResultSet resultSet = this.select.executeQuery();
        int n = 0;
        int n2 = 0;
        while (resultSet.next()) {
            n2 = resultSet.getInt(1);
            ++n;
        }
        CoveredIdxScan.assertEquals((int)rowcount, (int)n);
        resultSet.close();
        this.commit();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }
}

