/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;

public class Java5SystemProcedures {
    private static final int TOOL_NAME = 0;
    private static final int TOOL_CLASS_NAME = 1;
    private static final String CUSTOM_TOOL_CLASS_NAME = "customTool";
    private static final String[][] OPTIONAL_TOOLS = new String[][]{{"databaseMetaData", "org.apache.derby.impl.tools.optional.DBMDWrapper"}, {"foreignViews", "org.apache.derby.impl.tools.optional.ForeignDBViews"}, {"luceneSupport", "org.apache.derby.optional.lucene.LuceneSupport"}, {"optimizerTracing", "org.apache.derby.impl.sql.compile.OptimizerTracer"}, {"optimizerTracingViews", "org.apache.derby.impl.sql.compile.OptTraceViewer"}, {"rawDBReader", "org.apache.derby.optional.dump.RawDBReader"}, {"simpleJson", "org.apache.derby.optional.json.SimpleJsonTool"}};

    public static void SYSCS_REGISTER_TOOL(String toolName, boolean register, String ... optionalArgs) throws SQLException {
        try {
            Class toolClass;
            ClassFactoryContext cfc = (ClassFactoryContext)Java5SystemProcedures.getContext("ClassFactoryContext");
            ClassFactory classFactory = cfc.getClassFactory();
            String toolClassName = Java5SystemProcedures.findToolClassName(toolName, optionalArgs);
            OptionalTool tool = null;
            try {
                toolClass = classFactory.loadApplicationClass(toolClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw Java5SystemProcedures.wrap(cnfe);
            }
            if (!OptionalTool.class.isAssignableFrom(toolClass)) {
                throw Java5SystemProcedures.badCustomTool(toolClassName);
            }
            try {
                tool = (OptionalTool)toolClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException ie) {
                throw Java5SystemProcedures.wrap(ie);
            }
            catch (IllegalAccessException iae) {
                throw Java5SystemProcedures.wrap(iae);
            }
            catch (NoSuchMethodException ie) {
                throw Java5SystemProcedures.wrap(ie);
            }
            catch (InvocationTargetException iae) {
                throw Java5SystemProcedures.wrap(iae);
            }
            if (CUSTOM_TOOL_CLASS_NAME.equals(toolName)) {
                optionalArgs = Java5SystemProcedures.stripCustomClassName(optionalArgs);
            }
            if (register) {
                tool.loadTool(optionalArgs);
            } else {
                tool.unloadTool(optionalArgs);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    private static String findToolClassName(String toolName, String ... optionalArgs) throws StandardException {
        if (CUSTOM_TOOL_CLASS_NAME.equals(toolName)) {
            if (optionalArgs == null || optionalArgs.length == 0) {
                throw Java5SystemProcedures.badTool("null");
            }
            return optionalArgs[0];
        }
        for (String[] descriptor : OPTIONAL_TOOLS) {
            if (!descriptor[0].equals(toolName)) continue;
            return descriptor[1];
        }
        throw Java5SystemProcedures.badTool(toolName);
    }

    private static StandardException badTool(String toolName) {
        return StandardException.newException("X0Y88.S", toolName);
    }

    private static StandardException badCustomTool(String className) {
        return StandardException.newException("X0Y88.S.1", className);
    }

    private static String[] stripCustomClassName(String ... optionalArgs) {
        int count = optionalArgs.length - 1;
        String[] retval = new String[count];
        for (int i = 0; i < count; ++i) {
            retval[i] = optionalArgs[i + 1];
        }
        return retval;
    }

    private static StandardException wrap(Throwable t) {
        return StandardException.plainWrapException(t);
    }

    private static Context getContext(String contextID) {
        return ContextService.getContext(contextID);
    }
}

