/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.impl.io.URLStorageFactory;
import org.apache.derby.io.StorageFile;

class URLFile
extends InputStreamFile<URLStorageFactory> {
    URLFile(URLStorageFactory storageFactory, String path) {
        super(storageFactory, path);
    }

    URLFile(URLStorageFactory storageFactory, String parent, String name) {
        super(storageFactory, parent, name);
    }

    URLFile(URLFile dir, String name) {
        super(dir, name);
    }

    private URLFile(URLStorageFactory storageFactory, String child, int pathLen) {
        super(storageFactory, child, pathLen);
    }

    @Override
    public boolean exists() {
        try {
            InputStream is = this.getInputStream();
            if (is == null) {
                return false;
            }
            is.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    StorageFile getParentDir(int pathLen) {
        return new URLFile((URLStorageFactory)this.storageFactory, this.path, pathLen);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        try {
            URL url = new URI(this.path).toURL();
            return url.openStream();
        }
        catch (IOException ioe) {
            throw new FileNotFoundException(this.path);
        }
        catch (URISyntaxException u) {
            throw new FileNotFoundException(u.getMessage());
        }
        catch (IllegalArgumentException u) {
            throw new FileNotFoundException(u.getMessage());
        }
    }
}

