/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;

public class DataSourcePropertiesTest
extends BaseJDBCTestCase {
    public DataSourcePropertiesTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("DataSourcePropertiesTest");
        if (JDBC.vmSupportsJDBC3()) {
            Method[] methods = DataSourcePropertiesTest.class.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String name;
                Method m = methods[i];
                if (m.getParameterTypes().length > 0 || !m.getReturnType().equals(Void.TYPE) || !(name = m.getName()).startsWith("embedded")) continue;
                suite.addTest((Test)new DataSourcePropertiesTest(name));
            }
        }
        return new CleanDatabaseTestSetup((Test)suite);
    }

    public void embeddedTestAttributesAsPasswordWithoutPassword_ds() throws Exception {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "password", "mypassword");
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.TRUE);
        Connection c = ds.getConnection();
        c.close();
    }

    public void embeddedTestAttributesAsPasswordWithoutPassword_pooled() throws Exception {
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(ds, "password", "mypassword");
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.TRUE);
        PooledConnection pc = ds.getPooledConnection();
        Connection c = pc.getConnection();
        c.close();
    }

    public void embeddedTestAttributesAsPasswordWithoutPassword_xa() throws Exception {
        XADataSource ds = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(ds, "password", "mypassword");
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.TRUE);
        XAConnection xa = ds.getXAConnection();
        Connection c = xa.getConnection();
        c.close();
    }

    public void embeddedTestAttributesAsPasswordWithPassword_ds() throws Exception {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.TRUE);
        try {
            Connection c = ds.getConnection("username", "mypassword");
            DataSourcePropertiesTest.fail((String)"Expected getConnection to fail.");
        }
        catch (SQLException e) {
            DataSourcePropertiesTest.assertSQLState("XJ028", e);
        }
    }

    public void embeddedTestAttributesAsPasswordWithPassword_pooled() throws Exception {
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.TRUE);
        try {
            PooledConnection pc = ds.getPooledConnection("username", "mypassword");
            DataSourcePropertiesTest.fail((String)"Expected getPooledConnection to fail.");
        }
        catch (SQLException e) {
            DataSourcePropertiesTest.assertSQLState("XJ028", e);
        }
    }

    public void embeddedTestAttributesAsPasswordWithPassword_xa() throws Exception {
        XADataSource ds = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(ds, "attributesAsPassword", Boolean.TRUE);
        try {
            XAConnection xa = ds.getXAConnection("username", "mypassword");
            DataSourcePropertiesTest.fail((String)"Expected getXAConnection to fail.");
        }
        catch (SQLException e) {
            DataSourcePropertiesTest.assertSQLState("XJ028", e);
        }
    }
}

