/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LobStreamsTest
extends BaseJDBCTestCase {
    int[] streamSize = new int[2];
    private final String unicodeTestString = "This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)";

    public LobStreamsTest(String name) {
        super(name);
        this.streamSize[0] = 300000;
        this.streamSize[1] = 10000;
    }

    public void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
        Statement stmt1 = this.createStatement();
        stmt1.execute("create table testBlobX1 (a integer, b blob(300K), c clob(300K))");
        stmt1.close();
        byte[] b2 = new byte[]{64};
        String c2 = "c";
        PreparedStatement stmt2 = this.prepareStatement("INSERT INTO testBlobX1(a, b, c) VALUES (?, ?, ?)");
        stmt2.setInt(1, 1);
        stmt2.setBytes(2, b2);
        stmt2.setString(3, c2);
        stmt2.execute();
        stmt2.close();
    }

    public void testGettingBlobTwice() throws Exception {
        this.setAutoCommit(false);
        int length = 72711;
        PreparedStatement ps = this.prepareStatement("insert into testBlobX1(a,b) values (?,?)");
        ps.setInt(1, 2);
        ps.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(length), length);
        ps.executeUpdate();
        ps.close();
        ps = this.prepareStatement("select b from testBlobX1 where a = ?");
        ps.setInt(1, 2);
        ResultSet rs = ps.executeQuery();
        LobStreamsTest.assertTrue((boolean)rs.next());
        Blob b = rs.getBlob(1);
        try {
            LobStreamsTest.assertEquals((long)length, (long)rs.getBlob(1).length());
            LobStreamsTest.fail((String)"Getting the Blob the second time should have failed");
        }
        catch (SQLException sqle) {
            LobStreamsTest.assertSQLState("XCL18", sqle);
        }
        int size = 10240;
        byte[] bytes = null;
        for (int i = 0; i < 50; ++i) {
            bytes = new byte[size * (i + 1)];
        }
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        InputStream is = b.getBinaryStream();
        while (is.read() != -1) {
        }
        LobStreamsTest.assertNotNull((Object)bytes);
    }

    public void testGettingClobTwice() throws SQLException {
        int length = 72711;
        PreparedStatement ps = this.prepareStatement("insert into testBlobX1(a,c) values (?,?)");
        ps.setInt(1, 3);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(length), length);
        ps.executeUpdate();
        ps.setInt(1, 4);
        ps.setString(2, "short clob");
        ps.executeUpdate();
        ps.close();
        int clobCount = 2;
        int count = 0;
        ps = this.prepareStatement("select c from testBlobX1 where a >= ? and a <= ?");
        ps.setInt(1, 3);
        ps.setInt(2, 4);
        ResultSet rs = ps.executeQuery();
        LobStreamsTest.assertTrue((boolean)rs.next());
        do {
            ++count;
            Clob c = rs.getClob(1);
            try {
                rs.getClob(1);
                LobStreamsTest.fail((String)"Getting the Clob the second time should have failed");
            }
            catch (SQLException sqle) {
                LobStreamsTest.assertSQLState("XCL18", sqle);
            }
            try {
                rs.getCharacterStream(1);
                LobStreamsTest.fail((String)"Getting the Clob the third time should have failed");
            }
            catch (SQLException sqle) {
                LobStreamsTest.assertSQLState("XCL18", sqle);
            }
        } while (rs.next());
        rs.close();
        LobStreamsTest.assertEquals((int)2, (int)count);
    }

    public void testBlobWrite3Param() throws Exception {
        LoopingAlphabetStream streamIn = new LoopingAlphabetStream(this.streamSize[0]);
        LobStreamsTest.assertTrue((String)"FAIL -- file not found", (streamIn != null ? 1 : 0) != 0);
        PreparedStatement stmt3 = this.prepareStatement("SELECT b FROM testBlobX1 WHERE a = 1");
        ResultSet rs3 = stmt3.executeQuery();
        rs3.next();
        Blob blob = rs3.getBlob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- blob is NULL", (blob != null ? 1 : 0) != 0);
        int count = 0;
        byte[] buffer = new byte[1024];
        OutputStream outstream = blob.setBinaryStream(1L);
        while ((count = streamIn.read(buffer)) != -1) {
            outstream.write(buffer, 0, count);
        }
        outstream.close();
        streamIn.close();
        PreparedStatement stmt4 = this.prepareStatement("UPDATE testBlobX1 SET b = ? WHERE a = 1");
        stmt4.setBlob(1, blob);
        stmt4.executeUpdate();
        stmt4.close();
        rs3.close();
        rs3 = stmt3.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- blob not found", (boolean)rs3.next());
        blob = rs3.getBlob(1);
        long new_length = blob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong blob length;", (long)this.streamSize[0], (long)new_length);
        LoopingAlphabetStream fStream = new LoopingAlphabetStream(this.streamSize[0]);
        InputStream lStream = blob.getBinaryStream();
        LobStreamsTest.assertTrue((String)"FAIL - Blob and file contents do not match", (boolean)this.compareLob2File(fStream, lStream));
        fStream.close();
        lStream.close();
        rs3.close();
        stmt3.close();
    }

    public void testBlobWrite1Param() throws Exception {
        int buffer;
        LoopingAlphabetStream streamIn = new LoopingAlphabetStream(this.streamSize[1]);
        PreparedStatement stmt3 = this.prepareStatement("SELECT b FROM testBlobX1 WHERE a = 1");
        ResultSet rs3 = stmt3.executeQuery();
        rs3.next();
        Blob blob = rs3.getBlob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- blob is NULL", (blob != null ? 1 : 0) != 0);
        OutputStream outstream = blob.setBinaryStream(1L);
        while ((buffer = ((InputStream)streamIn).read()) != -1) {
            outstream.write(buffer);
        }
        outstream.close();
        streamIn.close();
        PreparedStatement stmt4 = this.prepareStatement("UPDATE testBlobX1 SET b = ? WHERE a = 1");
        stmt4.setBlob(1, blob);
        stmt4.executeUpdate();
        stmt4.close();
        rs3.close();
        rs3 = stmt3.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- blob not found", (boolean)rs3.next());
        blob = rs3.getBlob(1);
        long new_length = blob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong blob length", (long)this.streamSize[1], (long)new_length);
        LoopingAlphabetStream fStream = new LoopingAlphabetStream(this.streamSize[1]);
        InputStream lStream = blob.getBinaryStream();
        LobStreamsTest.assertTrue((String)"FAIL - Blob and file contents do not match", (boolean)this.compareLob2File(fStream, lStream));
        fStream.close();
        lStream.close();
        rs3.close();
        stmt3.close();
    }

    public void testClobAsciiWrite1Param() throws Exception {
        int buffer;
        LoopingAlphabetStream streamIn = new LoopingAlphabetStream(this.streamSize[1]);
        PreparedStatement stmt3 = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet rs3 = stmt3.executeQuery();
        rs3.next();
        Clob clob = rs3.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        OutputStream outstream = clob.setAsciiStream(1L);
        while ((buffer = ((InputStream)streamIn).read()) != -1) {
            outstream.write(buffer);
        }
        outstream.close();
        streamIn.close();
        PreparedStatement stmt4 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        stmt4.setClob(1, clob);
        stmt4.executeUpdate();
        stmt4.close();
        rs3.close();
        rs3 = stmt3.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)rs3.next());
        clob = rs3.getClob(1);
        long new_length = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)this.streamSize[1], (long)new_length);
        LoopingAlphabetStream fStream = new LoopingAlphabetStream(this.streamSize[1]);
        InputStream lStream = clob.getAsciiStream();
        LobStreamsTest.assertTrue((String)"FAIL - Clob and file contents do not match", (boolean)this.compareLob2File(fStream, lStream));
        fStream.close();
        lStream.close();
        rs3.close();
        stmt3.close();
    }

    public void testClobAsciiWrite3Param() throws Exception {
        LoopingAlphabetStream streamIn = new LoopingAlphabetStream(this.streamSize[0]);
        LobStreamsTest.assertTrue((String)"FAIL -- file not found", (streamIn != null ? 1 : 0) != 0);
        PreparedStatement stmt3 = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet rs3 = stmt3.executeQuery();
        rs3.next();
        Clob clob = rs3.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        int count = 0;
        byte[] buffer = new byte[1024];
        OutputStream outstream = clob.setAsciiStream(1L);
        while ((count = streamIn.read(buffer)) != -1) {
            outstream.write(buffer, 0, count);
        }
        outstream.close();
        streamIn.close();
        PreparedStatement stmt4 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        stmt4.setClob(1, clob);
        stmt4.executeUpdate();
        stmt4.close();
        rs3.close();
        rs3 = stmt3.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)rs3.next());
        clob = rs3.getClob(1);
        long new_length = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)this.streamSize[0], (long)new_length);
        LoopingAlphabetStream fStream = new LoopingAlphabetStream(this.streamSize[0]);
        InputStream lStream = clob.getAsciiStream();
        LobStreamsTest.assertTrue((String)"FAIL - Clob and file contents do not match", (boolean)this.compareLob2File(fStream, lStream));
        fStream.close();
        lStream.close();
        rs3.close();
        stmt3.close();
    }

    public void testClobCharacterWrite3ParamChar() throws Exception {
        char[] testdata = "This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".toCharArray();
        PreparedStatement stmt3 = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet rs3 = stmt3.executeQuery();
        rs3.next();
        Clob clob = rs3.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        Writer clobWriter = clob.setCharacterStream(1L);
        clobWriter.write(testdata, 0, testdata.length);
        clobWriter.close();
        PreparedStatement stmt4 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        stmt4.setClob(1, clob);
        stmt4.executeUpdate();
        stmt4.close();
        rs3.close();
        rs3 = stmt3.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)rs3.next());
        clob = rs3.getClob(1);
        long new_length = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)testdata.length, (long)new_length);
        Reader lStream = clob.getCharacterStream();
        LobStreamsTest.assertTrue((String)"FAIL - Clob and buffer contents do not match", (boolean)this.compareClobReader2CharArray(testdata, lStream));
        lStream.close();
        rs3.close();
        stmt3.close();
    }

    public void testClobCharacterWrite3ParamString() throws Exception {
        PreparedStatement stmt3 = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet rs3 = stmt3.executeQuery();
        rs3.next();
        Clob clob = rs3.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        Writer clobWriter = clob.setCharacterStream(1L);
        clobWriter.write("This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)", 0, "This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".length());
        clobWriter.close();
        PreparedStatement stmt4 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        stmt4.setClob(1, clob);
        stmt4.executeUpdate();
        stmt4.close();
        rs3.close();
        rs3 = stmt3.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)rs3.next());
        clob = rs3.getClob(1);
        long new_length = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)"This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".length(), (long)new_length);
        Reader lStream = clob.getCharacterStream();
        LobStreamsTest.assertTrue((String)"FAIL - Clob and buffer contents do not match", (boolean)this.compareClobReader2CharArray("This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".toCharArray(), lStream));
        lStream.close();
        rs3.close();
        stmt3.close();
    }

    public void testClobCharacterWrite1ParamString() throws Exception {
        PreparedStatement stmt3 = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet rs3 = stmt3.executeQuery();
        rs3.next();
        Clob clob = rs3.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        Writer clobWriter = clob.setCharacterStream(1L);
        clobWriter.write("This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)");
        clobWriter.close();
        PreparedStatement stmt4 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        stmt4.setClob(1, clob);
        stmt4.executeUpdate();
        stmt4.close();
        rs3.close();
        rs3 = stmt3.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)rs3.next());
        clob = rs3.getClob(1);
        long new_length = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)"This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".length(), (long)new_length);
        Reader lStream = clob.getCharacterStream();
        LobStreamsTest.assertTrue((String)"FAIL - Clob and buffer contents do not match", (boolean)this.compareClobReader2CharArray("This is a test string containing a few non-ascii characters:\n \u00e6\u00f8\u00e5 and \u00c6\u00d8\u00c5 are used in norwegian: 'Bl\u00e5b\u00e6rsyltet\u00f8y' means 'blueberry jam', and tastes great on pancakes. =)".toCharArray(), lStream));
        lStream.close();
        rs3.close();
        stmt3.close();
    }

    public void testClobCharacterWrite1Char() throws Exception {
        char testchar = 'a';
        PreparedStatement stmt3 = this.prepareStatement("SELECT c FROM testBlobX1 WHERE a = 1");
        ResultSet rs3 = stmt3.executeQuery();
        rs3.next();
        Clob clob = rs3.getClob(1);
        LobStreamsTest.assertTrue((String)"FAIL -- clob is NULL", (clob != null ? 1 : 0) != 0);
        Writer clobWriter = clob.setCharacterStream(1L);
        clobWriter.write(testchar);
        clobWriter.close();
        PreparedStatement stmt4 = this.prepareStatement("UPDATE testBlobX1 SET c = ? WHERE a = 1");
        stmt4.setClob(1, clob);
        stmt4.executeUpdate();
        stmt4.close();
        rs3.close();
        rs3 = stmt3.executeQuery();
        LobStreamsTest.assertTrue((String)"FAIL -- clob not found", (boolean)rs3.next());
        clob = rs3.getClob(1);
        long new_length = clob.length();
        LobStreamsTest.assertEquals((String)"FAIL -- wrong clob length", (long)1L, (long)new_length);
        Reader lStream = clob.getCharacterStream();
        char clobchar = (char)lStream.read();
        LobStreamsTest.assertEquals((String)"FAIL - fetched Clob and original contents do not match", (char)testchar, (char)clobchar);
        lStream.close();
        rs3.close();
        stmt3.close();
    }

    public static Test suite() {
        BaseTestSuite ts = new BaseTestSuite("LobStreamsTest");
        ts.addTest(TestConfiguration.defaultSuite(LobStreamsTest.class));
        if (JDBC.vmSupportsJDBC3()) {
            BaseTestSuite encSuite = new BaseTestSuite("LobStreamsTest:encrypted");
            encSuite.addTestSuite(LobStreamsTest.class);
            ts.addTest(Decorator.encryptedDatabase((Test)encSuite));
        }
        return ts;
    }

    private int readBytesFromStream(byte[] b, InputStream is) throws IOException {
        int read;
        int ret;
        for (read = 0; read < b.length; read += ret) {
            ret = is.read(b, read, b.length - read);
            if (ret >= 0) continue;
            if (read != 0) break;
            return ret;
        }
        return read;
    }

    private boolean compareLob2File(InputStream fStream, InputStream lStream) throws Exception {
        byte[] fByte = new byte[1024];
        byte[] lByte = new byte[1024];
        int lLength = 0;
        int fLength = 0;
        do {
            fLength = this.readBytesFromStream(fByte, fStream);
            lLength = this.readBytesFromStream(lByte, lStream);
            if (Arrays.equals(fByte, lByte)) continue;
            return false;
        } while (fLength > 0 && lLength > 0);
        fStream.close();
        lStream.close();
        return true;
    }

    private boolean compareClobReader2CharArray(char[] cArray, Reader charReader) throws Exception {
        char[] clobChars = new char[cArray.length];
        int readChars = 0;
        int totalCharsRead = 0;
        do {
            if ((readChars = charReader.read(clobChars, totalCharsRead, cArray.length - totalCharsRead)) == -1) continue;
            totalCharsRead += readChars;
        } while (readChars != -1 && totalCharsRead < cArray.length);
        charReader.close();
        return Arrays.equals(cArray, clobChars);
    }
}

