/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SQLSessionContextTest
extends BaseJDBCTestCase {
    private Connection _conn;
    private Statement _stm;
    private static final String pwSuffix = "pwSuffix";
    private static final String userException = "38000";
    private static final String[] users = new String[]{"TEST_DBO"};
    private static final String[] variableKeywords = new String[]{"role", "schema"};
    private static final String[] currentPrefix = new String[]{"current_", "current "};

    public SQLSessionContextTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("SQLSessionContextTest");
        if (!JDBC.vmSupportsJSR169()) {
            suite.addTest(SQLSessionContextTest.positiveSuite("suite: positive, embedded"));
            suite.addTest(TestConfiguration.clientServerDecorator(SQLSessionContextTest.positiveSuite("suite: positive, client")));
        }
        return suite;
    }

    private static Test positiveSuite(String framework) {
        BaseTestSuite usersSuite = new BaseTestSuite("suite: positiveSuite");
        for (int userNo = 0; userNo < users.length; ++userNo) {
            usersSuite.addTest(TestConfiguration.changeUserDecorator((Test)new SQLSessionContextTest("testPositive"), users[userNo], users[userNo].concat(pwSuffix)));
        }
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication((Test)usersSuite, users, pwSuffix));
    }

    public void testPositive() throws SQLException {
        int i;
        PreparedStatement[] ps = new PreparedStatement[]{null, null};
        for (int i2 = 0; i2 < variableKeywords.length; ++i2) {
            String curr = currentPrefix[i2] + variableKeywords[i2];
            ps[i2] = this._conn.prepareStatement("values " + curr);
        }
        SQLSessionContextTest.println("testPositive user=" + this.getTestConfiguration().getUserName());
        this._stm.executeUpdate("set role outermost");
        this._stm.executeUpdate("set schema outermost");
        this._stm.execute("call test_dbo.p2()");
        ResultSet prs = this._stm.getResultSet();
        SQLSessionContextTest.assertCurrent("role", prs, "LEVEL2");
        this._stm.getMoreResults(1);
        prs = this._stm.getResultSet();
        SQLSessionContextTest.assertCurrent("schema", prs, "LEVEL2");
        prs.close();
        for (int i3 = 0; i3 < variableKeywords.length; ++i3) {
            ResultSet rs = ps[i3].executeQuery();
            SQLSessionContextTest.assertCurrent(variableKeywords[i3], rs, "OUTERMOST");
            rs.close();
        }
        ResultSet rs = this._stm.executeQuery("values test_dbo.f2()");
        rs.next();
        rs.close();
        for (int i4 = 0; i4 < variableKeywords.length; ++i4) {
            rs = ps[i4].executeQuery();
            SQLSessionContextTest.assertCurrent(variableKeywords[i4], rs, "OUTERMOST");
            rs.close();
        }
        rs = this._stm.executeQuery("values test_dbo.f2() + test_dbo.f22()");
        rs.next();
        rs.close();
        try {
            rs = this._stm.executeQuery("values test_dbo.f3()");
            rs.next();
        }
        catch (SQLException e) {
            SQLSessionContextTest.assertSQLState(userException, e);
        }
        for (int i5 = 0; i5 < 1; ++i5) {
            rs = ps[i5].executeQuery();
            SQLSessionContextTest.assertCurrent(variableKeywords[i5], rs, "OUTERMOST");
            rs.close();
        }
        this._stm.execute("call test_dbo.dropper()");
        String[] expected = new String[]{null, "TEST_DBO"};
        for (i = 0; i < 1; ++i) {
            rs = ps[i].executeQuery();
            SQLSessionContextTest.assertCurrent(variableKeywords[i], rs, expected[i]);
            rs.close();
        }
        for (i = 0; i < variableKeywords.length; ++i) {
            ps[i].close();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._stm = this.createStatement();
        this._conn = this.getConnection();
        this._stm.executeUpdate("create role outermost");
        this._stm.executeUpdate("create role level2");
        this._stm.executeUpdate("create role innermost");
        this._stm.executeUpdate("create schema outermost");
        this._stm.executeUpdate("create schema level2");
        this._stm.executeUpdate("create schema innermost");
        this._stm.executeUpdate("create procedure p2()  dynamic result sets 2 language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.p2'  modifies sql data");
        this._stm.executeUpdate("create function f2()  returns int language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.f2'  reads sql data");
        this._stm.executeUpdate("create function f22()  returns int language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.f22'  reads sql data");
        this._stm.executeUpdate("create function f3()  returns int language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.f3'  reads sql data");
        this._stm.executeUpdate("create procedure calledNestedFromP2(state VARCHAR(255))  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.calledNestedFromP2'  modifies sql data");
        this._stm.executeUpdate("create procedure dropper()  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.dropper'  modifies sql data");
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this._stm.executeUpdate("set schema test_dbo");
            this._stm.executeUpdate("drop role level2");
            this._stm.executeUpdate("drop role innermost");
            this._stm.executeUpdate("drop schema level2 restrict");
            this._stm.executeUpdate("drop schema innermost restrict");
            this._stm.executeUpdate("drop procedure p2");
            this._stm.executeUpdate("drop function f2");
            this._stm.executeUpdate("drop function f22");
            this._stm.executeUpdate("drop function f3");
            this._stm.executeUpdate("drop procedure calledNestedFromP2");
            this._stm.executeUpdate("drop procedure dropper");
        }
        finally {
            if (this._stm != null) {
                this._stm = null;
            }
            if (this._conn != null) {
                this._conn = null;
            }
            super.tearDown();
        }
    }

    private static void assertCurrent(String sessionVar, ResultSet rs, String expected) throws SQLException {
        SQLSessionContextTest.assertTrue((String)"result set empty", (boolean)rs.next());
        String actualCurrent = rs.getString(1);
        if (sessionVar.equals("role") && expected != null) {
            expected = "\"" + (String)expected + "\"";
        }
        if (expected != null) {
            SQLSessionContextTest.assertTrue((String)(sessionVar + ": current is " + actualCurrent + ", expected " + (String)expected), (boolean)((String)expected).equals(actualCurrent));
        } else {
            SQLSessionContextTest.assertTrue((String)(sessionVar + ": current is " + actualCurrent + ", expected null"), (actualCurrent == null ? 1 : 0) != 0);
        }
        SQLSessionContextTest.assertFalse((String)"result set not empty", (boolean)rs.next());
    }

    public static void p2(ResultSet[] rs1, ResultSet[] rs2) throws Throwable {
        Connection conn1 = null;
        Connection conn2 = null;
        try {
            ResultSet rs;
            PreparedStatement ps;
            String curr;
            int i;
            conn1 = DriverManager.getConnection("jdbc:default:connection");
            for (i = 0; i < variableKeywords.length; ++i) {
                curr = currentPrefix[i] + variableKeywords[i];
                ps = conn1.prepareStatement("values " + curr);
                rs = ps.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], rs, "OUTERMOST");
                rs.close();
                Statement stm = conn1.createStatement();
                stm.executeUpdate("set " + variableKeywords[i] + " level2");
                rs = ps.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], rs, "LEVEL2");
                conn1.commit();
                stm.executeUpdate("call test_dbo.calledNestedFromP2('" + variableKeywords[i] + "')");
                rs = ps.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], rs, "LEVEL2");
                rs.close();
                conn2 = DriverManager.getConnection("jdbc:default:connection");
                PreparedStatement ps2 = conn2.prepareStatement("values " + curr);
                rs = ps2.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], rs, "LEVEL2");
                rs.close();
                ps2.close();
            }
            for (i = 0; i < variableKeywords.length; ++i) {
                curr = currentPrefix[i] + variableKeywords[i];
                ps = conn1.prepareStatement("values " + curr);
                rs = ps.executeQuery();
                if (variableKeywords[i].equals("role")) {
                    rs1[0] = rs;
                    continue;
                }
                rs2[0] = rs;
            }
        }
        catch (Throwable e) {
            SQLSessionContextTest.println("err: " + String.valueOf(e));
            throw e;
        }
        finally {
            if (conn1 != null) {
                try {
                    conn1.close();
                }
                catch (Exception i) {}
            }
            if (conn2 != null) {
                try {
                    conn2.close();
                }
                catch (Exception i) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calledNestedFromP2(String stateString) throws SQLException {
        Connection conn1 = null;
        Connection conn2 = null;
        try {
            conn1 = DriverManager.getConnection("jdbc:default:connection");
            String curr = stateString.equals("role") ? "current_role" : "current schema";
            PreparedStatement ps = conn1.prepareStatement("values " + curr);
            ResultSet rs = ps.executeQuery();
            SQLSessionContextTest.assertCurrent(stateString, rs, "LEVEL2");
            rs.close();
            Statement stm = conn1.createStatement();
            stm.executeUpdate("set " + stateString + " innermost");
            rs = ps.executeQuery();
            SQLSessionContextTest.assertCurrent(stateString, rs, "INNERMOST");
            rs.close();
            ps.close();
            conn2 = DriverManager.getConnection("jdbc:default:connection");
            ps = conn2.prepareStatement("values " + curr);
            rs = ps.executeQuery();
            SQLSessionContextTest.assertCurrent(stateString, rs, "INNERMOST");
            rs.close();
            ps.close();
        }
        finally {
            if (conn1 != null) {
                try {
                    conn1.close();
                }
                catch (Exception exception) {}
            }
            if (conn2 != null) {
                try {
                    conn2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int f2() throws SQLException {
        Connection conn1 = null;
        Connection conn2 = null;
        try {
            conn1 = DriverManager.getConnection("jdbc:default:connection");
            for (int i = 0; i < variableKeywords.length; ++i) {
                String curr = currentPrefix[i] + variableKeywords[i];
                PreparedStatement ps = conn1.prepareStatement("values " + curr);
                ResultSet rs = ps.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], rs, "OUTERMOST");
                rs.close();
                Statement stm = conn1.createStatement();
                stm.executeUpdate("set " + variableKeywords[i] + " level2");
                rs = ps.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], rs, "LEVEL2");
                ps.close();
                conn2 = DriverManager.getConnection("jdbc:default:connection");
                ps = conn2.prepareStatement("values " + curr);
                rs = ps.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], rs, "LEVEL2");
                rs.close();
                ps.close();
            }
        }
        finally {
            if (conn1 != null) {
                try {
                    conn1.close();
                }
                catch (Exception exception) {}
            }
            if (conn2 != null) {
                try {
                    conn2.close();
                }
                catch (Exception exception) {}
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int f22() throws SQLException {
        Connection conn1 = null;
        try {
            conn1 = DriverManager.getConnection("jdbc:default:connection");
            for (int i = 0; i < variableKeywords.length; ++i) {
                String curr = currentPrefix[i] + variableKeywords[i];
                PreparedStatement ps = conn1.prepareStatement("values " + curr);
                ResultSet rs = ps.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], rs, "OUTERMOST");
                rs.close();
                ps.close();
            }
        }
        finally {
            if (conn1 != null) {
                try {
                    conn1.close();
                }
                catch (Exception exception) {}
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int f3() throws SQLException {
        Connection conn1 = null;
        try {
            conn1 = DriverManager.getConnection("jdbc:default:connection");
            Statement stm = conn1.createStatement();
            stm.executeUpdate("set role level2");
            stm.executeUpdate("set schema level2");
            PreparedStatement ps = conn1.prepareStatement("values 42");
            ResultSet rs = ps.executeQuery();
            rs.next();
            rs.next();
            String string = rs.getString(1);
        }
        finally {
            if (conn1 != null) {
                try {
                    conn1.close();
                }
                catch (Exception exception) {}
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropper() throws SQLException {
        Connection conn1 = null;
        try {
            conn1 = DriverManager.getConnection("jdbc:default:connection");
            Statement stm = conn1.createStatement();
            stm.executeUpdate("drop role outermost");
            stm.executeUpdate("drop schema outermost restrict");
            stm.close();
            String[] expected = new String[]{null, "TEST_DBO"};
            for (int i = 0; i < variableKeywords.length; ++i) {
                String curr = currentPrefix[i] + variableKeywords[i];
                PreparedStatement ps = conn1.prepareStatement("values " + curr);
                ResultSet rs = ps.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], rs, expected[i]);
                rs.close();
                ps.close();
            }
        }
        finally {
            if (conn1 != null) {
                try {
                    conn1.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

