/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.harness;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;
import org.apache.derbyTesting.unitTests.harness.T_Bomb;
import org.apache.derbyTesting.unitTests.harness.UnitTest;
import org.apache.derbyTesting.unitTests.harness.UnitTestManager;

public class BasicUnitTestManager
implements UnitTestManager,
ModuleControl {
    private Vector<UnitTest> vectorOfTests;
    private Hashtable<String, String> namesOfTests;
    private static boolean alreadyRun = false;
    private HeaderPrintWriter output;
    private HeaderPrintWriter currentOutput;
    private int testType = 3;
    private int testDuration = 4;
    private boolean reportOutputOn = true;
    private boolean performanceReportOn = false;
    private ContextService contextService;
    private boolean runForever = false;

    public void boot(boolean create, Properties startParams) throws StandardException {
        boolean testStatus = true;
        this.output = Monitor.getStream();
        this.contextService = BasicUnitTestManager.getContextService();
        this.currentOutput = this.output;
        this.vectorOfTests = new Vector();
        this.namesOfTests = new Hashtable();
        this.findTests(startParams, startParams);
        this.findTests(System.getProperties(), startParams);
        this.findTests(BasicUnitTestManager.getMonitor().getApplicationProperties(), startParams);
        if (!alreadyRun) {
            testStatus = this.runTests();
            alreadyRun = true;
        }
        if (!testStatus) {
            System.out.println("Shutting down due to unit test failure.");
            this.output.printlnWithHeader("Shutting down due to unit test failure, see log for more information.");
            BasicUnitTestManager.getMonitor().shutdown();
        }
    }

    public void stop() {
    }

    @Override
    public synchronized void registerTest(UnitTest objectToTest, String testName) {
        if (!this.namesOfTests.containsKey(testName)) {
            this.vectorOfTests.addElement(objectToTest);
            this.namesOfTests.put(testName, testName);
        }
    }

    private void findTests(Properties testList, Properties startParams) {
        if (testList == null) {
            return;
        }
        Enumeration<?> e = testList.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("derby.module.test.")) continue;
            String unitTestClass = testList.getProperty(key);
            try {
                Object unitTest = BasicUnitTestManager.bootServiceModule(false, this, unitTestClass, startParams);
                if (unitTest instanceof UnitTest) {
                    this.registerTest((UnitTest)unitTest, unitTestClass);
                    continue;
                }
                if (unitTest == null) continue;
                System.out.println("class does not implement UnitTest " + unitTestClass);
            }
            catch (StandardException se) {
                System.out.println("exception booting " + unitTestClass);
                System.out.println(se.toString());
                se.printStackTrace(System.out);
            }
        }
    }

    private void emitAMessage(String message) {
        this.currentOutput.printlnWithHeader(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runATest(UnitTest aTest) {
        boolean result;
        String thisTestName = aTest.getClass().getName();
        Date startTime = null;
        ContextManager cm = null;
        if (this.contextService != null) {
            cm = this.contextService.newContextManager();
            this.contextService.setCurrentContextManager(cm);
        }
        if (this.performanceReportOn) {
            startTime = new Date();
        }
        try {
            this.emitAMessage("Starting test  '" + thisTestName + "'.");
            result = aTest.Execute(this.currentOutput);
            if (result) {
                this.emitAMessage("Test '" + thisTestName + "' passed");
            } else {
                this.emitAMessage("Test '" + thisTestName + "' failed");
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                t.printStackTrace(this.output.getPrintWriter());
                Runtime.getRuntime().exit(1);
            }
            result = false;
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.getClass().getName();
            }
            this.emitAMessage("Test '" + thisTestName + "' failed with exception '" + msg + "'.");
            t.printStackTrace(this.output.getPrintWriter());
        }
        finally {
            if (this.contextService != null) {
                this.contextService.resetCurrentContextManager(cm);
            }
        }
        if (this.performanceReportOn) {
            Date endTime = new Date();
            this.emitAMessage("Test '" + thisTestName + "' took " + (endTime.getTime() - startTime.getTime()) + " milliseconds.");
        }
        return result;
    }

    @Override
    public synchronized boolean runTests() {
        boolean result = true;
        int passCount = 0;
        int failCount = 0;
        int skipCount = 0;
        boolean runTests = true;
        runTests = !SanityManager.DEBUG_ON((String)"SkipUnitTests");
        this.runForever = SanityManager.DEBUG_ON((String)"RunForever");
        if (runTests) {
            if (!this.runForever) {
                T_Bomb.makeBomb();
            }
            for (int ix = this.vectorOfTests.size() - 1; ix >= 0; --ix) {
                UnitTest thisTest = this.vectorOfTests.elementAt(ix);
                if (thisTest.UnitTestDuration() <= this.testDuration && thisTest.UnitTestType() <= this.testType) {
                    if (this.runATest(thisTest)) {
                        ++passCount;
                    } else {
                        ++failCount;
                    }
                    this.vectorOfTests.removeElementAt(ix);
                    continue;
                }
                ++skipCount;
            }
            this.emitAMessage("Test Summary - Run " + (passCount + failCount) + ", Passed " + passCount + ", Failed " + failCount + ", Skipped " + skipCount + ".");
        } else {
            this.emitAMessage("Tests not run.");
        }
        return failCount == 0;
    }

    @Override
    public boolean runTests(int testType, int testDuration) {
        this.testType = testType;
        this.testDuration = testDuration;
        return this.runTests();
    }

    @Override
    public void setTestDuration(int testDuration) {
        this.testDuration = testDuration;
    }

    @Override
    public void setTestType(int testType) {
        this.testType = testType;
    }

    @Override
    public void setPerformanceReportOn(boolean performanceReportOn) {
        this.performanceReportOn = performanceReportOn;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object bootServiceModule(boolean create, Object serviceModule, String factoryInterface, Properties properties) throws StandardException {
        try {
            return Monitor.bootServiceModule((boolean)create, (Object)serviceModule, (String)factoryInterface, (Properties)properties);
        }
        catch (Exception pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }
}

