/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.zip.CRC32;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.corruptio.CorruptibleIo;

public class LogChecksumSetup {
    private CorruptibleIo cbio = CorruptibleIo.getInstance();

    LogChecksumSetup() {
    }

    void insertAndCorrupt(Connection connection, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO T1 VALUES(?,?,?)");
        Random random = new Random();
        CRC32 cRC32 = new CRC32();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                this.setupLogCorruption(50, 10);
                bl = true;
            }
            preparedStatement.setInt(1, i);
            byte[] byArray = this.generateBinaryData(random, 90000, 1000 * i);
            preparedStatement.setBytes(2, byArray);
            cRC32.update(byArray, 0, byArray.length);
            cRC32.reset();
            cRC32.update(byArray, 0, byArray.length);
            preparedStatement.setLong(3, cRC32.getValue());
            preparedStatement.executeUpdate();
            connection.commit();
        }
    }

    void updateAndCorrupt(Connection connection, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("update T1 SET DATA=?, DATACHECKSUM=? where ID=?");
        Random random = new Random();
        CRC32 cRC32 = new CRC32();
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                this.setupLogCorruption(50, 10);
                bl = true;
            }
            byte[] byArray = this.generateBinaryData(random, 1234, 5000 * i);
            preparedStatement.setBytes(1, byArray);
            cRC32.update(byArray, 0, byArray.length);
            cRC32.reset();
            cRC32.update(byArray, 0, byArray.length);
            preparedStatement.setLong(2, cRC32.getValue());
            preparedStatement.setInt(3, i);
            n2 += preparedStatement.executeUpdate();
            connection.commit();
        }
    }

    void verifyData(Connection connection, int n) throws SQLException {
        Statement statement = connection.createStatement();
        CRC32 cRC32 = new CRC32();
        ResultSet resultSet = statement.executeQuery("SELECT DATA , DATACHECKSUM, ID FROM T1");
        int n2 = 0;
        while (resultSet.next()) {
            byte[] byArray = resultSet.getBytes(1);
            long l = resultSet.getLong(2);
            int n3 = resultSet.getInt(3);
            cRC32.reset();
            cRC32.update(byArray, 0, byArray.length);
            if (cRC32.getValue() != l) {
                this.logMessage("CHECKSUMs ARE NOT MATCHING");
                this.logMessage("ID=" + n3 + " Checksum From DB:" + l);
                this.logMessage("Recalcaulted sum :" + cRC32.getValue());
                this.logMessage("Length of Data:" + byArray.length);
            }
            ++n2;
        }
        connection.commit();
        if (n2 != n) {
            this.logMessage("Expected Number Of Rows (" + n + ")!=No Of rows in the Table(" + n2 + ")");
        }
    }

    private void createTable(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE T1(ID INT,DATA BLOB(300000),DATACHECKSUM BIGINT)");
        connection.commit();
        statement.close();
    }

    private void setupLogCorruption(int n, int n2) {
        this.cbio.setLogCorruption(true);
        this.cbio.setOffset(n);
        this.cbio.setLength(n2);
    }

    private byte[] generateBinaryData(Random random, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (int i = 0; i < n2; ++i) {
                int n3 = random.nextInt() % n;
                if (n3 < 0) {
                    n3 *= -1;
                }
                dataOutputStream.writeInt(n3);
            }
        }
        catch (IOException iOException) {
            this.logMessage(iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void runTest(Connection connection) throws SQLException {
        this.logMessage("Begin LogCheckum Setup Test");
        this.createTable(connection);
        this.insertAndCorrupt(connection, 11);
        this.logMessage("End LogChecksum Setup Test");
    }

    void logMessage(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) throws Throwable {
        LogChecksumSetup logChecksumSetup = new LogChecksumSetup();
        ij.getPropertyArg((String[])stringArray);
        Connection connection = ij.startJBMS();
        connection.setAutoCommit(false);
        try {
            logChecksumSetup.runTest(connection);
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }
}

