/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import junit.framework.Assert;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.DriverUnloader;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Version;
import org.apache.derbyTesting.junit.BaseTestCase;

public class UpgradeClassLoader {
    private static final Version FIRST_MODULE_SUPPORT_VERSION = new Version(new int[]{10, 15, 0, 0});
    private static final String[] _preModuleSupport_jarFiles = new String[]{"derby.jar", "derbynet.jar", "derbyTesting.jar"};
    private static final String[] _postModuleSupport_jarFiles = new String[]{"derby.jar", "derbynet.jar", "derbyTesting.jar", "derbyshared.jar", "derbytools.jar"};
    static final String oldVersionsPath = UpgradeClassLoader.getSystemProperty("derbyTesting.oldVersionsPath");
    static final String jarPath = UpgradeClassLoader.getSystemProperty("derbyTesting.oldReleasePath");

    private static String getSystemProperty(String string) {
        return System.getProperty(string);
    }

    protected static String getTextVersion(int[] nArray) {
        String string = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        return string;
    }

    public static ClassLoader makeClassLoader(int[] nArray) {
        ClassLoader classLoader = UpgradeClassLoader.createClassLoader(nArray);
        if (classLoader == null) {
            BaseTestCase.traceit("Empty: Skip upgrade Tests (no jars) for " + UpgradeClassLoader.getTextVersion(nArray));
        }
        return classLoader;
    }

    private static String getOldJarLocation(int[] nArray) {
        if (jarPath == null || jarPath.length() == 0) {
            return null;
        }
        String string = UpgradeClassLoader.getTextVersion(nArray);
        String string2 = jarPath + File.separator + string;
        return string2;
    }

    private static String getOldJarURLLocation(int[] nArray) {
        String string = "http://svn.apache.org/repos/asf/db/derby/jars";
        String string2 = UpgradeClassLoader.getTextVersion(nArray);
        String string3 = string + "/" + string2;
        return string3;
    }

    private static ClassLoader createClassLoader(int[] nArray) {
        Version version = new Version(nArray);
        String[] stringArray = version.compareTo(FIRST_MODULE_SUPPORT_VERSION) < 0 ? _preModuleSupport_jarFiles : _postModuleSupport_jarFiles;
        URL[] uRLArray = new URL[stringArray.length + 1];
        String string = UpgradeClassLoader.getOldJarLocation(nArray);
        if (string != null) {
            var5_5 = new File(string);
            if (!((File)var5_5).exists()) {
                BaseTestCase.alarm("Non-existing location for jar files: '" + string + "'. Upgrade tests can NOT be run!");
                return null;
            }
            for (var6_7 = 0; var6_7 < stringArray.length; ++var6_7) {
                try {
                    uRLArray[var6_7] = new File((File)var5_5, stringArray[var6_7]).toURI().toURL();
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    Assert.fail((String)malformedURLException.toString());
                }
            }
        } else {
            var5_5 = UpgradeClassLoader.getOldJarURLLocation(nArray);
            for (var6_7 = 0; var6_7 < stringArray.length; ++var6_7) {
                try {
                    uRLArray[var6_7] = new URI((String)var5_5 + "/" + stringArray[var6_7]).toURL();
                    Object object = uRLArray[var6_7].getContent();
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    Assert.fail((String)malformedURLException.toString());
                    continue;
                }
                catch (URISyntaxException uRISyntaxException) {
                    Assert.fail((String)uRISyntaxException.toString());
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Assert.fail((String)illegalArgumentException.toString());
                    continue;
                }
                catch (IOException iOException) {
                    BaseTestCase.alarm("IOException connecting to location: " + (String)var5_5 + ", msg: '" + iOException.getMessage() + "'. Upgrade tests can NOT be run!");
                    iOException.printStackTrace();
                    return null;
                }
            }
        }
        int n = stringArray.length;
        uRLArray[n] = Assert.class.getProtectionDomain().getCodeSource().getLocation();
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, Connection.class.getClassLoader());
        return new ClassLoader(uRLClassLoader){

            protected Class findClass(String string) throws ClassNotFoundException {
                if (string.equals(DriverUnloader.class.getName())) {
                    try {
                        byte[] byArray = UpgradeClassLoader.fetchDriverUnloaderBytes();
                        return this.defineClass(string, byArray, 0, byArray.length);
                    }
                    catch (IOException iOException) {
                        throw new ClassNotFoundException(string, iOException);
                    }
                }
                throw new ClassNotFoundException(string);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] fetchDriverUnloaderBytes() throws IOException {
        try (InputStream inputStream = DriverUnloader.class.getResourceAsStream("DriverUnloader.class");){
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }
}

