/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class CharacterStreamDescriptorTest
extends BaseTestCase {
    public CharacterStreamDescriptorTest(String string) {
        super(string);
    }

    public void testDefaultValues() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        CharacterStreamDescriptor.Builder builder = new CharacterStreamDescriptor.Builder().stream((InputStream)byteArrayInputStream);
        CharacterStreamDescriptor characterStreamDescriptor = builder.build();
        CharacterStreamDescriptorTest.assertEquals((boolean)false, (boolean)characterStreamDescriptor.isBufferable());
        CharacterStreamDescriptorTest.assertEquals((boolean)false, (boolean)characterStreamDescriptor.isPositionAware());
        CharacterStreamDescriptorTest.assertEquals((long)0L, (long)characterStreamDescriptor.getDataOffset());
        CharacterStreamDescriptorTest.assertEquals((long)0L, (long)characterStreamDescriptor.getCurBytePos());
        CharacterStreamDescriptorTest.assertEquals((long)1L, (long)characterStreamDescriptor.getCurCharPos());
        CharacterStreamDescriptorTest.assertEquals((long)0L, (long)characterStreamDescriptor.getByteLength());
        CharacterStreamDescriptorTest.assertEquals((long)0L, (long)characterStreamDescriptor.getCharLength());
        CharacterStreamDescriptorTest.assertEquals((long)Long.MAX_VALUE, (long)characterStreamDescriptor.getMaxCharLength());
    }

    public void testSetValues() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        CharacterStreamDescriptor.Builder builder = new CharacterStreamDescriptor.Builder().bufferable(true).byteLength(2046L).charLength(1023L).curBytePos(4L).curCharPos(2L).dataOffset(2L).maxCharLength(2459L).stream((InputStream)byteArrayInputStream);
        CharacterStreamDescriptor characterStreamDescriptor = builder.build();
        CharacterStreamDescriptorTest.assertEquals((boolean)true, (boolean)characterStreamDescriptor.isBufferable());
        CharacterStreamDescriptorTest.assertEquals((boolean)false, (boolean)characterStreamDescriptor.isPositionAware());
        CharacterStreamDescriptorTest.assertEquals((long)2L, (long)characterStreamDescriptor.getDataOffset());
        CharacterStreamDescriptorTest.assertEquals((long)4L, (long)characterStreamDescriptor.getCurBytePos());
        CharacterStreamDescriptorTest.assertEquals((long)2L, (long)characterStreamDescriptor.getCurCharPos());
        CharacterStreamDescriptorTest.assertEquals((long)2046L, (long)characterStreamDescriptor.getByteLength());
        CharacterStreamDescriptorTest.assertEquals((long)1023L, (long)characterStreamDescriptor.getCharLength());
        CharacterStreamDescriptorTest.assertEquals((long)2459L, (long)characterStreamDescriptor.getMaxCharLength());
        PositionedTestStream positionedTestStream = new PositionedTestStream(4L);
        characterStreamDescriptor = new CharacterStreamDescriptor.Builder().bufferable(true).positionAware(true).maxCharLength(2459L).stream(positionedTestStream.asInputStream()).build();
        CharacterStreamDescriptorTest.assertEquals((boolean)true, (boolean)characterStreamDescriptor.isBufferable());
        CharacterStreamDescriptorTest.assertEquals((boolean)true, (boolean)characterStreamDescriptor.isPositionAware());
        CharacterStreamDescriptorTest.assertEquals((long)2459L, (long)characterStreamDescriptor.getMaxCharLength());
        characterStreamDescriptor = new CharacterStreamDescriptor.Builder().bufferable(true).positionAware(true).dataOffset(2L).curCharPos(0L).stream(positionedTestStream.asInputStream()).build();
        CharacterStreamDescriptorTest.assertEquals((boolean)true, (boolean)characterStreamDescriptor.isBufferable());
        CharacterStreamDescriptorTest.assertEquals((boolean)true, (boolean)characterStreamDescriptor.isPositionAware());
        CharacterStreamDescriptorTest.assertEquals((long)2L, (long)characterStreamDescriptor.getDataOffset());
        CharacterStreamDescriptorTest.assertEquals((long)0L, (long)characterStreamDescriptor.getCurCharPos());
    }

    public void testCopyState() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        CharacterStreamDescriptor.Builder builder = new CharacterStreamDescriptor.Builder().bufferable(true).byteLength(2046L).charLength(1023L).curBytePos(4L).curCharPos(2L).dataOffset(2L).maxCharLength(3021L).stream((InputStream)byteArrayInputStream);
        CharacterStreamDescriptor characterStreamDescriptor = builder.build();
        CharacterStreamDescriptor.Builder builder2 = new CharacterStreamDescriptor.Builder().copyState(characterStreamDescriptor);
        CharacterStreamDescriptor characterStreamDescriptor2 = builder2.build();
        CharacterStreamDescriptorTest.assertEquals((boolean)characterStreamDescriptor2.isBufferable(), (boolean)characterStreamDescriptor.isBufferable());
        CharacterStreamDescriptorTest.assertEquals((boolean)characterStreamDescriptor2.isPositionAware(), (boolean)characterStreamDescriptor.isPositionAware());
        CharacterStreamDescriptorTest.assertEquals((long)characterStreamDescriptor2.getDataOffset(), (long)characterStreamDescriptor.getDataOffset());
        CharacterStreamDescriptorTest.assertEquals((long)characterStreamDescriptor2.getCurBytePos(), (long)characterStreamDescriptor.getCurBytePos());
        CharacterStreamDescriptorTest.assertEquals((long)characterStreamDescriptor2.getCurCharPos(), (long)characterStreamDescriptor.getCurCharPos());
        CharacterStreamDescriptorTest.assertEquals((long)characterStreamDescriptor2.getByteLength(), (long)characterStreamDescriptor.getByteLength());
        CharacterStreamDescriptorTest.assertEquals((long)characterStreamDescriptor2.getCharLength(), (long)characterStreamDescriptor.getCharLength());
        CharacterStreamDescriptorTest.assertEquals((long)characterStreamDescriptor2.getMaxCharLength(), (long)characterStreamDescriptor.getMaxCharLength());
        CharacterStreamDescriptorTest.assertTrue((characterStreamDescriptor2.getStream() == characterStreamDescriptor.getStream() ? 1 : 0) != 0);
        CharacterStreamDescriptor.Builder builder3 = new CharacterStreamDescriptor.Builder().copyState(characterStreamDescriptor).maxCharLength(8765L);
        CharacterStreamDescriptor characterStreamDescriptor3 = builder3.build();
        CharacterStreamDescriptorTest.assertEquals((long)8765L, (long)characterStreamDescriptor3.getMaxCharLength());
        CharacterStreamDescriptor.Builder builder4 = new CharacterStreamDescriptor.Builder().maxCharLength(8765L).copyState(characterStreamDescriptor);
        CharacterStreamDescriptor characterStreamDescriptor4 = builder4.build();
        CharacterStreamDescriptorTest.assertEquals((long)characterStreamDescriptor.getMaxCharLength(), (long)characterStreamDescriptor4.getMaxCharLength());
    }

    public static Test suite() {
        return new BaseTestSuite(CharacterStreamDescriptorTest.class, "CharacterStreamDescriptorTest suite");
    }

    private static class PositionedTestStream
    extends InputStream
    implements PositionedStream {
        private final long pos;

        PositionedTestStream(long l) {
            this.pos = l;
        }

        @Override
        public int read() throws IOException {
            return -1;
        }

        public InputStream asInputStream() {
            return this;
        }

        public long getPosition() {
            return this.pos;
        }

        public void reposition(long l) throws IOException, StandardException {
        }
    }
}

