/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.criteria.predicate;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.deltaspike.data.impl.criteria.predicate.PredicateBuilder;

public class FetchBuilder<P, R, E>
implements PredicateBuilder<P> {
    private final JoinType joinType;
    private SingularAttribute<? super P, R> singular;
    private PluralAttribute<? super P, R, E> plural;

    public FetchBuilder(SingularAttribute<? super P, R> singular, JoinType joinType) {
        this.joinType = joinType;
        this.singular = singular;
    }

    public FetchBuilder(PluralAttribute<? super P, R, E> plural, JoinType joinType) {
        this.joinType = joinType;
        this.plural = plural;
    }

    @Override
    public List<Predicate> build(CriteriaBuilder builder, Path<P> path) {
        if (this.singular != null) {
            this.fetchSingular((From)path);
        } else if (this.plural != null) {
            this.fetchPlural((From)path);
        }
        return Collections.emptyList();
    }

    SingularAttribute<? super P, R> getSingular() {
        return this.singular;
    }

    void setSingular(SingularAttribute<? super P, R> singular) {
        this.singular = singular;
    }

    PluralAttribute<? super P, R, E> getPlural() {
        return this.plural;
    }

    void setPlural(PluralAttribute<? super P, R, E> plural) {
        this.plural = plural;
    }

    JoinType getJoinType() {
        return this.joinType;
    }

    private void fetchSingular(From path) {
        if (this.joinType == null) {
            path.fetch(this.singular);
        } else {
            path.fetch(this.singular, this.joinType);
        }
    }

    private void fetchPlural(From path) {
        if (this.joinType == null) {
            path.fetch(this.plural);
        } else {
            path.fetch(this.plural, this.joinType);
        }
    }
}

