/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.future;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.apache.deltaspike.core.util.ExceptionUtils;

class J8PromiseCompanionTask<T>
implements Runnable {
    private static final Method COMPLETABLE_FUTURE_COMPLETE;
    private static final Method COMPLETABLE_FUTURE_COMPLETE_ERROR;
    private Object dep;
    private Callable<T> fn;

    J8PromiseCompanionTask(Object dep, Callable<T> fn) {
        this.dep = dep;
        this.fn = fn;
    }

    @Override
    public void run() {
        try {
            COMPLETABLE_FUTURE_COMPLETE.invoke(this.dep, this.fn.call());
        }
        catch (InvocationTargetException e) {
            try {
                COMPLETABLE_FUTURE_COMPLETE_ERROR.invoke(this.dep, e.getCause());
            }
            catch (IllegalAccessException e1) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e1);
            }
            catch (InvocationTargetException e1) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e1.getCause());
            }
        }
        catch (Exception e) {
            try {
                COMPLETABLE_FUTURE_COMPLETE_ERROR.invoke(this.dep, e);
            }
            catch (IllegalAccessException e1) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e1);
            }
            catch (InvocationTargetException e1) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e1.getCause());
            }
        }
    }

    static {
        Class<?> completableFutureClass = null;
        Method completableFutureComplete = null;
        Method completableFutureCompleteError = null;
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            completableFutureClass = classLoader.loadClass("java.util.concurrent.CompletableFuture");
            completableFutureComplete = completableFutureClass.getMethod("complete", Object.class);
            completableFutureCompleteError = completableFutureClass.getMethod("completeExceptionally", Throwable.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        COMPLETABLE_FUTURE_COMPLETE = completableFutureComplete;
        COMPLETABLE_FUTURE_COMPLETE_ERROR = completableFutureCompleteError;
    }
}

