/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.spi.invocation;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.deltaspike.core.util.ReflectionUtils;
import org.apache.deltaspike.proxy.api.DeltaSpikeProxyFactory;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxy;
import org.apache.deltaspike.proxy.spi.invocation.DeltaSpikeProxyInterceptorLookup;
import org.apache.deltaspike.proxy.spi.invocation.DeltaSpikeProxyInvocationContext;
import org.apache.deltaspike.proxy.spi.invocation.DeltaSpikeProxyInvocationWrapperException;

@ApplicationScoped
public class DeltaSpikeProxyInvocationHandler
implements InvocationHandler {
    @Inject
    private BeanManager beanManager;
    @Inject
    private DeltaSpikeProxyInterceptorLookup interceptorLookup;

    @Override
    public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
        List interceptors = this.interceptorLookup.lookup(proxy, method);
        if (interceptors != null && !interceptors.isEmpty()) {
            try {
                DeltaSpikeProxyInvocationContext invocationContext = new DeltaSpikeProxyInvocationContext(this, this.beanManager, interceptors, proxy, method, parameters, null);
                Object returnValue = invocationContext.proceed();
                if (invocationContext.isProceedOriginal()) {
                    return invocationContext.getProceedOriginalReturnValue();
                }
                return returnValue;
            }
            catch (DeltaSpikeProxyInvocationWrapperException e) {
                throw e.getCause();
            }
        }
        return this.proceed(proxy, method, parameters);
    }

    protected Object proceed(Object proxy, Method method, Object[] parameters) throws Throwable {
        DeltaSpikeProxy deltaSpikeProxy = (DeltaSpikeProxy)proxy;
        if (this.contains(deltaSpikeProxy.getDelegateMethods(), method)) {
            return deltaSpikeProxy.getDelegateInvocationHandler().invoke(proxy, method, parameters);
        }
        try {
            Method superAccessorMethod = DeltaSpikeProxyFactory.getSuperAccessorMethod(proxy, method);
            return superAccessorMethod.invoke(proxy, parameters);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    protected boolean contains(Method[] methods, Method method) {
        if (methods == null || methods.length == 0) {
            return false;
        }
        for (Method current : methods) {
            if (!ReflectionUtils.hasSameSignature((Method)method, (Method)current)) continue;
            return true;
        }
        return false;
    }
}

