/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.net.InetAddress;

public final class Network {
    public static final InetAddress LOOPBACK = Network.getLoopbackAddress();
    public static final String LOOPBACK_HOSTNAME = Network.getLoopbackHostName();

    private Network() {
    }

    private static String getLoopbackHostName() {
        InetAddress loopbackAddress = InetAddress.getLoopbackAddress();
        return loopbackAddress.getCanonicalHostName();
    }

    private static InetAddress getLoopbackAddress() {
        return InetAddress.getLoopbackAddress();
    }

    public static String ldapLoopbackUrl(int port) {
        return "ldap://" + LOOPBACK_HOSTNAME + ":" + port;
    }
}

