/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.annotation.AdminPermissionOperation;
import org.apache.directory.fortress.core.AuditMgr;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.ReviewMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AuditP;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.model.AuthZ;
import org.apache.directory.fortress.core.model.Bind;
import org.apache.directory.fortress.core.model.Mod;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAudit;

public class AuditMgrImpl
extends Manageable
implements AuditMgr,
Serializable {
    private static final String CLS_NM = AuditMgrImpl.class.getName();
    private static final AuditP auditP = new AuditP();

    @Override
    @AdminPermissionOperation
    public List<AuthZ> getUserAuthZs(UserAudit uAudit) throws SecurityException {
        String methodName = "getUserAuthZs";
        this.assertContext(CLS_NM, methodName, uAudit, 7001);
        this.checkAccess(CLS_NM, methodName);
        return auditP.getAuthZs(uAudit);
    }

    @Override
    @AdminPermissionOperation
    public List<AuthZ> searchAuthZs(UserAudit uAudit) throws SecurityException {
        String methodName = "searchAuthZs";
        this.assertContext(CLS_NM, methodName, uAudit, 7001);
        this.checkAccess(CLS_NM, methodName);
        return auditP.searchAuthZs(uAudit);
    }

    @Override
    @AdminPermissionOperation
    public List<Bind> searchBinds(UserAudit uAudit) throws SecurityException {
        String methodName = "searchBinds";
        this.assertContext(CLS_NM, methodName, uAudit, 7001);
        this.checkAccess(CLS_NM, methodName);
        return auditP.searchBinds(uAudit);
    }

    @Override
    @AdminPermissionOperation
    public List<Mod> searchUserSessions(UserAudit uAudit) throws SecurityException {
        String methodName = "searchUserSessions";
        this.assertContext(CLS_NM, methodName, uAudit, 7001);
        this.checkAccess(CLS_NM, methodName);
        return auditP.searchUserMods(uAudit);
    }

    @Override
    @AdminPermissionOperation
    public List<Mod> searchAdminMods(UserAudit uAudit) throws SecurityException {
        String methodName = "searchAdminMods";
        this.assertContext(CLS_NM, methodName, uAudit, 7001);
        this.checkAccess(CLS_NM, methodName);
        if (StringUtils.isNotEmpty((CharSequence)uAudit.getUserId())) {
            ReviewMgr rMgr = ReviewMgrFactory.createInstance(this.contextId);
            User user = rMgr.readUser(new User(uAudit.getUserId()));
            uAudit.setInternalUserId(user.getInternalId());
        }
        return auditP.searchAdminMods(uAudit);
    }

    @Override
    @AdminPermissionOperation
    public List<AuthZ> searchInvalidUsers(UserAudit uAudit) throws SecurityException {
        String methodName = "searchInvalidUsers";
        this.assertContext(CLS_NM, methodName, uAudit, 7001);
        this.checkAccess(CLS_NM, methodName);
        return auditP.searchInvalidAuthNs(uAudit);
    }
}

