/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.field;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.text.TextDateElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.common.field.Field;
import org.w3c.dom.Node;

public class DateField
extends Field {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String DEFAULT_DATE_VALUE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.S";
    private TextDateElement dateElement;

    DateField(OdfElement odfElement) {
        TextSpanElement spanElement = (TextSpanElement)((OdfFileDom)odfElement.getOwnerDocument()).newOdfElement(TextSpanElement.class);
        odfElement.appendChild((Node)spanElement);
        this.dateElement = spanElement.newTextDateElement();
        OdfNumberDateStyle dateStyle = this.newDateStyle();
        String dateStyleName = dateStyle.getStyleNameAttribute();
        dateStyle.buildFromFormat(DEFAULT_DATE_FORMAT);
        dateStyle.setStyleNameAttribute(dateStyleName);
        this.dateElement.setStyleDataStyleNameAttribute(dateStyle.getStyleNameAttribute());
        Calendar calender = Calendar.getInstance();
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_DATE_VALUE_FORMAT);
        Date date = calender.getTime();
        String svalue = simpleFormat.format(date);
        this.dateElement.setTextDateValueAttribute(svalue);
        SimpleDateFormat contentFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        this.dateElement.setTextContent(contentFormat.format(date));
        this.dateElement.setTextFixedAttribute(Boolean.valueOf(true));
        Component.registerComponent(this, (OdfElement)this.getOdfElement());
    }

    public void formatDate(String formatString) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_DATE_VALUE_FORMAT);
        String sValue = this.dateElement.getTextDateValueAttribute();
        try {
            Date simpleDate = simpleFormat.parse(sValue);
            SimpleDateFormat newFormat = new SimpleDateFormat(formatString);
            this.dateElement.setTextContent(newFormat.format(simpleDate));
            OdfFileDom dom = (OdfFileDom)this.dateElement.getOwnerDocument();
            OdfOfficeAutomaticStyles styles = null;
            if (dom instanceof OdfContentDom) {
                styles = ((OdfContentDom)dom).getAutomaticStyles();
            } else if (dom instanceof OdfStylesDom) {
                styles = ((OdfStylesDom)dom).getAutomaticStyles();
            }
            OdfNumberDateStyle dataStyle = styles.getDateStyle(this.dateElement.getStyleDataStyleNameAttribute());
            dataStyle.buildFromFormat(formatString);
        }
        catch (ParseException e) {
            Logger.getLogger(DateField.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setFixed(boolean isFixed) {
        this.dateElement.setTextFixedAttribute(Boolean.valueOf(isFixed));
    }

    public TextDateElement getOdfElement() {
        return this.dateElement;
    }

    private OdfNumberDateStyle newDateStyle() {
        OdfFileDom dom = (OdfFileDom)this.dateElement.getOwnerDocument();
        OdfOfficeAutomaticStyles styles = null;
        if (dom instanceof OdfContentDom) {
            styles = ((OdfContentDom)dom).getAutomaticStyles();
        } else if (dom instanceof OdfStylesDom) {
            styles = ((OdfStylesDom)dom).getAutomaticStyles();
        }
        OdfNumberDateStyle newStyle = (OdfNumberDateStyle)dom.newOdfElement(OdfNumberDateStyle.class);
        newStyle.setStyleNameAttribute(this.newUniqueStyleName(styles));
        styles.appendChild((Node)newStyle);
        return newStyle;
    }

    private String newUniqueStyleName(OdfOfficeAutomaticStyles styles) {
        String unique_name;
        while (styles.getTimeStyle(unique_name = String.format("N%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    public Field.FieldType getFieldType() {
        return this.dateElement.getTextFixedAttribute() != false ? Field.FieldType.FIXED_DATE_FIELD : Field.FieldType.DATE_FIELD;
    }
}

