/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.navigation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextHeading;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.common.navigation.Navigation;
import org.odftoolkit.simple.common.navigation.Selection;
import org.odftoolkit.simple.common.navigation.TextSelection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextStyleNavigation
extends Navigation {
    private TextDocument mTextDocument;
    private TextSelection mNextSelectedItem;
    private TextSelection mTempSelectedItem;
    private int mCurrentIndex;
    private Map<OdfStyleProperty, String> mProps;
    private String mText;
    private Node mPhNode;
    private int mIndex;
    private Node mNode;

    public TextStyleNavigation(Map<OdfStyleProperty, String> props, TextDocument doc) {
        this.mTextDocument = doc;
        this.mNextSelectedItem = null;
        this.mTempSelectedItem = null;
        this.mProps = props;
    }

    @Override
    public boolean hasNext() {
        this.mTempSelectedItem = this.findNext(this.mNextSelectedItem);
        return this.mTempSelectedItem != null;
    }

    @Override
    public Selection nextSelection() {
        if (this.mTempSelectedItem != null) {
            this.mNextSelectedItem = this.mTempSelectedItem;
            this.mTempSelectedItem = null;
        } else {
            this.mNextSelectedItem = this.findNext(this.mNextSelectedItem);
        }
        if (this.mNextSelectedItem == null) {
            return null;
        }
        Selection.SelectionManager.registerItem(this.mNextSelectedItem);
        return this.mNextSelectedItem;
    }

    @Override
    public boolean match(Node element) {
        boolean match = false;
        if (element.getNodeType() == 3 && !element.getNodeValue().trim().equals("") && element.getParentNode() instanceof OdfStylableElement) {
            OdfStylableElement parStyleElement = (OdfStylableElement)element.getParentNode();
            String parStyleName = this.getStyleName(parStyleElement);
            if (this.getMatchStyleNames().contains(parStyleName)) {
                match = true;
                this.mText = element.getNodeValue();
                NodeList nodes = this.getPHElement(element.getParentNode()).getChildNodes();
                this.mIndex = 0;
                this.getIndex(nodes, element);
            }
        }
        return match;
    }

    private TextSelection findNext(TextSelection selected) {
        OdfElement element = null;
        try {
            OfficeTextElement rootNode = this.mTextDocument.getContentRoot();
            this.mNode = selected == null ? this.getNextMatchElementInTree((Node)rootNode, (Node)rootNode) : this.getNextMatchElementInTree(this.mNode, (Node)rootNode);
        }
        catch (Exception ex) {
            Logger.getLogger(TextStyleNavigation.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (this.mNode != null) {
            element = (OdfElement)this.getPHElement(this.mNode);
            TextSelection item = new TextSelection(this.mText, element, this.mCurrentIndex);
            return item;
        }
        return null;
    }

    private Node getPHElement(Node node) {
        if (node instanceof OdfTextParagraph) {
            this.mPhNode = node;
        } else if (node instanceof OdfTextHeading) {
            this.mPhNode = node;
        } else {
            this.getPHElement(node.getParentNode());
        }
        return this.mPhNode;
    }

    private void getIndex(NodeList nodes, Node element) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == element) {
                this.mCurrentIndex = this.mIndex;
                break;
            }
            if (node.getNodeType() == 3) {
                this.mIndex += node.getNodeValue().length();
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                try {
                    this.mIndex += Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                }
                catch (Exception e) {
                    ++this.mIndex;
                }
                continue;
            }
            if (node.getLocalName().equals("line-break")) {
                ++this.mIndex;
                continue;
            }
            if (node.getLocalName().equals("tab")) {
                ++this.mIndex;
                continue;
            }
            this.getIndex(node.getChildNodes(), element);
        }
    }

    private String getStyleName(OdfStylableElement element) {
        String stylename = element.getStyleName();
        if (stylename == null) {
            if (element.getParentNode() instanceof OdfStylableElement) {
                this.getStyleName((OdfStylableElement)element.getParentNode());
            } else {
                stylename = "defaultstyle";
            }
        }
        return stylename;
    }

    private Set<String> getMatchStyleNames() {
        HashSet<String> styleNames = new HashSet<String>();
        HashMap<String, OdfDefaultStyle> defaultStyles = new HashMap<String, OdfDefaultStyle>();
        try {
            OdfStyleProperty p;
            boolean isStyle;
            Iterator<OdfStyleProperty> pIter;
            Map map;
            NodeList defStyleList = this.mTextDocument.getDocumentStyles().getElementsByTagName("style:default-style");
            for (int i = 0; i < defStyleList.getLength(); ++i) {
                OdfDefaultStyle defStyle = (OdfDefaultStyle)defStyleList.item(i);
                defaultStyles.put(defStyle.getFamilyName(), defStyle);
            }
            NodeList styleList = this.mTextDocument.getDocumentStyles().getElementsByTagName("style:style");
            for (int i = 0; i < styleList.getLength(); ++i) {
                OdfStyle sStyle = (OdfStyle)styleList.item(i);
                map = sStyle.getStylePropertiesDeep();
                pIter = this.mProps.keySet().iterator();
                isStyle = false;
                while (pIter.hasNext()) {
                    isStyle = false;
                    p = pIter.next();
                    if (!map.containsKey(p) || !((String)map.get(p)).equals(this.mProps.get(p))) break;
                    isStyle = true;
                }
                if (!isStyle) continue;
                String sname = sStyle.getStyleNameAttribute();
                styleNames.add(sname);
            }
            for (OdfStyle cStyle : this.mTextDocument.getContentDom().getAutomaticStyles().getAllStyles()) {
                map = cStyle.getStylePropertiesDeep();
                if (cStyle.getParentStyle() == null && cStyle.getFamilyName().equals("text")) {
                    if (defaultStyles.containsKey("text")) {
                        this.getTextDefaultProperties("text", defaultStyles, map);
                    } else {
                        this.getTextDefaultProperties("paragraph", defaultStyles, map);
                    }
                }
                pIter = this.mProps.keySet().iterator();
                isStyle = false;
                while (pIter.hasNext()) {
                    isStyle = false;
                    p = pIter.next();
                    if (!map.containsKey(p) || !((String)map.get(p)).equals(this.mProps.get(p))) break;
                    isStyle = true;
                }
                if (!isStyle) continue;
                styleNames.add(cStyle.getStyleNameAttribute());
            }
        }
        catch (Exception e1) {
            Logger.getLogger(TextStyleNavigation.class.getName()).log(Level.SEVERE, e1.getMessage(), e1);
        }
        return styleNames;
    }

    private void getTextDefaultProperties(String familyName, HashMap<String, OdfDefaultStyle> defaultStyles, Map<OdfStyleProperty, String> map) {
        OdfStyleFamily family;
        OdfDefaultStyle defStyle = defaultStyles.get(familyName);
        if (defStyle != null && (family = defStyle.getFamily()) != null) {
            for (OdfStyleProperty property : family.getProperties()) {
                if (map.containsKey(property) || !defStyle.hasProperty(property)) continue;
                map.put(property, defStyle.getProperty(property));
            }
        }
    }
}

