/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.granularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.indexer.granularity.BaseGranularitySpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class ArbitraryGranularitySpec
extends BaseGranularitySpec {
    private final Granularity queryGranularity;
    protected BaseGranularitySpec.LookupIntervalBuckets lookupTableBucketByDateTime;

    @JsonCreator
    public ArbitraryGranularitySpec(@JsonProperty(value="queryGranularity") Granularity queryGranularity, @JsonProperty(value="rollup") Boolean rollup, @JsonProperty(value="intervals") @Nullable List<Interval> inputIntervals) {
        super(inputIntervals, rollup);
        this.queryGranularity = queryGranularity == null ? Granularities.NONE : queryGranularity;
        this.lookupTableBucketByDateTime = new BaseGranularitySpec.LookupIntervalBuckets(inputIntervals);
        PeekingIterator intervalIterator = Iterators.peekingIterator(this.sortedBucketIntervals().iterator());
        while (intervalIterator.hasNext()) {
            Interval nextInterval;
            Interval currentInterval = (Interval)intervalIterator.next();
            if (!intervalIterator.hasNext() || !currentInterval.overlaps((ReadableInterval)(nextInterval = (Interval)intervalIterator.peek()))) continue;
            throw new IAE("Overlapping intervals: %s, %s", currentInterval, nextInterval);
        }
    }

    public ArbitraryGranularitySpec(Granularity queryGranularity, List<Interval> inputIntervals) {
        this(queryGranularity, true, inputIntervals);
    }

    @Override
    public Iterable<Interval> sortedBucketIntervals() {
        return () -> this.lookupTableBucketByDateTime.iterator();
    }

    @Override
    public Granularity getSegmentGranularity() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonProperty(value="queryGranularity")
    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArbitraryGranularitySpec that = (ArbitraryGranularitySpec)o;
        if (!this.inputIntervals().equals(that.inputIntervals())) {
            return false;
        }
        if (!this.rollup.equals(that.rollup)) {
            return false;
        }
        return !(this.queryGranularity == null ? that.queryGranularity != null : !this.queryGranularity.equals(that.queryGranularity));
    }

    public int hashCode() {
        int result = this.inputIntervals().hashCode();
        result = 31 * result + this.rollup.hashCode();
        result = 31 * result + (this.queryGranularity != null ? this.queryGranularity.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ArbitraryGranularitySpec{intervals=" + this.inputIntervals() + ", queryGranularity=" + this.queryGranularity + ", rollup=" + this.rollup + "}";
    }

    @Override
    public GranularitySpec withIntervals(List<Interval> inputIntervals) {
        return new ArbitraryGranularitySpec(this.queryGranularity, this.rollup, inputIntervals);
    }

    @Override
    protected BaseGranularitySpec.LookupIntervalBuckets getLookupTableBuckets() {
        return this.lookupTableBucketByDateTime;
    }
}

